/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.AdditionalLanterns;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.core.generator.LanguageGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;

public class LanternLanguageGenerator
extends LanguageGenerator {
    public LanternLanguageGenerator(ResourceCache cache) {
        super("additionallanterns", cache, "en_us");
    }

    public void generate() {
        this.itemGroup((CreativeModeTab)AdditionalLanterns.GROUP, "Additional Lanterns");
        for (LanternMaterial material : LanternMaterial.MATERIALS) {
            this.block(material.getLanternBlock(), (String)(material == LanternMaterial.VANILLA_IRON ? "Lantern" : material.englishTranslation + " Lantern"));
            if (material.canBeColored) {
                for (LanternColor color : LanternColor.values()) {
                    this.block(material.getLanternBlock(color), material == LanternMaterial.VANILLA_IRON ? color.englishTranslation + " Lantern" : color.englishTranslation + " " + material.englishTranslation + " Lantern");
                }
            }
            if (!material.hasChains) continue;
            this.block((Block)material.getChainBlock(), material.englishTranslation + " Chain");
        }
        for (LanternMaterial material : LanternMaterial.MATERIALS) {
            if (!material.canBeColored) continue;
            this.translation("tag.item.additionallanterns." + material.getSuffix() + "_lanterns", material.englishTranslation + " Lanterns");
        }
    }
}

