/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.core.generator.BlockStateGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class LanternBlockStateGenerator
extends BlockStateGenerator {
    public LanternBlockStateGenerator(ResourceCache cache) {
        super("additionallanterns", cache);
    }

    public void generate() {
        for (LanternMaterial material : LanternMaterial.MATERIALS) {
            this.addStates(material);
        }
    }

    public void addStates(LanternMaterial material) {
        this.addState(material, null);
        if (material.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                this.addState(material, color);
            }
        }
        if (material.hasChains) {
            this.addChainState(material);
        }
    }

    public void addState(LanternMaterial material, LanternColor color) {
        this.blockState(material.getLanternBlock(color)).variantsForAllExcept((state, variant) -> variant.model(LanternBlockStateGenerator.getModelLocation(material, color, (Boolean)state.get((Property)BlockStateProperties.HANGING), (Boolean)state.get((Property)LanternBlock.ON), (Boolean)state.get((Property)LanternBlock.REDSTONE))), new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public void addChainState(LanternMaterial material) {
        this.blockState((Block)material.getChainBlock()).variantsForAllExcept((state, variant) -> {
            Direction.Axis axis = (Direction.Axis)state.get((Property)BlockStateProperties.AXIS);
            variant.model(LanternBlockStateGenerator.getChainModelLocation(material), axis == Direction.Axis.X || axis == Direction.Axis.Z ? 90 : 0, axis == Direction.Axis.X ? 90 : 0, false);
        }, new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public static Identifier getModelLocation(LanternMaterial material, LanternColor color, boolean hanging, boolean on, boolean redstone) {
        boolean lit;
        boolean bl = lit = on != redstone;
        return color == null ? (hanging ? (lit ? Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)("block/" + material.getSuffix() + "_hanging_lantern")) : Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)("block/" + material.getSuffix() + "_hanging_lantern_off"))) : (lit ? Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)("block/" + material.getSuffix() + "_lantern")) : Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)("block/" + material.getSuffix() + "_lantern_off")))) : (hanging ? (lit ? Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)("block/" + color.getSuffix() + "_" + material.getSuffix() + "_hanging_lantern")) : Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)("block/" + color.getSuffix() + "_" + material.getSuffix() + "_hanging_lantern_off"))) : (lit ? Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)("block/" + color.getSuffix() + "_" + material.getSuffix() + "_lantern")) : Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)("block/" + color.getSuffix() + "_" + material.getSuffix() + "_lantern_off"))));
    }

    public static Identifier getChainModelLocation(LanternMaterial material) {
        return Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)("block/" + material.getSuffix() + "_chain"));
    }
}

