/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;

public class VanillaLanternEvents {
    public static void registerEventHandlers() {
        PlayerInteractEvent.RightClickBlock.BUS.addListener((byte)-127, VanillaLanternEvents::handleInteractWithLantern);
        BlockEvent.EntityPlaceEvent.BUS.addListener((byte)-127, VanillaLanternEvents::handleLanternPlacement);
        BlockEvent.NeighborNotifyEvent.BUS.addListener((byte)-127, VanillaLanternEvents::handleLanternRedstone);
    }

    private static boolean handleInteractWithLantern(PlayerInteractEvent.RightClickBlock e) {
        LanternMaterial material;
        BlockPos clickedPos;
        Level level = e.getLevel();
        BlockState oldState = level.getBlockState(clickedPos = e.getPos());
        if (oldState.getBlock() instanceof net.minecraft.world.level.block.LanternBlock && (material = LanternMaterial.VANILLA_LANTERN_MAPPINGS.get(oldState.getBlock())) != null) {
            if (!level.isClientSide()) {
                ItemStack stack = e.getItemStack();
                LanternColor color = material.canBeColored && stack.getItem() instanceof DyeItem ? LanternColor.fromDyeColor(((DyeItem)stack.getItem()).getDyeColor()) : null;
                BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)material.getLanternBlock(color).defaultBlockState().setValue((Property)LanternBlock.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)LanternBlock.WATERLOGGED)))).setValue((Property)LanternBlock.HANGING, (Comparable)((Boolean)oldState.getValue((Property)LanternBlock.HANGING)))).setValue((Property)LanternBlock.ON, (Comparable)Boolean.valueOf(color != null))).setValue((Property)LanternBlock.REDSTONE, (Comparable)Boolean.valueOf(level.hasNeighborSignal(clickedPos)));
                level.setBlock(clickedPos, newState, 3);
            }
            e.setCancellationResult((InteractionResult)(level.isClientSide() ? InteractionResult.SUCCESS : InteractionResult.CONSUME));
            return true;
        }
        return false;
    }

    private static void handleLanternPlacement(BlockEvent.EntityPlaceEvent e) {
        LevelAccessor level = e.getLevel();
        if (!level.isClientSide()) {
            LanternMaterial material;
            BlockState oldState = e.getPlacedBlock();
            Block block = oldState.getBlock();
            if (block instanceof LanternBlock) {
                LanternMaterial material2 = ((LanternBlock)block).material;
                if (material2.isVanilla && ((Boolean)oldState.getValue((Property)LanternBlock.ON)).booleanValue() && !e.getLevel().hasNeighborSignal(e.getPos())) {
                    BlockState newState = (BlockState)((BlockState)material2.vanillaLanternBlock.defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)((Boolean)oldState.getValue((Property)LanternBlock.HANGING)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)LanternBlock.WATERLOGGED)));
                    level.setBlock(e.getPos(), newState, 3);
                }
            } else if (block instanceof net.minecraft.world.level.block.LanternBlock && (material = LanternMaterial.VANILLA_LANTERN_MAPPINGS.get(block)) != null && e.getLevel().hasNeighborSignal(e.getPos())) {
                BlockState newState = (BlockState)((BlockState)((BlockState)material.getLanternBlock().defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)((Boolean)oldState.getValue((Property)LanternBlock.HANGING)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)LanternBlock.WATERLOGGED)))).setValue((Property)LanternBlock.REDSTONE, (Comparable)Boolean.valueOf(true));
                level.setBlock(e.getPos(), newState, 3);
            }
        }
    }

    private static void handleLanternRedstone(BlockEvent.NeighborNotifyEvent e) {
        LevelAccessor level = e.getLevel();
        BlockPos originatingPos = e.getPos();
        for (Direction direction : e.getNotifiedSides()) {
            LanternMaterial material;
            BlockPos pos = originatingPos.relative(direction);
            BlockState oldState = level.getBlockState(pos);
            if (!(oldState.getBlock() instanceof net.minecraft.world.level.block.LanternBlock) || !level.hasNeighborSignal(pos) || (material = LanternMaterial.VANILLA_LANTERN_MAPPINGS.get(oldState.getBlock())) == null) continue;
            BlockState newState = (BlockState)((BlockState)((BlockState)material.getLanternBlock().defaultBlockState().setValue((Property)LanternBlock.REDSTONE, (Comparable)Boolean.valueOf(true))).setValue((Property)LanternBlock.HANGING, (Comparable)((Boolean)oldState.getValue((Property)BlockStateProperties.HANGING)))).setValue((Property)LanternBlock.WATERLOGGED, (Comparable)((Boolean)oldState.getValue((Property)BlockStateProperties.WATERLOGGED)));
            level.setBlock(pos, newState, 3);
        }
    }
}

