/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.additionallanterns.AdditionalLanterns;
import com.supermartijn642.additionallanterns.ChainBlock;
import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.WeatheringChainBlock;
import com.supermartijn642.additionallanterns.WeatheringLanternBlock;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class LanternMaterial {
    public static final List<LanternMaterial> MATERIALS = new ArrayList<LanternMaterial>();
    public static final LanternMaterial AMETHYST = LanternMaterial.createWithChain("amethyst", "Amethyst", () -> Items.AMETHYST_SHARD, null, 1, () -> Items.AMETHYST_BLOCK, () -> Items.AMETHYST_SHARD, 4);
    public static final LanternMaterial ANDESITE = LanternMaterial.createWithChain("andesite", "Andesite", () -> Items.ANDESITE, null, 4, () -> Items.ANDESITE, () -> Items.ANDESITE, 8);
    public static final LanternMaterial BASALT = LanternMaterial.createWithChain("basalt", "Basalt", () -> Items.BASALT, null, 4, () -> Items.BASALT, () -> Items.BASALT, 8);
    public static final LanternMaterial BLACKSTONE = LanternMaterial.createWithChain("blackstone", "Blackstone", () -> Items.BLACKSTONE, null, 4, () -> Items.BLACKSTONE, () -> Items.BLACKSTONE, 8);
    public static final LanternMaterial BONE = LanternMaterial.createWithChain("bone", "Bone", () -> Items.BONE, () -> Items.BONE, 1, () -> Items.BONE_BLOCK, () -> Items.BONE, 3);
    public static final LanternMaterial BRICKS = LanternMaterial.createWithChain("bricks", "Brick", () -> Items.BRICK, null, 1, () -> Items.BRICKS, () -> Items.BRICK, 4);
    public static final LanternMaterial COBBLESTONE = LanternMaterial.createWithChain("cobblestone", "Cobblestone", () -> Items.COBBLESTONE, null, 4, () -> Items.COBBLESTONE, () -> Items.COBBLESTONE, 8);
    public static final LanternMaterial COBBLED_DEEPSLATE = LanternMaterial.createWithChain("cobbled_deepslate", "Cobbled Deepslate", () -> Items.COBBLED_DEEPSLATE, null, 4, () -> Items.COBBLED_DEEPSLATE, () -> Items.COBBLED_DEEPSLATE, 8);
    public static final LanternMaterial COPPER = LanternMaterial.createWithoutChain("copper", "Ordinary Copper", () -> Items.COPPER_INGOT, null, 1);
    public static final LanternMaterial CRIMSON = LanternMaterial.createWithChain("crimson", "Crimson", () -> Items.CRIMSON_PLANKS, null, 4, () -> Items.CRIMSON_PLANKS, () -> Items.CRIMSON_PLANKS, 8);
    public static final LanternMaterial DARK_PRISMARINE = LanternMaterial.createWithChain("dark_prismarine", "Dark Prismarine", () -> Items.DARK_PRISMARINE, null, 1, () -> Items.DARK_PRISMARINE, () -> Items.PRISMARINE_SHARD, 4);
    public static final LanternMaterial DEEPSLATE_BRICKS = LanternMaterial.createWithChain("deepslate_bricks", "Deepslate Bricks", () -> Items.DEEPSLATE_BRICKS, null, 4, () -> Items.DEEPSLATE_BRICKS, () -> Items.DEEPSLATE_BRICKS, 8);
    public static final LanternMaterial DIAMOND = LanternMaterial.createWithChain("diamond", "Diamond", () -> Items.DIAMOND, null, 1, () -> Items.DIAMOND, () -> Items.DIAMOND, 3);
    public static final LanternMaterial DIORITE = LanternMaterial.createWithChain("diorite", "Diorite", () -> Items.DIORITE, null, 4, () -> Items.DIORITE, () -> Items.DIORITE, 8);
    public static final LanternMaterial EMERALD = LanternMaterial.createWithChain("emerald", "Emerald", () -> Items.EMERALD, null, 1, () -> Items.EMERALD, () -> Items.EMERALD, 3);
    public static final LanternMaterial END_STONE = LanternMaterial.createWithChain("end_stone", "End Stone", () -> Items.END_STONE, null, 4, () -> Items.END_STONE, () -> Items.END_STONE, 8);
    public static final LanternMaterial EXPOSED_COPPER = LanternMaterial.createWithoutChain("exposed_copper", "Exposed Ordinary Copper", null, null, 0);
    public static final LanternMaterial GOLD = LanternMaterial.createWithChain("gold", "Gold", () -> Items.GOLD_NUGGET, (ItemLike)Items.GOLD_NUGGET, 1, () -> Items.GOLD_INGOT, () -> Items.GOLD_NUGGET, 1);
    public static final LanternMaterial GRANITE = LanternMaterial.createWithChain("granite", "Granite", () -> Items.GRANITE, null, 4, () -> Items.GRANITE, () -> Items.GRANITE, 8);
    public static final LanternMaterial IRON = LanternMaterial.createWithoutChain("iron", "Rough Iron", () -> Items.IRON_INGOT, null, 1);
    public static final LanternMaterial MOSSY_COBBLESTONE = LanternMaterial.createWithChain("mossy_cobblestone", "Mossy Cobblestone", () -> Items.MOSSY_COBBLESTONE, null, 4, () -> Items.MOSSY_COBBLESTONE, () -> Items.COBBLESTONE, 8);
    public static final LanternMaterial NETHERITE = LanternMaterial.createWithChain("netherite", "Netherite", () -> Items.NETHERITE_INGOT, null, 1, () -> Items.NETHERITE_INGOT, () -> Items.NETHERITE_INGOT, 3);
    public static final LanternMaterial NORMAL_NETHER_BRICKS = LanternMaterial.createWithChain("normal_nether_bricks", "Nether Brick", () -> Items.NETHER_BRICK, null, 1, () -> Items.NETHER_BRICKS, () -> Items.NETHER_BRICK, 3);
    public static final LanternMaterial NORMAL_SANDSTONE = LanternMaterial.createWithChain("normal_sandstone", "Sandstone", () -> Items.SANDSTONE, null, 4, () -> Items.SANDSTONE, () -> Items.SANDSTONE, 8);
    public static final LanternMaterial OBSIDIAN = LanternMaterial.createWithChain("obsidian", "Obsidian", () -> Items.OBSIDIAN, null, 4, () -> Items.OBSIDIAN, () -> Items.OBSIDIAN, 8);
    public static final LanternMaterial OXIDIZED_COPPER = LanternMaterial.createWithoutChain("oxidized_copper", "Oxidized Ordinary Copper", null, null, 0);
    public static final LanternMaterial PRISMARINE = LanternMaterial.createWithChain("prismarine", "Prismarine", () -> Items.PRISMARINE_SHARD, null, 1, () -> Items.PRISMARINE_BRICKS, () -> Items.PRISMARINE_SHARD, 4);
    public static final LanternMaterial PURPUR = LanternMaterial.createWithChain("purpur", "Purpur", () -> Items.POPPED_CHORUS_FRUIT, null, 1, () -> Items.PURPUR_BLOCK, () -> Items.POPPED_CHORUS_FRUIT, 4);
    public static final LanternMaterial QUARTZ = LanternMaterial.createWithChain("quartz", "Quartz", () -> Items.QUARTZ, () -> Items.QUARTZ, 1, () -> Items.QUARTZ_BLOCK, () -> Items.QUARTZ, 4);
    public static final LanternMaterial RED_NETHER_BRICKS = LanternMaterial.createWithChain("red_nether_bricks", "Red Nether Brick", () -> Items.RED_NETHER_BRICKS, null, 4, () -> Items.RED_NETHER_BRICKS, () -> Items.NETHER_BRICK, 8);
    public static final LanternMaterial RED_SANDSTONE = LanternMaterial.createWithChain("red_sandstone", "Red Sandstone", () -> Items.RED_SANDSTONE, null, 4, () -> Items.RED_SANDSTONE, () -> Items.RED_SANDSTONE, 8);
    public static final LanternMaterial SMOOTH_STONE = LanternMaterial.createWithChain("smooth_stone", "Smooth Stone", () -> Items.SMOOTH_STONE, null, 4, () -> Items.SMOOTH_STONE, () -> Items.SMOOTH_STONE, 8);
    public static final LanternMaterial STONE = LanternMaterial.createWithChain("stone", "Stone", () -> Items.STONE, null, 4, () -> Items.STONE, () -> Items.STONE, 8);
    public static final LanternMaterial STONE_BRICKS = LanternMaterial.createWithChain("stone_bricks", "Stone Bricks", () -> Items.STONE_BRICKS, null, 4, () -> Items.STONE_BRICKS, () -> Items.STONE_BRICKS, 8);
    public static final LanternMaterial VANILLA_IRON = LanternMaterial.createVanilla("vanilla_iron", "Iron", Blocks.LANTERN, Blocks.IRON_CHAIN, Identifier.withDefaultNamespace((String)"block/lantern"), null, Identifier.withDefaultNamespace((String)"block/iron_chain"));
    public static final LanternMaterial VANILLA_COPPER = LanternMaterial.createVanilla("vanilla_copper", "Copper", Blocks.COPPER_LANTERN.unaffected(), Blocks.COPPER_CHAIN.unaffected(), Identifier.withDefaultNamespace((String)"block/copper_lantern"), Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)"block/copper_lantern_off"), Identifier.withDefaultNamespace((String)"block/copper_chain"));
    public static final LanternMaterial VANILLA_EXPOSED_COPPER = LanternMaterial.createVanilla("vanilla_exposed_copper", "Exposed Copper", Blocks.COPPER_LANTERN.exposed(), Blocks.COPPER_CHAIN.exposed(), Identifier.withDefaultNamespace((String)"block/exposed_copper_lantern"), Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)"block/exposed_copper_lantern_off"), Identifier.withDefaultNamespace((String)"block/exposed_copper_chain"));
    public static final LanternMaterial VANILLA_OXIDIZED_COPPER = LanternMaterial.createVanilla("vanilla_oxidized_copper", "Oxidized Copper", Blocks.COPPER_LANTERN.oxidized(), Blocks.COPPER_CHAIN.oxidized(), Identifier.withDefaultNamespace((String)"block/oxidized_copper_lantern"), Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)"block/oxidized_copper_lantern_off"), Identifier.withDefaultNamespace((String)"block/oxidized_copper_chain"));
    public static final LanternMaterial VANILLA_WEATHERED_COPPER = LanternMaterial.createVanilla("vanilla_weathered_copper", "Weathered Copper", Blocks.COPPER_LANTERN.weathered(), Blocks.COPPER_CHAIN.weathered(), Identifier.withDefaultNamespace((String)"block/weathered_copper_lantern"), Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)"block/weathered_copper_lantern_off"), Identifier.withDefaultNamespace((String)"block/weathered_copper_chain"));
    public static final LanternMaterial VANILLA_WAXED_COPPER = LanternMaterial.createVanilla("vanilla_waxed_copper", "Waxed Copper", Blocks.COPPER_LANTERN.waxed(), Blocks.COPPER_CHAIN.waxed(), Identifier.withDefaultNamespace((String)"block/copper_lantern"), Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)"block/copper_lantern_off"), Identifier.withDefaultNamespace((String)"block/copper_chain"));
    public static final LanternMaterial VANILLA_WAXED_EXPOSED_COPPER = LanternMaterial.createVanilla("vanilla_waxed_exposed_copper", "Waxed Exposed Copper", Blocks.COPPER_LANTERN.waxedExposed(), Blocks.COPPER_CHAIN.waxedExposed(), Identifier.withDefaultNamespace((String)"block/exposed_copper_lantern"), Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)"block/exposed_copper_lantern_off"), Identifier.withDefaultNamespace((String)"block/exposed_copper_chain"));
    public static final LanternMaterial VANILLA_WAXED_OXIDIZED_COPPER = LanternMaterial.createVanilla("vanilla_waxed_oxidized_copper", "Waxed Oxidized Copper", Blocks.COPPER_LANTERN.waxedOxidized(), Blocks.COPPER_CHAIN.waxedOxidized(), Identifier.withDefaultNamespace((String)"block/oxidized_copper_lantern"), Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)"block/oxidized_copper_lantern_off"), Identifier.withDefaultNamespace((String)"block/oxidized_copper_chain"));
    public static final LanternMaterial VANILLA_WAXED_WEATHERED_COPPER = LanternMaterial.createVanilla("vanilla_waxed_weathered_copper", "Waxed Weathered Copper", Blocks.COPPER_LANTERN.waxedWeathered(), Blocks.COPPER_CHAIN.waxedWeathered(), Identifier.withDefaultNamespace((String)"block/weathered_copper_lantern"), Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)"block/weathered_copper_lantern_off"), Identifier.withDefaultNamespace((String)"block/weathered_copper_chain"));
    public static final LanternMaterial WARPED = LanternMaterial.createWithChain("warped", "Warped", () -> Items.WARPED_PLANKS, null, 4, () -> Items.WARPED_PLANKS, () -> Items.WARPED_PLANKS, 8);
    public static final LanternMaterial WAXED_COPPER = LanternMaterial.createWithoutChain("waxed_copper", "Waxed Ordinary Copper", null, null, 0);
    public static final LanternMaterial WAXED_EXPOSED_COPPER = LanternMaterial.createWithoutChain("waxed_exposed_copper", "Waxed Exposed Ordinary Copper", null, null, 0);
    public static final LanternMaterial WAXED_OXIDIZED_COPPER = LanternMaterial.createWithoutChain("waxed_oxidized_copper", "Waxed Oxidized Ordinary Copper", null, null, 0);
    public static final LanternMaterial WAXED_WEATHERED_COPPER = LanternMaterial.createWithoutChain("waxed_weathered_copper", "Waxed Weathered Ordinary Copper", null, null, 0);
    public static final LanternMaterial WEATHERED_COPPER = LanternMaterial.createWithoutChain("weathered_copper", "Weathered Ordinary Copper", null, null, 0);
    private static final Map<LanternMaterial, WeatheringCopper.WeatherState> WEATHERING_BLOCKS = ImmutableMap.builder().put((Object)VANILLA_COPPER, (Object)WeatheringCopper.WeatherState.UNAFFECTED).put((Object)VANILLA_EXPOSED_COPPER, (Object)WeatheringCopper.WeatherState.EXPOSED).put((Object)VANILLA_WEATHERED_COPPER, (Object)WeatheringCopper.WeatherState.WEATHERED).put((Object)VANILLA_OXIDIZED_COPPER, (Object)WeatheringCopper.WeatherState.OXIDIZED).put((Object)COPPER, (Object)WeatheringCopper.WeatherState.UNAFFECTED).put((Object)EXPOSED_COPPER, (Object)WeatheringCopper.WeatherState.EXPOSED).put((Object)WEATHERED_COPPER, (Object)WeatheringCopper.WeatherState.WEATHERED).put((Object)OXIDIZED_COPPER, (Object)WeatheringCopper.WeatherState.OXIDIZED).build();
    public static final Map<LanternMaterial, LanternMaterial> WAXING_MAPPINGS = ImmutableMap.builder().put((Object)VANILLA_COPPER, (Object)VANILLA_WAXED_COPPER).put((Object)VANILLA_EXPOSED_COPPER, (Object)VANILLA_WAXED_EXPOSED_COPPER).put((Object)VANILLA_WEATHERED_COPPER, (Object)VANILLA_WAXED_WEATHERED_COPPER).put((Object)VANILLA_OXIDIZED_COPPER, (Object)VANILLA_WAXED_OXIDIZED_COPPER).put((Object)COPPER, (Object)WAXED_COPPER).put((Object)EXPOSED_COPPER, (Object)WAXED_EXPOSED_COPPER).put((Object)WEATHERED_COPPER, (Object)WAXED_WEATHERED_COPPER).put((Object)OXIDIZED_COPPER, (Object)WAXED_OXIDIZED_COPPER).build();
    public static final Map<LanternMaterial, LanternMaterial> OXIDATION_MAPPINGS = ImmutableMap.builder().put((Object)VANILLA_COPPER, (Object)VANILLA_EXPOSED_COPPER).put((Object)VANILLA_EXPOSED_COPPER, (Object)VANILLA_WEATHERED_COPPER).put((Object)VANILLA_WEATHERED_COPPER, (Object)VANILLA_OXIDIZED_COPPER).put((Object)COPPER, (Object)EXPOSED_COPPER).put((Object)EXPOSED_COPPER, (Object)WEATHERED_COPPER).put((Object)WEATHERED_COPPER, (Object)OXIDIZED_COPPER).build();
    public static final Map<Block, LanternMaterial> VANILLA_LANTERN_MAPPINGS;
    private final String identifier;
    public final boolean isVanilla;
    public final Block vanillaLanternBlock;
    public final Block vanillaChainBlock;
    public final boolean canBeColored;
    public final boolean hasChains;
    private LanternBlock lanternBlock;
    private final Map<LanternColor, LanternBlock> coloredLanternBlocks = new EnumMap<LanternColor, LanternBlock>(LanternColor.class);
    private ChainBlock chainBlock;
    private Item lanternItem;
    private final Map<LanternColor, Item> coloredLanternItems = new EnumMap<LanternColor, Item>(LanternColor.class);
    private Item chainItem;
    public final String englishTranslation;
    public final ItemLike primaryLanternIngredient;
    public final ItemLike secondaryLanternIngredient;
    public final int lanternRecipeCount;
    public final ItemLike primaryChainIngredient;
    public final ItemLike secondaryChainIngredient;
    public final int chainRecipeCount;
    public final Identifier lanternTexture;
    public final Identifier lanternOffTexture;
    public final Identifier chainTexture;

    private static LanternMaterial createWithChain(String identifier, String englishTranslation, ItemLike primaryLanternIngredient, ItemLike secondaryLanternIngredient, int lanternRecipeCount, ItemLike primaryChainIngredient, ItemLike secondaryChainIngredient, int chainRecipeCount) {
        LanternMaterial material = new LanternMaterial(identifier, false, null, null, true, true, englishTranslation, primaryLanternIngredient, secondaryLanternIngredient, lanternRecipeCount, primaryChainIngredient, secondaryChainIngredient, chainRecipeCount, null, null, null);
        MATERIALS.add(material);
        return material;
    }

    private static LanternMaterial createWithoutChain(String identifier, String englishTranslation, ItemLike primaryLanternIngredient, ItemLike secondaryLanternIngredient, int lanternRecipeCount) {
        LanternMaterial material = new LanternMaterial(identifier, false, null, null, true, false, englishTranslation, primaryLanternIngredient, secondaryLanternIngredient, lanternRecipeCount, null, null, 0, null, null, null);
        MATERIALS.add(material);
        return material;
    }

    private static LanternMaterial createVanilla(String identifier, String englishTranslation, Block vanillaLanternBlock, Block vanillaChainBlock, Identifier lanternTexture, Identifier lanternOffTexture, Identifier vanillaChainTexture) {
        LanternMaterial material = new LanternMaterial(identifier, true, vanillaLanternBlock, vanillaChainBlock, true, false, englishTranslation, null, null, 0, null, null, 0, lanternTexture, lanternOffTexture, vanillaChainTexture);
        MATERIALS.add(material);
        return material;
    }

    LanternMaterial(String identifier, boolean isVanilla, Block vanillaLanternBlock, Block vanillaChainBlock, boolean canBeColored, boolean hasChains, String englishTranslation, ItemLike primaryLanternIngredient, ItemLike secondaryLanternIngredient, int lanternRecipeCount, ItemLike primaryChainIngredient, ItemLike secondaryChainIngredient, int chainRecipeCount, Identifier lanternTexture, Identifier lanternOffTexture, Identifier chainTexture) {
        this.identifier = identifier;
        this.isVanilla = isVanilla;
        this.vanillaLanternBlock = vanillaLanternBlock;
        this.vanillaChainBlock = vanillaChainBlock;
        this.canBeColored = canBeColored;
        this.hasChains = hasChains;
        this.englishTranslation = englishTranslation;
        this.primaryLanternIngredient = primaryLanternIngredient;
        this.secondaryLanternIngredient = secondaryLanternIngredient;
        this.lanternRecipeCount = lanternRecipeCount;
        this.primaryChainIngredient = primaryChainIngredient;
        this.secondaryChainIngredient = secondaryChainIngredient;
        this.chainRecipeCount = chainRecipeCount;
        this.lanternTexture = lanternTexture;
        this.lanternOffTexture = lanternOffTexture;
        this.chainTexture = chainTexture;
    }

    public Block getLanternBlock() {
        return this.lanternBlock;
    }

    public Block getLanternBlock(LanternColor color) {
        if (color == null) {
            return this.getLanternBlock();
        }
        return (Block)this.coloredLanternBlocks.get((Object)color);
    }

    public ChainBlock getChainBlock() {
        return this.chainBlock;
    }

    public String getSuffix() {
        return this.identifier;
    }

    private String getLanternIdentifier(LanternColor color) {
        if (color == null) {
            return this.getSuffix() + "_lantern";
        }
        return color.getSuffix() + "_" + this.getSuffix() + "_lantern";
    }

    private String getChainIdentifier() {
        return this.getSuffix() + "_chain";
    }

    public BlockBehaviour.Properties getLanternBlockProperties(LanternColor color) {
        BlockBehaviour.Properties properties = this.isVanilla ? BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)this.vanillaLanternBlock) : BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN);
        properties.lightLevel(state -> LanternBlock.emitsLight(state) ? 15 : 0).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)this.getLanternIdentifier(color))));
        return WEATHERING_BLOCKS.get(this) == null ? properties : properties.randomTicks();
    }

    public BlockBehaviour.Properties getChainBlockProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_CHAIN).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier.fromNamespaceAndPath((String)"additionallanterns", (String)this.getChainIdentifier())));
    }

    public void registerBlocks(RegistrationHandler.Helper<Block> helper) {
        if (this.lanternBlock != null) {
            throw new IllegalStateException("Blocks have already been registered!");
        }
        WeatheringCopper.WeatherState weathering = WEATHERING_BLOCKS.get(this);
        this.lanternBlock = weathering == null ? new LanternBlock(this, null) : new WeatheringLanternBlock(this, null, weathering);
        helper.register(this.getLanternIdentifier(null), (Object)this.lanternBlock);
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = weathering == null ? new LanternBlock(this, color) : new WeatheringLanternBlock(this, color, weathering);
                this.coloredLanternBlocks.put(color, block);
                helper.register(this.getLanternIdentifier(color), (Object)block);
            }
        }
        if (this.hasChains) {
            this.chainBlock = weathering == null ? new ChainBlock(this) : new WeatheringChainBlock(this, weathering);
            helper.register(this.getChainIdentifier(), (Object)this.chainBlock);
        }
        if (this.isVanilla) {
            Item.BY_BLOCK.put(this.lanternBlock, this.vanillaLanternBlock.asItem());
        }
    }

    public void registerItems(RegistrationHandler.Helper<Item> helper) {
        if (this.lanternItem != null) {
            throw new IllegalStateException("Items have already been registered!");
        }
        if (this.lanternBlock == null) {
            throw new IllegalStateException("Blocks must be registered before registering items!");
        }
        if (!this.isVanilla) {
            this.lanternItem = new BaseBlockItem((Block)this.lanternBlock, ItemProperties.create().group((CreativeModeTab)AdditionalLanterns.GROUP));
            helper.register(this.getLanternIdentifier(null), (Object)this.lanternItem);
        }
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = this.coloredLanternBlocks.get((Object)color);
                BaseBlockItem item = new BaseBlockItem((Block)block, ItemProperties.create().group((CreativeModeTab)AdditionalLanterns.GROUP));
                this.coloredLanternItems.put(color, (Item)item);
                helper.register(this.getLanternIdentifier(color), (Object)item);
            }
        }
        if (this.hasChains) {
            this.chainItem = new BaseBlockItem((Block)this.chainBlock, ItemProperties.create().group((CreativeModeTab)AdditionalLanterns.GROUP));
            helper.register(this.getChainIdentifier(), (Object)this.chainItem);
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (LanternMaterial material : MATERIALS) {
            if (!material.isVanilla) continue;
            builder.put((Object)material.vanillaLanternBlock, (Object)material);
        }
        VANILLA_LANTERN_MAPPINGS = builder.build();
    }
}

