/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.world.item.DyeColor;

public enum LanternColor {
    WHITE(DyeColor.WHITE, "White"),
    ORANGE(DyeColor.ORANGE, "Orange"),
    MAGENTA(DyeColor.MAGENTA, "Magenta"),
    LIGHT_BLUE(DyeColor.LIGHT_BLUE, "Light Blue"),
    YELLOW(DyeColor.YELLOW, "Yellow"),
    LIME(DyeColor.LIME, "Lime"),
    PINK(DyeColor.PINK, "Pink"),
    GRAY(DyeColor.GRAY, "Gray"),
    LIGHT_GRAY(DyeColor.LIGHT_GRAY, "Light Gray"),
    CYAN(DyeColor.CYAN, "Cyan"),
    PURPLE(DyeColor.PURPLE, "Purple"),
    BLUE(DyeColor.BLUE, "Blue"),
    BROWN(DyeColor.BROWN, "Brown"),
    GREEN(DyeColor.GREEN, "Green"),
    RED(DyeColor.RED, "Red"),
    BLACK(DyeColor.BLACK, "Black");

    private static final List<LanternColor> VALUES_AND_NULL;
    public final DyeColor dyeColor;
    public final String englishTranslation;

    public static List<LanternColor> colorsAndNull() {
        return VALUES_AND_NULL;
    }

    private LanternColor(DyeColor dyeColor, String englishTranslation) {
        this.dyeColor = dyeColor;
        this.englishTranslation = englishTranslation;
    }

    public String getSuffix() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static LanternColor fromDyeColor(DyeColor dyeColor) {
        for (LanternColor lanternColor : LanternColor.values()) {
            if (lanternColor.dyeColor != dyeColor) continue;
            return lanternColor;
        }
        return null;
    }

    static {
        VALUES_AND_NULL = Collections.unmodifiableList(Arrays.asList(Arrays.copyOf(LanternColor.values(), LanternColor.values().length + 1)));
    }
}

