/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableBiMap;
import com.supermartijn642.additionallanterns.AdditionalLanternsClient;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.additionallanterns.VanillaLanternEvents;
import com.supermartijn642.additionallanterns.data.LanternBlockModelGenerator;
import com.supermartijn642.additionallanterns.data.LanternBlockStateGenerator;
import com.supermartijn642.additionallanterns.data.LanternItemInfoGenerator;
import com.supermartijn642.additionallanterns.data.LanternItemModelGenerator;
import com.supermartijn642.additionallanterns.data.LanternLanguageGenerator;
import com.supermartijn642.additionallanterns.data.LanternLootTableGenerator;
import com.supermartijn642.additionallanterns.data.LanternRecipeGenerator;
import com.supermartijn642.additionallanterns.data.LanternTagGenerator;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="additionallanterns")
public class AdditionalLanterns {
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"additionallanterns", AdditionalLanterns::randomLantern).filler(items -> {
        for (LanternMaterial material : LanternMaterial.MATERIALS) {
            items.accept(material.getLanternBlock().asItem().getDefaultInstance());
            if (material.canBeColored) {
                for (LanternColor color : LanternColor.values()) {
                    items.accept(material.getLanternBlock(color).asItem().getDefaultInstance());
                }
            }
            if (!material.hasChains) continue;
            items.accept(material.getChainBlock().asItem().getDefaultInstance());
        }
    });
    public static final Logger LOGGER = CommonUtils.getLogger((String)"additionallanterns");
    private static final Random RANDOM = new Random();

    private static ItemStack randomLantern() {
        LanternMaterial material = LanternMaterial.MATERIALS.get(RANDOM.nextInt(LanternMaterial.MATERIALS.size()));
        if (!material.canBeColored) {
            return material.getLanternBlock().asItem().getDefaultInstance();
        }
        int colorIndex = RANDOM.nextInt(LanternColor.values().length + 1);
        LanternColor color = LanternColor.colorsAndNull().get(colorIndex);
        return material.getLanternBlock(color).asItem().getDefaultInstance();
    }

    public AdditionalLanterns(FMLJavaModLoadingContext context) {
        VanillaLanternEvents.registerEventHandlers();
        FMLCommonSetupEvent.getBus((BusGroup)context.getModBusGroup()).addListener(AdditionalLanterns::init);
        AdditionalLanterns.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            AdditionalLanternsClient.register();
        }
        AdditionalLanterns.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"additionallanterns");
        for (LanternMaterial material : LanternMaterial.MATERIALS) {
            handler.registerBlockCallback(material::registerBlocks);
            handler.registerItemCallback(material::registerItems);
        }
    }

    public static void init(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            try {
                Field delegateField = HoneycombItem.WAXABLES.getClass().getDeclaredField("delegate");
                delegateField.setAccessible(true);
                Supplier oldWaxables = (Supplier)delegateField.get(HoneycombItem.WAXABLES);
                delegateField.set(HoneycombItem.WAXABLES, Suppliers.memoize(() -> AdditionalLanterns.lambda$init$1((Supplier)oldWaxables)));
                delegateField = WeatheringCopper.NEXT_BY_BLOCK.getClass().getDeclaredField("delegate");
                delegateField.setAccessible(true);
                Supplier oldWeathering = (Supplier)delegateField.get(WeatheringCopper.NEXT_BY_BLOCK);
                delegateField.set(WeatheringCopper.NEXT_BY_BLOCK, Suppliers.memoize(() -> AdditionalLanterns.lambda$init$2((Supplier)oldWeathering)));
            }
            catch (Exception exception) {
                LOGGER.error("Failed to replace waxing and weathering maps! Copper lanterns will not be waxable or oxidize!", (Throwable)exception);
            }
        });
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"additionallanterns");
        handler.addGenerator(LanternBlockModelGenerator::new);
        handler.addGenerator(LanternItemInfoGenerator::new);
        handler.addGenerator(LanternItemModelGenerator::new);
        handler.addGenerator(LanternBlockStateGenerator::new);
        handler.addGenerator(LanternLanguageGenerator::new);
        handler.addGenerator(LanternLootTableGenerator::new);
        handler.addGenerator(LanternTagGenerator::new);
        handler.addGenerator(LanternRecipeGenerator::new);
    }

    private static /* synthetic */ ImmutableBiMap lambda$init$2(Supplier oldWeathering) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (Map.Entry<LanternMaterial, LanternMaterial> entry : LanternMaterial.OXIDATION_MAPPINGS.entrySet()) {
            for (LanternColor color : LanternColor.colorsAndNull()) {
                builder.put((Object)entry.getKey().getLanternBlock(color), (Object)entry.getValue().getLanternBlock(color));
            }
        }
        builder.putAll((Map)oldWeathering.get());
        return builder.build();
    }

    private static /* synthetic */ ImmutableBiMap lambda$init$1(Supplier oldWaxables) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (Map.Entry<LanternMaterial, LanternMaterial> entry : LanternMaterial.WAXING_MAPPINGS.entrySet()) {
            for (LanternColor color : LanternColor.colorsAndNull()) {
                builder.put((Object)entry.getKey().getLanternBlock(color), (Object)entry.getValue().getLanternBlock(color));
            }
        }
        builder.putAll((Map)oldWaxables.get());
        return builder.build();
    }
}

