/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easymobfarm.commands.Command;
import de.markusbordihn.easymobfarm.debug.DebugManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.permissions.Permissions;

public class DebugCommand
extends Command {
    private DebugCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"debug").requires(cs -> cs.permissions().hasPermission(Permissions.COMMANDS_GAMEMASTER))).then(Commands.literal((String)"log").then(Commands.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> DebugCommand.setDebug((CommandSourceStack)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"enable")))));
    }

    public static int setDebug(CommandSourceStack context, boolean enable) {
        if (enable) {
            DebugCommand.sendSuccessMessage(context, "\u25ba Enable debug for Easy Mob Farm, please check debug.log for the full output.", ChatFormatting.GREEN);
            DebugCommand.sendSuccessMessage(context, "> Use '/easy_mob_farm debug false' to disable the debug!", ChatFormatting.WHITE);
        } else {
            DebugCommand.sendSuccessMessage(context, "\u25a0 Disable debug for Easy Mob Farm!", ChatFormatting.RED);
            DebugCommand.sendSuccessMessage(context, "> Please check the latest.log and/or debug.log for the full output.", ChatFormatting.WHITE);
        }
        DebugManager.enableDebugLevel(enable);
        return 1;
    }
}

