/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.network.message.client;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.network.message.NetworkMessageRecord;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;

public record SyncMobCaptureCardDefinitionsMessage(Map<Identifier, MobCaptureCardDefinition> definitions) implements NetworkMessageRecord
{
    public static final Identifier MESSAGE_ID = Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)"sync_mob_capture_card_definitions");
    public static final CustomPacketPayload.Type<SyncMobCaptureCardDefinitionsMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncMobCaptureCardDefinitionsMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), SyncMobCaptureCardDefinitionsMessage::create);

    public static SyncMobCaptureCardDefinitionsMessage create(FriendlyByteBuf buffer) {
        int size = buffer.readVarInt();
        HashMap<Identifier, MobCaptureCardDefinition> definitions = new HashMap<Identifier, MobCaptureCardDefinition>();
        for (int i = 0; i < size; ++i) {
            Identifier entityId = buffer.readIdentifier();
            MobCaptureCardDefinition definition = MobCaptureCardDefinition.decode(buffer);
            definitions.put(entityId, definition);
        }
        return new SyncMobCaptureCardDefinitionsMessage(definitions);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.definitions.size());
        for (Map.Entry<Identifier, MobCaptureCardDefinition> entry : this.definitions.entrySet()) {
            buffer.writeIdentifier(entry.getKey());
            entry.getValue().encode(buffer);
        }
    }

    @Override
    public Identifier id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<SyncMobCaptureCardDefinitionsMessage> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleClient() {
        if (this.definitions == null || this.definitions.isEmpty()) {
            log.warn("No mob capture card definitions to sync!");
            return;
        }
        log.info("Syncing {} mob capture card definitions to client.", (Object)this.definitions.size());
        MobCaptureCardDefinitionManager.setDefinitions(this.definitions);
    }
}

