/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.menu;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmDataEntry;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlot;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlots;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.item.upgrade.slot.BigSlotUpgradeItem;
import de.markusbordihn.easymobfarm.item.upgrade.slot.SmallSlotUpgradeItem;
import de.markusbordihn.easymobfarm.menu.slots.CapturedMobSlot;
import de.markusbordihn.easymobfarm.menu.slots.EnhancementSlot;
import de.markusbordihn.easymobfarm.menu.slots.FilterSlot;
import de.markusbordihn.easymobfarm.menu.slots.OutputSlot;
import de.markusbordihn.easymobfarm.menu.slots.SlotUpgradeSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmMenu
extends AbstractContainerMenu {
    public static final String ID = "mob_farm_menu";
    public static final int CAPTURED_MOB_SLOT_X = 121;
    public static final int CAPTURED_MOB_SLOT_Y = 39;
    public static final int UPGRADE_SLOT_X = 156;
    public static final int UPGRADE_SLOT_Y = 32;
    public static final int FILTER_SLOT_X = 219;
    public static final int FILTER_SLOT_Y = 14;
    public static final int SLOT_UPGRADE_SLOT_X = 20;
    public static final int SLOT_UPGRADE_SLOT_Y = 89;
    public static final int RESULT_SLOT_X = 48;
    public static final int RESULT_SLOT_Y = 89;
    public static final int PLAYER_INVENTORY_SLOT_X = 48;
    public static final int PLAYER_INVENTORY_SLOT_Y = 157;
    public static final int PLAYER_HOTBAR_SLOT_X = 48;
    public static final int PLAYER_HOTBAR_SLOT_Y = 215;
    public static final int CONTAINER_SIZE = 52;
    public static final int CONTAINER_DATA_SIZE = MobFarmDataEntry.getLastSlotIndex() + 1;
    public static final int MIN_NUMBER_OF_OUTPUT_SLOTS = 6;
    public static final int MAX_NUMBER_OF_OUTPUT_SLOTS = 27;
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private final Container container;
    private final ContainerData data;
    private final Inventory playerInventory;

    public MobFarmMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, (Container)new SimpleContainer(52), (ContainerData)new SimpleContainerData(CONTAINER_DATA_SIZE));
    }

    public MobFarmMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, Container container, ContainerData containerData) {
        super(menuType, containerId);
        MobFarmMenu.checkContainerSize((Container)container, (int)52);
        MobFarmMenu.checkContainerDataCount((ContainerData)containerData, (int)CONTAINER_DATA_SIZE);
        this.container = container;
        this.data = containerData;
        this.playerInventory = playerInventory;
        this.defineMobFarmSlots();
        this.defineUpgradeSlots();
        this.defineFilterSlots();
        this.defineSlotUpgradeSlots();
        this.defineOuputSlots();
        this.definePlayerInventorySlots();
        this.definePlayerHotbarSlots();
        Container container2 = this.container;
        if (container2 instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)container2;
            BlockPos blockPos = mobFarmBlockEntity.getBlockPos();
            if (this.getMobFarmBlockPos() == null || !this.getMobFarmBlockPos().equals((Object)blockPos)) {
                log.debug("Update Block pose {} for {}", (Object)blockPos, (Object)mobFarmBlockEntity);
                this.setMobFarmBlockPos(blockPos);
            }
            if (this.updateNumberOfOutputSlots()) {
                log.debug("Update number of output slots {} for {}", (Object)this.getMobFarmNumberOfOutputSlots(), (Object)mobFarmBlockEntity);
            }
        }
        this.addDataSlots(containerData);
    }

    public BlockPos getMobFarmBlockPos() {
        return new BlockPos(this.data.get(0), this.data.get(1), this.data.get(2));
    }

    public void setMobFarmBlockPos(BlockPos blockPos) {
        this.data.set(0, blockPos.getX());
        this.data.set(1, blockPos.getY());
        this.data.set(2, blockPos.getZ());
    }

    public int getMobFarmNumberOfOutputSlots() {
        return this.data.get(3);
    }

    public void setMobFarmNumberOfOutputSlots(int numberOfOutputSlots) {
        this.data.set(3, numberOfOutputSlots);
    }

    public int getMobFarmProgress() {
        return this.data.get(4);
    }

    public int getMobFarmProgressionSpeed() {
        return this.data.get(9);
    }

    public int getMobFarmProgressionSpeedBonus() {
        return this.data.get(10);
    }

    public int getMobFarmStatus() {
        return this.data.get(5);
    }

    public int getMobFarmTierLevel() {
        return this.data.get(6);
    }

    public MobFarmType getMobFarmType() {
        int mobFarmTypeIndex = this.data.get(7);
        return mobFarmTypeIndex >= 0 ? MobFarmType.values()[this.data.get(7)] : null;
    }

    public int getCapturedMobExperience() {
        return this.data.get(8);
    }

    public int getBufferSize() {
        return this.data.get(11);
    }

    public int getBufferMaxSize() {
        return this.data.get(12);
    }

    private void defineMobFarmSlots() {
        this.addSlot(new CapturedMobSlot(this.container, MobFarmSlot.CAPTURED_MOB.index(), 121, 39));
    }

    private void defineUpgradeSlots() {
        int slotId = 0;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                this.addSlot(new EnhancementSlot(this.container, MobFarmSlots.ENHANCEMENT_ITEM_SLOTS.get(slotId).index(), 156 + column * 18, 32 + row * 18));
                ++slotId;
            }
        }
    }

    private void defineFilterSlots() {
        int slotId = 0;
        for (int row = 0; row < 4; ++row) {
            this.addSlot(new FilterSlot(this.container, MobFarmSlots.FILTER_ITEM_SLOTS.get(slotId).index(), 219, 14 + row * 18));
            ++slotId;
        }
    }

    private void defineSlotUpgradeSlots() {
        int slotId = 0;
        for (int row = 0; row < 3; ++row) {
            this.addSlot(new SlotUpgradeSlot(this, this.container, MobFarmSlots.SLOT_UPGRADE_ITEM_SLOTS.get(slotId).index(), 20, 89 + row * 18));
            ++slotId;
        }
    }

    private void defineOuputSlots() {
        int slotId = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new OutputSlot(this.container, MobFarmSlots.RESULT_SLOTS.get(slotId).index(), 48 + column * 18, 89 + row * 18));
                ++slotId;
            }
        }
    }

    private void definePlayerInventorySlots() {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.addSlot(new Slot((Container)this.playerInventory, column + row * 9 + 9, 48 + column * 18, 157 + row * 18));
            }
        }
    }

    private void definePlayerHotbarSlots() {
        for (int column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)this.playerInventory, column, 48 + column * 18, 215));
        }
    }

    private boolean updateNumberOfOutputSlots() {
        int newNumberOfOutputSlots;
        int numberOfOutputSlots = 6;
        for (Slot slot : this.slots) {
            if (!(slot instanceof SlotUpgradeSlot) || !slot.hasItem() || slot.getItem().isEmpty()) continue;
            Item item = slot.getItem().getItem();
            if (item instanceof SmallSlotUpgradeItem) {
                SmallSlotUpgradeItem smallSlotUpgradeItem = (SmallSlotUpgradeItem)item;
                numberOfOutputSlots += smallSlotUpgradeItem.numberOfUpgradeSlots();
                continue;
            }
            item = slot.getItem().getItem();
            if (!(item instanceof BigSlotUpgradeItem)) continue;
            BigSlotUpgradeItem bigSlotUpgradeItem = (BigSlotUpgradeItem)item;
            numberOfOutputSlots += bigSlotUpgradeItem.numberOfUpgradeSlots();
        }
        int currentNumberOfOutputSlots = this.getMobFarmNumberOfOutputSlots();
        if (currentNumberOfOutputSlots != (newNumberOfOutputSlots = Math.min(Math.max(6, numberOfOutputSlots), 27))) {
            this.setMobFarmNumberOfOutputSlots(newNumberOfOutputSlots);
            this.adjustOutputSlots(newNumberOfOutputSlots);
            return true;
        }
        return false;
    }

    private void adjustOutputSlots(int maxNumberOfOutputSlots) {
        int currentNumberOfOutputSlots = 0;
        for (Slot slot : this.slots) {
            if (!(slot instanceof OutputSlot)) continue;
            OutputSlot outputSlot = (OutputSlot)slot;
            outputSlot.setActive(currentNumberOfOutputSlots++ < maxNumberOfOutputSlots);
        }
    }

    public void slotUpgradeChanged(SlotUpgradeSlot slot) {
        this.updateNumberOfOutputSlots();
    }

    public boolean stillValid(Player player) {
        return player.isAlive();
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = slot.getItem();
        ItemStack itemStackCopy = itemStack.copy();
        if (slot.container == this.container) {
            if (!this.moveItemStackTo(itemStack, 36, this.slots.size(), true)) {
                return ItemStack.EMPTY;
            }
        } else if (slot.container == this.playerInventory) {
            for (Slot targetSlot : this.slots.subList(0, MobFarmSlots.RESULT_SLOTS.size())) {
                if (targetSlot instanceof OutputSlot || targetSlot.hasItem() || !targetSlot.mayPlace(itemStack)) continue;
                ItemStack singleItem = itemStack.split(1);
                targetSlot.set(singleItem);
                targetSlot.setChanged();
                break;
            }
        }
        if (itemStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (itemStack.getCount() == itemStackCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, itemStack);
        return itemStackCopy;
    }
}

