/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.loot;

import de.markusbordihn.easymobfarm.compat.CompatConstants;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import de.markusbordihn.easymobfarm.data.enhancement.FrogCatalystType;
import de.markusbordihn.easymobfarm.data.loot.LootTablePriority;
import de.markusbordihn.easymobfarm.experience.ExperienceManager;
import de.markusbordihn.easymobfarm.item.upgrade.EnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.EggCollectorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.ExperienceEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.FrogCatalystEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyHarvesterFrameEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.KnifeEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LootEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LuckEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.MilkExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.PollenTrapEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SheepEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SwordEnhancementItem;
import de.markusbordihn.easymobfarm.server.player.FakePlayer;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.bee.Bee;
import net.minecraft.world.entity.animal.chicken.Chicken;
import net.minecraft.world.entity.animal.cow.Cow;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random random = new Random();
    private static final Map<String, Identifier> FROG_CATALYST_RESOURCES = Map.ofEntries(Map.entry("cold", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_COLD)), Map.entry("temperate", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_TEMPERATE)), Map.entry("warm", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_WARM)), Map.entry("white", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_WHITE)), Map.entry("orange", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_ORANGE)), Map.entry("magenta", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_MAGENTA)), Map.entry("light_blue", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_LIGHT_BLUE)), Map.entry("yellow", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_YELLOW)), Map.entry("lime", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_LIME)), Map.entry("pink", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_PINK)), Map.entry("gray", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_GRAY)), Map.entry("light_gray", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_LIGHT_GRAY)), Map.entry("cyan", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_CYAN)), Map.entry("purple", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_PURPLE)), Map.entry("blue", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_BLUE)), Map.entry("brown", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_BROWN)), Map.entry("green", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_GREEN)), Map.entry("red", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_RED)), Map.entry("black", Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_BLACK)));
    private static final EnumMap<FrogCatalystType, Identifier> FROGLIGHT_MAP = new EnumMap(FrogCatalystType.class);
    private static FakePlayer fakePlayer;

    private LootManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NonNullList<ItemStack> getEntityLoot(MobCaptureData mobCaptureData, List<EnhancementItem> enhancements, Level level) {
        EntityType<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            log.error("Unable to get entity type from Mob Capture data: {}", (Object)mobCaptureData);
            return NonNullList.create();
        }
        Entity entity = entityType.create(level, EntitySpawnReason.EVENT);
        if (entity == null) {
            log.error("Unable to create entity {}!", entityType);
            return NonNullList.create();
        }
        try {
            entity.load(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)mobCaptureData.data()));
            if (entity instanceof Sheep) {
                Sheep sheepEntity = (Sheep)entity;
                sheepEntity.setSheared(false);
                if (mobCaptureData.hasColor()) {
                    sheepEntity.setColor(mobCaptureData.color().getDyeColor());
                }
            }
            NonNullList<ItemStack> nonNullList = LootManager.getEntityLoot(entity, enhancements, level);
            return nonNullList;
        }
        finally {
            entity.discard();
        }
    }

    public static NonNullList<ItemStack> getEntityLoot(Entity entity, List<EnhancementItem> enhancements, Level level) {
        LivingEntity livingEntity;
        NonNullList drops;
        block15: {
            block14: {
                drops = NonNullList.create();
                if (!(entity instanceof LivingEntity)) break block14;
                livingEntity = (LivingEntity)entity;
                if (level instanceof ServerLevel) break block15;
            }
            return drops;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, entity.blockPosition());
        LootParams.Builder lootContextBuilder = LootManager.createLootContextBuilder(serverLevel, livingEntity);
        float additionalLuck = 0.0f;
        int additionalRolls = 0;
        for (EnhancementItem enhancement : enhancements) {
            if (enhancement instanceof SwordEnhancementItem) {
                LootManager.setSwordEnhancementParameters(lootContextBuilder, fakePlayer, serverLevel);
                additionalLuck += 0.5f;
            }
            if (enhancement instanceof KnifeEnhancementItem) {
                LootManager.setKnifeEnhancementParameters(lootContextBuilder, fakePlayer, serverLevel);
                additionalLuck += 0.25f;
            }
            if (enhancement instanceof LootEnhancementItem) {
                ++additionalRolls;
            }
            if (!(enhancement instanceof LuckEnhancementItem)) continue;
            additionalLuck += 1.0f;
        }
        if (additionalLuck > 0.0f) {
            lootContextBuilder.withLuck(additionalLuck);
        }
        ResourceKey<LootTable> lootTableLocation = LootManager.getLootTableLocation(livingEntity, enhancements);
        LootParams lootParams = lootContextBuilder.create(LootContextParamSets.ENTITY);
        if (LootManager.addLootFromCustomTable(LootTablePriority.OVERWRITE, livingEntity, serverLevel, lootParams, additionalRolls, (NonNullList<ItemStack>)drops)) {
            LootManager.handlePostEnhancements(enhancements, livingEntity, serverLevel, fakePlayer, (NonNullList<ItemStack>)drops);
            LootManager.handleKnifeEnhancementLoot(enhancements, livingEntity, serverLevel, lootParams, (NonNullList<ItemStack>)drops);
            return drops;
        }
        LootManager.addLootFromCustomTable(LootTablePriority.PRIORITY, livingEntity, serverLevel, lootParams, additionalRolls, (NonNullList<ItemStack>)drops);
        if (lootTableLocation != null) {
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableLocation);
            for (int i = 0; i <= additionalRolls; ++i) {
                lootTable.getRandomItems(lootParams).stream().filter(itemStack -> !itemStack.isEmpty()).forEach(arg_0 -> drops.add(arg_0));
                LootManager.handleSpecialEntityDrops(livingEntity, (NonNullList<ItemStack>)drops);
            }
        }
        LootManager.addLootFromCustomTable(LootTablePriority.BONUS, livingEntity, serverLevel, lootParams, additionalRolls, (NonNullList<ItemStack>)drops);
        if (drops.isEmpty() && !LootManager.addLootFromCustomTable(LootTablePriority.FALLBACK, livingEntity, serverLevel, lootParams, additionalRolls, (NonNullList<ItemStack>)drops)) {
            ResourceKey<LootTable> legacyLocation = LootManager.getCustomLootTableLocation(livingEntity, LootTablePriority.LEGACY);
            LootTable legacyTable = serverLevel.getServer().reloadableRegistries().getLootTable(legacyLocation);
            if (legacyTable != LootTable.EMPTY) {
                log.warn("Using legacy loot table path {} - please move to entities/fallback/", legacyLocation);
                for (int i = 0; i <= additionalRolls; ++i) {
                    legacyTable.getRandomItems(lootParams).stream().filter(itemStack -> !itemStack.isEmpty()).forEach(arg_0 -> drops.add(arg_0));
                }
            }
        }
        LootManager.handlePostEnhancements(enhancements, livingEntity, serverLevel, fakePlayer, (NonNullList<ItemStack>)drops);
        LootManager.handleKnifeEnhancementLoot(enhancements, livingEntity, serverLevel, lootParams, (NonNullList<ItemStack>)drops);
        return drops;
    }

    public static NonNullList<ItemStack> getLuckyLoot(MobCaptureData mobCaptureData, BlockPos blockPos, Level Level2) {
        NonNullList drops = NonNullList.create();
        if (!(Level2 instanceof ServerLevel)) {
            return drops;
        }
        ServerLevel serverLevel = (ServerLevel)Level2;
        ResourceKey lootTableLocation = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)Identifier.fromNamespaceAndPath((String)"minecraft", (String)(switch (mobCaptureData.rarity()) {
            default -> throw new MatchException(null, null);
            case Rarity.COMMON -> "chests/simple_dungeon";
            case Rarity.UNCOMMON -> "chests/village/village_toolsmith";
            case Rarity.RARE -> "chests/stronghold_library";
            case Rarity.EPIC -> "chests/end_city_treasure";
        })));
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, blockPos);
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableLocation);
        LootParams.Builder lootContextBuilder = LootManager.createLootChestContextBuilder(serverLevel, (LivingEntity)fakePlayer);
        lootContextBuilder.withLuck(switch (mobCaptureData.rarity()) {
            default -> throw new MatchException(null, null);
            case Rarity.COMMON -> 0.0f;
            case Rarity.UNCOMMON -> 0.5f;
            case Rarity.RARE -> 1.0f;
            case Rarity.EPIC -> 1.5f;
        });
        LootParams lootContext = lootContextBuilder.create(LootContextParamSets.CHEST);
        lootTable.getRandomItems(lootContext).stream().filter(itemStack -> !itemStack.isEmpty()).forEach(arg_0 -> drops.add(arg_0));
        return drops;
    }

    private static void handleSpecialEntityDrops(LivingEntity livingEntity, NonNullList<ItemStack> drops) {
        if (livingEntity instanceof WitherBoss) {
            if (random.nextInt(2) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.NETHER_STAR));
            }
            if (random.nextInt(2) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.WITHER_ROSE));
            }
        }
    }

    private static LootParams.Builder createLootContextBuilder(ServerLevel serverLevel, LivingEntity livingEntity) {
        return new LootParams.Builder(serverLevel).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)serverLevel.damageSources().generic()).withParameter(LootContextParams.ORIGIN, (Object)livingEntity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)livingEntity);
    }

    private static LootParams.Builder createLootChestContextBuilder(ServerLevel serverLevel, LivingEntity livingEntity) {
        return new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)livingEntity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)livingEntity);
    }

    private static ResourceKey<LootTable> getLootTableLocation(LivingEntity livingEntity, List<EnhancementItem> enhancements) {
        Optional<ResourceKey> lootTableLocation = livingEntity.getType().getDefaultLootTable();
        for (EnhancementItem enhancement : enhancements) {
            if (!(enhancement instanceof SheepEnhancementItem) || !(livingEntity instanceof Sheep)) continue;
            Sheep sheep = (Sheep)livingEntity;
            DyeColor color = sheep.getColor();
            lootTableLocation = Optional.of(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)Identifier.fromNamespaceAndPath((String)"minecraft", (String)("entities/sheep/" + color.getName()))));
        }
        return lootTableLocation.orElse(null);
    }

    private static ResourceKey<LootTable> getCustomLootTableLocation(LivingEntity livingEntity, LootTablePriority priority) {
        Identifier entityTypeIdentifier = BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType());
        String path = priority.getPath().isEmpty() ? "entities/" : "entities/" + priority.getPath() + "/";
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)(path + entityTypeIdentifier.getNamespace() + "/" + entityTypeIdentifier.getPath())));
    }

    private static boolean addLootFromCustomTable(LootTablePriority priority, LivingEntity livingEntity, ServerLevel serverLevel, LootParams lootParams, int additionalRolls, NonNullList<ItemStack> drops) {
        ResourceKey<LootTable> customLocation = LootManager.getCustomLootTableLocation(livingEntity, priority);
        LootTable customTable = serverLevel.getServer().reloadableRegistries().getLootTable(customLocation);
        if (customTable != LootTable.EMPTY) {
            log.debug("Using {} loot table for {}", (Object)priority.getPath(), (Object)livingEntity.getType());
            for (int i = 0; i <= additionalRolls; ++i) {
                customTable.getRandomItems(lootParams).stream().filter(itemStack -> !itemStack.isEmpty()).forEach(arg_0 -> drops.add(arg_0));
            }
            return true;
        }
        return false;
    }

    private static void setSwordEnhancementParameters(LootParams.Builder lootParamsBuilder, FakePlayer fakePlayer, ServerLevel serverLevel) {
        ItemStack swordItem = new ItemStack((ItemLike)Items.IRON_SWORD);
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, swordItem);
        lootParamsBuilder.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)serverLevel.damageSources().playerAttack((Player)fakePlayer)).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)fakePlayer).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakePlayer).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)fakePlayer);
    }

    private static void setKnifeEnhancementParameters(LootParams.Builder lootParamsBuilder, FakePlayer fakePlayer, ServerLevel serverLevel) {
        ItemStack knifeItem = LootManager.getKnifeTool();
        if (!knifeItem.isEmpty()) {
            fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, knifeItem);
        }
        lootParamsBuilder.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)serverLevel.damageSources().playerAttack((Player)fakePlayer)).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)fakePlayer).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakePlayer).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)fakePlayer);
    }

    private static ItemStack getKnifeTool() {
        Optional farmersDelightKnife;
        if (CompatConstants.MOD_FARMERS_DELIGHT_LOADED && (farmersDelightKnife = BuiltInRegistries.ITEM.get(Identifier.fromNamespaceAndPath((String)"farmersdelight", (String)"iron_knife"))).isPresent() && ((Holder.Reference)farmersDelightKnife.get()).value() != Items.AIR) {
            return new ItemStack((ItemLike)((Holder.Reference)farmersDelightKnife.get()).value());
        }
        return ItemStack.EMPTY;
    }

    private static void handlePostEnhancements(List<EnhancementItem> enhancements, LivingEntity livingEntity, ServerLevel serverLevel, FakePlayer fakePlayer, NonNullList<ItemStack> drops) {
        for (EnhancementItem enhancement : enhancements) {
            Identifier frogCatalystIdentifier;
            ExperienceEnhancementItem experienceEnhancementItem;
            if (enhancement instanceof ExperienceEnhancementItem && random.nextInt((experienceEnhancementItem = (ExperienceEnhancementItem)enhancement).experienceDropChance()) == 0 && ExperienceManager.shouldDropExperience(livingEntity)) {
                int experience = ExperienceManager.getExperienceReward(livingEntity, serverLevel);
                if (experience >= experienceEnhancementItem.minExperienceForDrop()) {
                    drops.add((Object)new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE));
                } else {
                    log.debug("Experience drop of {} is below minimum threshold of {} for {}", (Object)experience, (Object)experienceEnhancementItem.minExperienceForDrop(), (Object)livingEntity);
                }
            }
            if (livingEntity instanceof Bee) {
                if (enhancement instanceof HoneyHarvesterFrameEnhancementItem && random.nextInt(4) == 0) {
                    drops.add((Object)new ItemStack((ItemLike)Items.HONEYCOMB));
                    continue;
                }
                if (enhancement instanceof HoneyExtractorEnhancementItem && random.nextInt(10) == 0) {
                    drops.add((Object)new ItemStack((ItemLike)Items.HONEY_BOTTLE));
                    continue;
                }
                if (!(enhancement instanceof PollenTrapEnhancementItem) || random.nextInt(5) != 0) continue;
                if (random.nextFloat() < 0.3f) {
                    drops.add((Object)LootManager.getRandomFlower());
                    continue;
                }
                drops.add((Object)LootManager.getRandomDye());
                continue;
            }
            if (livingEntity instanceof Cow) {
                if (!(enhancement instanceof MilkExtractorEnhancementItem) || random.nextInt(2) != 0) continue;
                Optional milkBottle = CompatConstants.MOD_FARMERS_DELIGHT_LOADED ? BuiltInRegistries.ITEM.get(Identifier.fromNamespaceAndPath((String)"farmersdelight", (String)"milk_bottle")) : BuiltInRegistries.ITEM.get(Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)"milk_bottle"));
                milkBottle.ifPresent(itemReference -> drops.add((Object)new ItemStack((Holder)itemReference)));
                continue;
            }
            if (livingEntity instanceof Chicken) {
                if (!(enhancement instanceof EggCollectorEnhancementItem) || random.nextInt(2) != 0) continue;
                drops.add((Object)new ItemStack((ItemLike)Items.EGG));
                continue;
            }
            if (livingEntity instanceof Frog) {
                if (random.nextInt(40) != 0) continue;
                String frogVariant = MobVariantData.getVariant(livingEntity);
                Identifier frogCatalystIdentifier2 = FROG_CATALYST_RESOURCES.get(frogVariant);
                if (frogCatalystIdentifier2 != null) {
                    Object object;
                    Optional frogCatalystItem = BuiltInRegistries.ITEM.get(frogCatalystIdentifier2);
                    if (frogCatalystItem.isPresent() && (object = ((Holder.Reference)frogCatalystItem.get()).value()) instanceof FrogCatalystEnhancementItem) {
                        FrogCatalystEnhancementItem frogCatalystEnhancementItem = (FrogCatalystEnhancementItem)((Object)object);
                        drops.add((Object)new ItemStack((ItemLike)frogCatalystEnhancementItem));
                        continue;
                    }
                    log.warn("Frog Catalyst item {} is not an instance of FrogCatalystEnhancementItem!", (Object)frogCatalystItem);
                    continue;
                }
                log.warn("No Frog Catalyst resource found for variant {}!", (Object)frogVariant);
                continue;
            }
            if (!(livingEntity instanceof MagmaCube)) continue;
            if (random.nextInt(8) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.MAGMA_CREAM));
            }
            if (!(enhancement instanceof FrogCatalystEnhancementItem)) continue;
            FrogCatalystEnhancementItem frogCatalystEnhancementItem = (FrogCatalystEnhancementItem)enhancement;
            if (random.nextInt(2) != 0) continue;
            FrogCatalystType frogCatalystType = frogCatalystEnhancementItem.getFrogCatalystType();
            switch (frogCatalystType) {
                case COLD: {
                    drops.add((Object)new ItemStack((ItemLike)Items.VERDANT_FROGLIGHT));
                    break;
                }
                case TEMPERATE: {
                    drops.add((Object)new ItemStack((ItemLike)Items.OCHRE_FROGLIGHT));
                    break;
                }
                case WARM: {
                    drops.add((Object)new ItemStack((ItemLike)Items.PEARLESCENT_FROGLIGHT));
                    break;
                }
                default: {
                    if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) break;
                    log.error("Unknown Frog Catalyst type {}", (Object)frogCatalystType);
                }
            }
            if (!CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED || (frogCatalystIdentifier = FROGLIGHT_MAP.get((Object)frogCatalystType)) == null) continue;
            Optional frogCatalystItem = BuiltInRegistries.ITEM.get(frogCatalystIdentifier);
            if (frogCatalystItem.isPresent() && ((Holder.Reference)frogCatalystItem.get()).value() != Items.AIR) {
                drops.add((Object)new ItemStack((ItemLike)((Holder.Reference)frogCatalystItem.get()).value()));
                continue;
            }
            log.warn("Swampier Swamps: Frog Catalyst item {} is not available!", (Object)frogCatalystType);
        }
    }

    private static void handleKnifeEnhancementLoot(List<EnhancementItem> enhancements, LivingEntity livingEntity, ServerLevel serverLevel, LootParams lootParams, NonNullList<ItemStack> drops) {
        boolean hasKnifeEnhancement = false;
        for (EnhancementItem enhancement : enhancements) {
            if (!(enhancement instanceof KnifeEnhancementItem)) continue;
            hasKnifeEnhancement = true;
            break;
        }
        if (!hasKnifeEnhancement) {
            return;
        }
        Identifier entityTypeIdentifier = BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType());
        ResourceKey knifeLootTableLocation = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)("enhancement/knife/" + entityTypeIdentifier.getNamespace() + "/" + entityTypeIdentifier.getPath())));
        LootTable knifeLootTable = serverLevel.getServer().reloadableRegistries().getLootTable(knifeLootTableLocation);
        if (knifeLootTable != LootTable.EMPTY) {
            knifeLootTable.getRandomItems(lootParams).stream().filter(itemStack -> !itemStack.isEmpty()).forEach(arg_0 -> drops.add(arg_0));
        }
    }

    private static FakePlayer getFakePlayer(ServerLevel level, BlockPos blockPos) {
        if (FakePlayer.isInvalidFakePlayer(fakePlayer)) {
            fakePlayer = new FakePlayer(level, blockPos);
            return fakePlayer;
        }
        return fakePlayer.updatePosition(level, blockPos);
    }

    private static ItemStack getRandomFlower() {
        List<Item> flowers = List.of(Items.DANDELION, Items.POPPY, Items.BLUE_ORCHID, Items.ALLIUM, Items.AZURE_BLUET, Items.RED_TULIP, Items.ORANGE_TULIP, Items.WHITE_TULIP, Items.PINK_TULIP, Items.OXEYE_DAISY, Items.CORNFLOWER, Items.LILY_OF_THE_VALLEY);
        return new ItemStack((ItemLike)flowers.get(new Random().nextInt(flowers.size())));
    }

    private static ItemStack getRandomDye() {
        List<Item> dyes = List.of(Items.YELLOW_DYE, Items.RED_DYE, Items.BLUE_DYE, Items.ORANGE_DYE, Items.PINK_DYE, Items.WHITE_DYE, Items.BLACK_DYE);
        return new ItemStack((ItemLike)dyes.get(new Random().nextInt(dyes.size())));
    }

    static {
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
            FROGLIGHT_MAP.put(FrogCatalystType.WHITE, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"white_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.ORANGE, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"orange_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.MAGENTA, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"magenta_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIGHT_BLUE, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"light_blue_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.YELLOW, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"yellow_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIME, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"lime_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.PINK, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"pink_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.GRAY, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"gray_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIGHT_GRAY, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"light_gray_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.CYAN, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"cyan_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.PURPLE, Identifier.fromNamespaceAndPath((String)"minecraft", (String)"pearlescent_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BLUE, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"blue_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BROWN, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"brown_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.GREEN, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"green_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.RED, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"red_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BLACK, Identifier.fromNamespaceAndPath((String)"swampier_swamps", (String)"black_froglight"));
        }
    }
}

