/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcapturecard;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.capture.MobCaptureManagerClient;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobColor;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MobCaptureCardItem
extends Item {
    public static final String ID = "mob_capture_card";
    public static final Identifier RESOURCE_LOCATION = Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)"mob_capture_card");
    public static final String TOOLTIP_PREFIX = "tooltip.easy_mob_farm.mob_capture_card.";
    private Level level;

    public MobCaptureCardItem() {
        this(new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (Identifier)Identifier.fromNamespaceAndPath((String)"easy_mob_farm", (String)ID))));
    }

    public MobCaptureCardItem(Item.Properties properties) {
        super(properties.fireResistant());
    }

    public static MobCaptureCardItem getMobCaptureCardItem() {
        Object t;
        Optional holder = BuiltInRegistries.ITEM.getOptional(RESOURCE_LOCATION);
        if (holder.isPresent() && (t = holder.get()) instanceof MobCaptureCardItem) {
            MobCaptureCardItem mobCaptureCardItem = (MobCaptureCardItem)((Object)t);
            return mobCaptureCardItem;
        }
        return null;
    }

    private static String getVariantName(String variant) {
        if (variant == null || variant.isEmpty()) {
            return "";
        }
        return Arrays.stream(variant.split("_")).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
    }

    private static Component getTranslatedEntityName(MobCaptureData mobCaptureData) {
        if (mobCaptureData == null || mobCaptureData.name() == null) {
            return TextComponent.getText("Unknown");
        }
        return TextComponent.getTranslatedTextRaw(mobCaptureData.name());
    }

    private static void addSpecialMechanicsTooltips(MobCaptureData mobCaptureData, Consumer<Component> tooltipConsumer) {
        if (mobCaptureData == null || mobCaptureData.name() == null) {
            return;
        }
        MutableComponent specialMechanicsTooltip = MobCaptureCardItem.tryGetTranslation(TOOLTIP_PREFIX + mobCaptureData.name().replace("entity.", "").replace(":", ".") + ".special_mechanics");
        if (specialMechanicsTooltip != null) {
            tooltipConsumer.accept((Component)specialMechanicsTooltip.withStyle(ChatFormatting.GRAY));
        }
    }

    private static MutableComponent tryGetTranslation(String translationKey) {
        try {
            if (!I18n.exists((String)translationKey)) {
                return null;
            }
            return TextComponent.getTranslatedTextRaw(translationKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Rarity getRarity(ItemStack itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, null);
        return mobCaptureData != null ? mobCaptureData.rarity() : Rarity.COMMON;
    }

    public static MobColor getEntityColor(ItemStack itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, null);
        return mobCaptureData != null ? mobCaptureData.color() : MobColor.NONE;
    }

    public static String getEntityType(ItemStack itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, null);
        return mobCaptureData != null ? mobCaptureData.type() : "";
    }

    public static String getEntityVariant(ItemStack itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, null);
        return mobCaptureData != null ? mobCaptureData.variant() : "";
    }

    public InteractionResult useOn(UseOnContext context) {
        this.level = context.getLevel();
        return super.useOn(context);
    }

    public void onCraftedBy(ItemStack itemStack, Player player) {
        this.level = player.level();
        super.onCraftedBy(itemStack, player);
    }

    public void onDestroyed(ItemEntity itemEntity) {
        this.level = itemEntity.level();
        super.onDestroyed(itemEntity);
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel serverLevel, Entity entity, EquipmentSlot equipmentSlot) {
        if (entity instanceof Player && this.level == null) {
            this.level = serverLevel;
        }
        super.inventoryTick(itemStack, serverLevel, entity, equipmentSlot);
    }

    public boolean canDestroyBlock(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, LivingEntity livingEntity) {
        this.level = level;
        return false;
    }

    public Component getName(ItemStack itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, this.level);
        if (mobCaptureData == null) {
            return super.getName(itemStack);
        }
        Object key = "tooltip.easy_mob_farm.mob_capture_card.card_name";
        Object[] args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData)};
        if (mobCaptureData.hasVariant() && !mobCaptureData.name().equalsIgnoreCase(mobCaptureData.variant())) {
            if (mobCaptureData.hasColor()) {
                key = (String)key + "_variant_color";
                args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), MobCaptureCardItem.getVariantName(mobCaptureData.variant()), mobCaptureData.color().getName()};
            } else {
                key = (String)key + "_variant";
                args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), MobCaptureCardItem.getVariantName(mobCaptureData.variant())};
            }
        } else if (mobCaptureData.hasColor()) {
            key = (String)key + "_color";
            args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), mobCaptureData.color().getName()};
        }
        return TextComponent.getTranslatedTextRaw((String)key, args).append(" ").append((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card").withStyle(ChatFormatting.GRAY));
    }

    public boolean isFoil(ItemStack itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack, null);
        return mobCaptureData != null && mobCaptureData.isFoil();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipConsumer, TooltipFlag tooltipFlag) {
        MobCaptureData mobCaptureData = MobCaptureManagerClient.getMobCaptureData(itemStack);
        if (mobCaptureData == null) {
            tooltipConsumer.accept((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.empty"));
            return;
        }
        tooltipConsumer.accept((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.name", MobCaptureCardItem.getTranslatedEntityName(mobCaptureData)));
        if (tooltipFlag.isAdvanced()) {
            tooltipConsumer.accept((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.description_id", mobCaptureData.name()));
            tooltipConsumer.accept((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.type", mobCaptureData.type()));
        }
        if (mobCaptureData.hasVariant()) {
            tooltipConsumer.accept((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.variant", mobCaptureData.variant()));
        }
        if (mobCaptureData.hasColor()) {
            tooltipConsumer.accept((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.color", mobCaptureData.color().getName()));
        }
        ChatFormatting rarityColor = switch (mobCaptureData.rarity()) {
            case Rarity.UNCOMMON -> ChatFormatting.GREEN;
            case Rarity.RARE -> ChatFormatting.BLUE;
            case Rarity.EPIC -> ChatFormatting.DARK_PURPLE;
            default -> ChatFormatting.GRAY;
        };
        tooltipConsumer.accept((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.rarity", mobCaptureData.rarity().name()).withStyle(rarityColor));
        tooltipConsumer.accept((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.id", String.valueOf(mobCaptureData.getCardId())));
        MobCaptureCardItem.addSpecialMechanicsTooltips(mobCaptureData, tooltipConsumer);
    }
}

