/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureDataSupport;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MobEntityTypeData {
    public static final String TYPE_TAG = "Type";
    public static final String ENTITY_TYPE_TAG = "EntityTag";
    public static final String ID_TAG = "id";

    private MobEntityTypeData() {
    }

    public static String getEntityTypeName(LivingEntity livingEntity) {
        return MobEntityTypeData.getEntityTypeName(livingEntity.getType());
    }

    public static String getEntityTypeName(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString();
    }

    public static String getEntityTypeName(ItemStack itemStack, CompoundTag compoundTag, Level level) {
        String entityTypeName;
        if (itemStack == null || itemStack.isEmpty()) {
            return MobEntityTypeData.getEntityTypeName(compoundTag);
        }
        if (MobCaptureDataSupport.isSupported(itemStack) && (entityTypeName = MobCaptureDataSupport.getEntityTypeName(itemStack, level)) != null) {
            return entityTypeName;
        }
        return MobEntityTypeData.getEntityTypeName(compoundTag);
    }

    public static String getEntityTypeName(CompoundTag compoundTag) {
        CompoundTag entityTypeTag;
        if (compoundTag == null) {
            return "";
        }
        if (compoundTag.contains(TYPE_TAG) && compoundTag.getString(TYPE_TAG).isPresent()) {
            return (String)compoundTag.getString(TYPE_TAG).get();
        }
        if (compoundTag.contains(ENTITY_TYPE_TAG) && compoundTag.getCompound(ENTITY_TYPE_TAG).isPresent() && (entityTypeTag = (CompoundTag)compoundTag.getCompound(ENTITY_TYPE_TAG).get()).contains(ID_TAG) && entityTypeTag.getString(ID_TAG).isPresent()) {
            return (String)entityTypeTag.getString(ID_TAG).get();
        }
        return "";
    }

    public static EntityType<?> getEntityType(ItemStack itemStack, CompoundTag compoundTag, Level level) {
        EntityType<?> entityType;
        if (itemStack == null || itemStack.isEmpty()) {
            return MobEntityTypeData.getEntityType(compoundTag);
        }
        if (MobCaptureDataSupport.isSupported(itemStack) && (entityType = MobCaptureDataSupport.getEntityType(itemStack, level)) != null) {
            return entityType;
        }
        return MobEntityTypeData.getEntityType(compoundTag);
    }

    public static EntityType<?> getEntityType(EntityType<?> entityType) {
        return entityType;
    }

    public static EntityType<?> getEntityType(LivingEntity livingEntity) {
        return livingEntity.getType();
    }

    public static EntityType<?> getEntityType(CompoundTag compoundTag) {
        String entityTypeName = MobEntityTypeData.getEntityTypeName(compoundTag);
        if (entityTypeName != null) {
            return EntityType.byString((String)entityTypeName).orElse(null);
        }
        return null;
    }
}

