/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.markusbordihn.easymobfarm.data.capture.MobColor;
import de.markusbordihn.easymobfarm.data.capture.MobColorData;
import de.markusbordihn.easymobfarm.data.capture.MobEntityData;
import de.markusbordihn.easymobfarm.data.capture.MobEntityTypeData;
import de.markusbordihn.easymobfarm.data.capture.MobFoilData;
import de.markusbordihn.easymobfarm.data.capture.MobNameData;
import de.markusbordihn.easymobfarm.data.capture.MobRarityData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public record MobCaptureData(String name, String type, EntityType<?> entityType, CompoundTag data, MobColor color, String variant, Rarity rarity, boolean isFoil) {
    public static final String ID = "mob_capture_data";
    public static final String TYPE_SEPARATOR = ":";
    public static final MobCaptureData EMPTY = new MobCaptureData("", "", EntityType.ARMOR_STAND, new CompoundTag(), MobColor.NONE, "", Rarity.COMMON, false);
    public static final Codec<MobCaptureData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(MobCaptureData::name), (App)Codec.STRING.fieldOf("type").forGetter(MobCaptureData::type), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entityType").forGetter(MobCaptureData::entityType), (App)CompoundTag.CODEC.optionalFieldOf("data", (Object)new CompoundTag()).forGetter(MobCaptureData::data), (App)MobColor.CODEC.optionalFieldOf("color", (Object)MobColor.NONE).forGetter(MobCaptureData::color), (App)Codec.STRING.optionalFieldOf("variant", (Object)"").forGetter(MobCaptureData::variant), (App)Rarity.CODEC.optionalFieldOf("rarity", (Object)Rarity.COMMON).forGetter(MobCaptureData::rarity), (App)Codec.BOOL.optionalFieldOf("isFoil", (Object)false).forGetter(MobCaptureData::isFoil)).apply((Applicative)instance, MobCaptureData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MobCaptureData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, MobCaptureData::name, (StreamCodec)ByteBufCodecs.STRING_UTF8, MobCaptureData::type, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE), MobCaptureData::entityType, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, MobCaptureData::data, MobColor.STREAM_CODEC, MobCaptureData::color, (StreamCodec)ByteBufCodecs.STRING_UTF8, MobCaptureData::variant, (StreamCodec)Rarity.STREAM_CODEC, MobCaptureData::rarity, (StreamCodec)ByteBufCodecs.BOOL, MobCaptureData::isFoil, MobCaptureData::new);
    private static final int MAX_ID_LIMIT = 0x1000000;

    public MobCaptureData(String name, EntityType<?> entityType, Rarity rarity) {
        this(name, MobEntityTypeData.getEntityTypeName(entityType), MobEntityTypeData.getEntityType(entityType), MobEntityData.getMobEntityData(entityType), MobColorData.getColor(entityType), MobVariantData.getVariant(entityType), rarity, MobFoilData.getRandomFoil());
    }

    public MobCaptureData(EntityType<?> entityType) {
        this(MobNameData.getName(entityType), MobEntityTypeData.getEntityTypeName(entityType), MobEntityTypeData.getEntityType(entityType), MobEntityData.getMobEntityData(entityType), MobColorData.getColor(entityType), MobVariantData.getVariant(entityType), MobRarityData.getRarity(entityType), MobFoilData.getRandomFoil());
    }

    public MobCaptureData(LivingEntity livingEntity) {
        this(MobNameData.getName(livingEntity), MobEntityTypeData.getEntityTypeName(livingEntity), MobEntityTypeData.getEntityType(livingEntity), MobEntityData.getMobEntityData(livingEntity), MobColorData.getColor(livingEntity), MobVariantData.getVariant(livingEntity), MobRarityData.getRarity(livingEntity), MobFoilData.getRandomFoil());
    }

    public MobCaptureData(ItemStack itemStack, CompoundTag compoundTag, Level level) {
        this(MobNameData.getName(compoundTag), MobEntityTypeData.getEntityTypeName(itemStack, compoundTag, level), MobEntityTypeData.getEntityType(itemStack, compoundTag, level), MobEntityData.getMobEntityData(compoundTag), MobColorData.getColor(compoundTag), MobVariantData.getVariant(compoundTag), MobRarityData.getRarity(compoundTag), MobFoilData.getFoil(compoundTag));
    }

    public MobCaptureData(ItemStack itemStack, CompoundTag compoundTag) {
        this(MobNameData.getName(compoundTag), MobEntityTypeData.getEntityTypeName(itemStack, compoundTag, null), MobEntityTypeData.getEntityType(itemStack, compoundTag, null), MobEntityData.getMobEntityData(compoundTag), MobColorData.getColor(compoundTag), MobVariantData.getVariant(compoundTag), MobRarityData.getRarity(compoundTag), MobFoilData.getFoil(compoundTag));
    }

    public MobCaptureData(CompoundTag compoundTag) {
        this(MobNameData.getName(compoundTag), MobEntityTypeData.getEntityTypeName(compoundTag), MobEntityTypeData.getEntityType(compoundTag), MobEntityData.getMobEntityData(compoundTag), MobColorData.getColor(compoundTag), MobVariantData.getVariant(compoundTag), MobRarityData.getRarity(compoundTag), MobFoilData.getFoil(compoundTag));
    }

    public int getCardId() {
        int namespaceHash = 0;
        int pathHash = 0;
        if (this.type != null) {
            String[] parts = this.type.split(TYPE_SEPARATOR);
            if (parts.length > 0) {
                namespaceHash = parts[0].hashCode();
            }
            if (parts.length > 1) {
                pathHash = parts[1].hashCode();
            }
        }
        int colorHash = this.color != null ? this.color.hashCode() : 0;
        int variantHash = this.variant != null ? this.variant.hashCode() : 0;
        int result = 17;
        result = 31 * result + namespaceHash;
        result = 31 * result + pathHash;
        result = 31 * result + colorHash;
        result = 31 * result + variantHash;
        result = 31 * result + (this.isFoil ? 1 : 0);
        result ^= result >>> 16;
        return (result & Integer.MAX_VALUE) % 0x1000000;
    }

    public MobCaptureData withColor(MobColor color) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, color, this.variant, this.rarity, this.isFoil);
    }

    public MobCaptureData withVariant(String variant) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, variant, this.rarity, this.isFoil);
    }

    public MobCaptureData withRarity(Rarity rarity) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, this.variant, rarity, this.isFoil);
    }

    public MobCaptureData withFoil(boolean isFoil) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, this.variant, this.rarity, isFoil);
    }

    public MobCaptureData withData(CompoundTag data) {
        return new MobCaptureData(this.name, this.type, this.entityType, data, this.color, this.variant, this.rarity, this.isFoil);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean hasColor() {
        return this.color != null && this.color != MobColor.NONE;
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public boolean hasVariant() {
        return this.variant != null && !this.variant.isEmpty();
    }

    public boolean hasRarity() {
        return this.rarity != null;
    }

    @Override
    public String toString() {
        return "MobCaptureData{, name='" + this.name + ", entityType=" + String.valueOf(this.entityType) + ", color=" + String.valueOf((Object)this.color) + ", variant=" + this.variant + ", rarity=" + String.valueOf(this.rarity) + ", isFoil=" + this.isFoil + ", data=" + String.valueOf(this.data) + "}";
    }
}

