/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import java.io.File;
import java.util.Properties;
import java.util.Set;

public class MobCaptureCardConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mob_capture_card.cfg";
    public static final String CONFIG_FILE_HEADER = " Mob Capture Card Configuration\n\n This configuration file allows you to define the general settings for the Mob Capture Cards.\n\n Configuration Options:\n ----------------------\n dropMobCaptureCardOnKill: Enable mob capture card drops when killing mobs (default: true)\n dropMobCaptureCardOnFishing: Enable mob capture card drops when fishing (default: true)\n\n requirePlayerKill: Only drop cards when player kills the mob (default: true)\n mobCaptureCardKillDropChance: Drop chance for kill drops (0.0-1.0, default: 0.1 = 10%)\n mobCaptureCardFishingDropChance: Drop chance for fishing drops (0.0-1.0, default: 0.15 = 15%)\n mobCaptureCardFoilDropChance: Drop chance for foil cards (0.0-1.0, default: 0.01 = 1%)\n\n Allow and Deny list\n -------------------\n If you want to allow or deny specific mobs, you can use the allow and deny list.\n Keep in mind that if you add a mob to the allow list, all other mobs will be denied by default.\n There are two separate lists for kill and fishing drops.\n\n  Example for allow only specific mobs:\n    mobCaptureCardKillDropAllowList=minecraft:zombie,minecraft:skeleton\n    mobCaptureCardKillDropDenyList=\n    mobCaptureCardFishingDropAllowList=minecraft:cod,minecraft:salmon\n    mobCaptureCardFishingDropDenyList=\n\n  Example for deny specific mobs:\n    mobCaptureCardKillDropAllowList=\n    mobCaptureCardKillDropDenyList=minecraft:ender_dragon,minecraft:wither\n    mobCaptureCardFishingDropAllowList=\n    mobCaptureCardFishingDropDenyList=minecraft:squid,minecraft:turtle\n\n\n";
    public static boolean dropMobCaptureCardOnKill = true;
    public static boolean dropMobCaptureCardOnFishing = true;
    public static boolean requirePlayerKill = true;
    public static float mobCaptureCardKillDropChance = 0.1f;
    public static float mobCaptureCardFishingDropChance = 0.15f;
    public static float mobCaptureCardFoilDropChance = 0.01f;
    public static Set<String> mobCaptureCardKillDropAllowList = Set.of();
    public static Set<String> mobCaptureCardKillDropDenyList = Set.of();
    public static Set<String> mobCaptureCardFishingDropAllowList = Set.of();
    public static Set<String> mobCaptureCardFishingDropDenyList = Set.of();

    public static void registerConfig() {
        MobCaptureCardConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MobCaptureCardConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = MobCaptureCardConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MobCaptureCardConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        dropMobCaptureCardOnKill = MobCaptureCardConfig.parseConfigValue(properties, "dropMobCaptureCardOnKill", dropMobCaptureCardOnKill);
        dropMobCaptureCardOnFishing = MobCaptureCardConfig.parseConfigValue(properties, "dropMobCaptureCardOnFishing", dropMobCaptureCardOnFishing);
        requirePlayerKill = MobCaptureCardConfig.parseConfigValue(properties, "requirePlayerKill", requirePlayerKill);
        mobCaptureCardKillDropChance = MobCaptureCardConfig.parseConfigValue(properties, "mobCaptureCardKillDropChance", mobCaptureCardKillDropChance);
        mobCaptureCardFishingDropChance = MobCaptureCardConfig.parseConfigValue(properties, "mobCaptureCardFishingDropChance", mobCaptureCardFishingDropChance);
        mobCaptureCardFoilDropChance = MobCaptureCardConfig.parseConfigValue(properties, "mobCaptureCardFoilDropChance", mobCaptureCardFoilDropChance);
        mobCaptureCardKillDropAllowList = MobCaptureCardConfig.parseConfigValue(properties, "mobCaptureCardKillDropAllowList", mobCaptureCardKillDropAllowList);
        mobCaptureCardKillDropDenyList = MobCaptureCardConfig.parseConfigValue(properties, "mobCaptureCardKillDropDenyList", mobCaptureCardKillDropDenyList);
        mobCaptureCardFishingDropAllowList = MobCaptureCardConfig.parseConfigValue(properties, "mobCaptureCardFishingDropAllowList", mobCaptureCardFishingDropAllowList);
        mobCaptureCardFishingDropDenyList = MobCaptureCardConfig.parseConfigValue(properties, "mobCaptureCardFishingDropDenyList", mobCaptureCardFishingDropDenyList);
        MobCaptureCardConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

