/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.manager;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.fish.AbstractFish;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RendererManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Map<BlockPos, Entity> entityMap = new HashMap<BlockPos, Entity>();
    private static int validationCounter = 0;

    private RendererManager() {
    }

    public static Entity getOrCreateEntity(MobFarmBlockEntity mobFarmBlockEntity) {
        Entity entity;
        if (mobFarmBlockEntity == null) {
            return null;
        }
        BlockPos blockPos = mobFarmBlockEntity.getBlockPos();
        if (!mobFarmBlockEntity.hasCapturedMob()) {
            entityMap.remove(blockPos);
            return null;
        }
        Entity cachedEntity = entityMap.get(blockPos);
        if (cachedEntity != null) {
            if (++validationCounter >= 100) {
                validationCounter = 0;
                MobCaptureData mobCaptureData = mobFarmBlockEntity.getMobCaptureData();
                if (mobCaptureData != null && cachedEntity.getType() != mobCaptureData.entityType()) {
                    entityMap.remove(blockPos);
                    cachedEntity = null;
                }
            }
            if (cachedEntity != null) {
                return cachedEntity;
            }
        }
        if ((entity = RendererManager.createEntity(mobFarmBlockEntity)) != null) {
            entityMap.put(blockPos, entity);
        }
        return entity;
    }

    public static Entity getEntity(BlockPos blockPos) {
        return entityMap.get(blockPos);
    }

    public static void removeEntity(MobFarmBlockEntity mobFarmBlockEntity) {
        RendererManager.removeEntity(mobFarmBlockEntity.getBlockPos());
    }

    public static void removeEntity(BlockPos blockPos) {
        entityMap.remove(blockPos);
    }

    private static Entity createEntity(MobFarmBlockEntity mobFarmBlockEntity) {
        if (mobFarmBlockEntity == null || mobFarmBlockEntity.getLevel() == null) {
            log.error("Unable to create entity for Mob Farm Block Entity {}", (Object)mobFarmBlockEntity);
            return null;
        }
        MobCaptureData mobCaptureData = mobFarmBlockEntity.getMobCaptureData();
        if (mobCaptureData == null) {
            log.error("Unable to get Mob Capture data from Mob Farm Block Entity {}", (Object)mobFarmBlockEntity);
            return null;
        }
        EntityType<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            log.error("Unable to get entity type from Mob Capture data {}", (Object)mobCaptureData);
            return null;
        }
        Entity entity = entityType.create(mobFarmBlockEntity.getLevel(), EntitySpawnReason.EVENT);
        if (entity == null) {
            log.error("Unable to create entity for entity type {}", entityType);
            return null;
        }
        entity.tick();
        entity.setPos(0.0, 0.0, 0.0);
        entity.setDeltaMovement(Vec3.ZERO);
        entity.xOld = 0.0;
        entity.yOld = 0.0;
        entity.zOld = 0.0;
        entity.setOnGround(true);
        entity.flyDist = 0.0f;
        entity.tick();
        entity.setYHeadRot(mobFarmBlockEntity.getLevel().random.nextFloat() * 60.0f);
        entity.setYBodyRot(mobFarmBlockEntity.getLevel().random.nextFloat() * 10.0f);
        entity.xRotO = entity.getXRot();
        entity.yRotO = entity.getYRot();
        CompoundTag mobDataTag = mobCaptureData.data();
        ValueInput valueInput = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)entity.level().registryAccess(), (CompoundTag)mobDataTag);
        entity.load(valueInput);
        entity.tick();
        if (entity instanceof AbstractFish) {
            AbstractFish fishEntity = (AbstractFish)entity;
            fishEntity.setNoGravity(true);
            fishEntity.setSwimming(true);
        }
        if (entity instanceof Sheep) {
            Sheep sheepEntity = (Sheep)entity;
            sheepEntity.setSheared(false);
            if (mobCaptureData.hasColor()) {
                sheepEntity.setColor(mobCaptureData.color().getDyeColor());
            }
        }
        if (entity instanceof PathfinderMob) {
            PathfinderMob newPathfinderMob = (PathfinderMob)entity;
            newPathfinderMob.setNoAi(true);
            newPathfinderMob.setSilent(true);
            newPathfinderMob.noPhysics = true;
        }
        entity.noPhysics = true;
        return entity;
    }
}

