/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class LocationSoundPacket
extends SoundPacket<LocationSoundPacket> {
    protected Vec3 location;
    protected float distance;

    public LocationSoundPacket(UUID channelId, UUID sender, Vec3 location, byte[] data, long sequenceNumber, float distance, @Nullable String category) {
        super(channelId, sender, data, sequenceNumber, category);
        this.location = location;
        this.distance = distance;
    }

    public LocationSoundPacket(UUID channelId, UUID sender, short[] data, Vec3 location, float distance, @Nullable String category) {
        super(channelId, sender, data, category);
        this.location = location;
        this.distance = distance;
    }

    public LocationSoundPacket() {
    }

    public Vec3 getLocation() {
        return this.location;
    }

    public float getDistance() {
        return this.distance;
    }

    @Override
    public LocationSoundPacket fromBytes(FriendlyByteBuf buf) {
        LocationSoundPacket soundPacket = new LocationSoundPacket();
        soundPacket.channelId = buf.readUUID();
        soundPacket.sender = buf.readUUID();
        soundPacket.location = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        soundPacket.data = buf.readByteArray();
        soundPacket.sequenceNumber = buf.readLong();
        soundPacket.distance = buf.readFloat();
        byte data = buf.readByte();
        if (this.hasFlag(data, (byte)2)) {
            soundPacket.category = buf.readUtf(16);
        }
        return soundPacket;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.channelId);
        buf.writeUUID(this.sender);
        buf.writeDouble(this.location.x);
        buf.writeDouble(this.location.y);
        buf.writeDouble(this.location.z);
        buf.writeByteArray(this.data);
        buf.writeLong(this.sequenceNumber);
        buf.writeFloat(this.distance);
        byte data = 0;
        if (this.category != null) {
            data = this.setFlag(data, (byte)2);
        }
        buf.writeByte((int)data);
        if (this.category != null) {
            buf.writeUtf(this.category, 16);
        }
    }
}

