/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.resourcepacks;

import com.google.common.collect.ImmutableSet;
import de.maxhenkel.voicechat.Voicechat;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackFormat;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;

public class VoiceChatResourcePack
extends AbstractPackResources
implements Pack.ResourcesSupplier {
    public VoiceChatResourcePack(String id, Component name) {
        super(new PackLocationInfo(id, name, PackSource.BUILT_IN, Optional.empty()));
    }

    public Pack toPack() {
        PackFormat format = SharedConstants.getCurrentVersion().packVersion(PackType.CLIENT_RESOURCES);
        Pack.Metadata meta = Pack.readPackMetadata((PackLocationInfo)this.location(), (Pack.ResourcesSupplier)this, (PackFormat)format, (PackType)PackType.CLIENT_RESOURCES);
        if (meta == null) {
            throw new IllegalStateException("Could not find builtin resource pack info");
        }
        return Pack.readMetaAndCreate((PackLocationInfo)this.location(), (Pack.ResourcesSupplier)this, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
    }

    private String getPath() {
        return "/packs/" + this.packId() + "/";
    }

    @Nullable
    private InputStream get(String name) {
        return Voicechat.class.getResourceAsStream(this.getPath() + name);
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... strings) {
        return this.getResource(String.join((CharSequence)"/", strings));
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, Identifier identifier) {
        return this.getRootResource(packType.getDirectory(), identifier.getNamespace(), identifier.getPath());
    }

    @Nullable
    private IoSupplier<InputStream> getResource(String path) {
        InputStream resourceAsStream = this.get(path);
        if (resourceAsStream == null) {
            return null;
        }
        return () -> resourceAsStream;
    }

    public void listResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput resourceOutput) {
        try {
            URL url = Voicechat.class.getResource(this.getPath());
            if (url == null) {
                return;
            }
            Path namespacePath = Paths.get(url.toURI()).resolve(type.getDirectory()).resolve(namespace);
            Path resPath = namespacePath.resolve(prefix);
            if (!Files.exists(resPath, new LinkOption[0])) {
                return;
            }
            try (Stream<Path> files = Files.walk(resPath, new FileVisitOption[0]);){
                files.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    Identifier identifier = Identifier.fromNamespaceAndPath((String)namespace, (String)VoiceChatResourcePack.convertPath(path).substring(VoiceChatResourcePack.convertPath(namespacePath).length() + 1));
                    resourceOutput.accept((Object)identifier, this.getResource(type, identifier));
                });
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to list builtin pack resources", e);
        }
    }

    private static String convertPath(Path path) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < path.getNameCount(); ++i) {
            stringBuilder.append(path.getName(i));
            if (i >= path.getNameCount() - 1) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public Set<String> getNamespaces(PackType packType) {
        if (packType == PackType.CLIENT_RESOURCES) {
            return ImmutableSet.of((Object)"voicechat");
        }
        return ImmutableSet.of();
    }

    public void close() {
    }

    public PackResources openPrimary(PackLocationInfo packLocationInfo) {
        return this;
    }

    public PackResources openFull(PackLocationInfo packLocationInfo, Pack.Metadata metadata) {
        return this;
    }
}

