/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.intercompatibility;

import com.mojang.blaze3d.platform.InputConstants;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.Connection;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.client.event.AddGuiOverlayLayersEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.gui.overlay.ForgeLayeredDraw;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;

public class ForgeClientCompatibilityManager
extends ClientCompatibilityManager {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final List<ClientCompatibilityManager.RenderNameplateEvent> renderNameplateEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.RenderNameplateEvent>();
    private final List<ClientCompatibilityManager.RenderHUDEvent> renderHUDEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.RenderHUDEvent>();
    private final List<ClientCompatibilityManager.KeyboardEvent> keyboardEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.KeyboardEvent>();
    private final List<ClientCompatibilityManager.MouseEvent> mouseEvents = new CopyOnWriteArrayList<ClientCompatibilityManager.MouseEvent>();
    private final List<Runnable> clientTickEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> inputEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> disconnectEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> joinWorldEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<ClientVoicechatConnection>> voicechatConnectEvents = new CopyOnWriteArrayList<Consumer<ClientVoicechatConnection>>();
    private final List<Runnable> voicechatDisconnectEvents = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<Integer>> publishServerEvents = new CopyOnWriteArrayList<Consumer<Integer>>();
    private final List<KeyMapping> keyMappings = new CopyOnWriteArrayList<KeyMapping>();
    private static final Identifier VOICECHAT_ICONS_LAYER = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"icons");
    private boolean wasPublished;

    public void onRenderName(RenderNameTagEvent event) {
        this.renderNameplateEvents.forEach(renderNameplateEvent -> renderNameplateEvent.render(event.getState(), event.getCameraState(), event.getPoseStack(), event.getNodeCollector()));
    }

    public void onAddGuiOverlayLayers(AddGuiOverlayLayersEvent event) {
        event.getLayeredDraw().add(VOICECHAT_ICONS_LAYER, (gg, dt) -> this.renderHUDEvents.forEach(renderHUDEvent -> renderHUDEvent.render(gg, dt.getRealtimeDeltaTicks())));
        event.getLayeredDraw().putBelow(ForgeLayeredDraw.VANILLA_ROOT, VOICECHAT_ICONS_LAYER, ForgeLayeredDraw.POTION_EFFECTS);
    }

    public void onKey(InputEvent.Key event) {
        this.keyboardEvents.forEach(keyboardEvent -> keyboardEvent.onKeyboardEvent(new KeyEvent(event.getKey(), event.getScanCode(), event.getModifiers())));
    }

    public void onMouse(InputEvent.MouseButton.Pre event) {
        this.mouseEvents.forEach(mouseEvent -> mouseEvent.onMouseEvent(new MouseButtonInfo(event.getButton(), event.getModifiers()), event.getAction()));
    }

    public void onClientTick(TickEvent.ClientTickEvent.Pre event) {
        this.clientTickEvents.forEach(Runnable::run);
    }

    public void onKeyInput(TickEvent.ClientTickEvent.Post event) {
        this.inputEvents.forEach(Runnable::run);
    }

    public void onDisconnect(LevelEvent.Unload event) {
        if (this.minecraft.gameMode == null) {
            this.disconnectEvents.forEach(Runnable::run);
        }
    }

    public void onJoinServer(ClientPlayerNetworkEvent.LoggingIn event) {
        if (event.getPlayer() != this.minecraft.player) {
            return;
        }
        this.joinWorldEvents.forEach(Runnable::run);
    }

    public void onServer(TickEvent.ServerTickEvent event) {
        IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
        if (server == null) {
            return;
        }
        boolean published = server.isPublished();
        if (published && !this.wasPublished) {
            this.publishServerEvents.forEach(portConsumer -> portConsumer.accept(server.getPort()));
        }
        this.wasPublished = published;
    }

    public void onRegisterKeyBinds(RegisterKeyMappingsEvent event) {
        for (KeyMapping mapping : this.keyMappings) {
            event.register(mapping);
        }
    }

    @Override
    public void onRenderNamePlate(ClientCompatibilityManager.RenderNameplateEvent onRenderNamePlate) {
        this.renderNameplateEvents.add(onRenderNamePlate);
    }

    @Override
    public void onRenderHUD(ClientCompatibilityManager.RenderHUDEvent onRenderHUD) {
        this.renderHUDEvents.add(onRenderHUD);
    }

    @Override
    public void onKeyboardEvent(ClientCompatibilityManager.KeyboardEvent onKeyboardEvent) {
        this.keyboardEvents.add(onKeyboardEvent);
    }

    @Override
    public void onMouseEvent(ClientCompatibilityManager.MouseEvent onMouseEvent) {
        this.mouseEvents.add(onMouseEvent);
    }

    @Override
    public void onClientTick(Runnable onClientTick) {
        this.clientTickEvents.add(onClientTick);
    }

    @Override
    public InputConstants.Key getBoundKeyOf(KeyMapping keyBinding) {
        return keyBinding.getKey();
    }

    @Override
    public void onHandleKeyBinds(Runnable onHandleKeyBinds) {
        this.inputEvents.add(onHandleKeyBinds);
    }

    @Override
    public KeyMapping registerKeyBinding(KeyMapping keyBinding) {
        this.keyMappings.add(keyBinding);
        return keyBinding;
    }

    @Override
    public void emitVoiceChatConnectedEvent(ClientVoicechatConnection client) {
        this.voicechatConnectEvents.forEach(consumer -> consumer.accept(client));
    }

    @Override
    public void emitVoiceChatDisconnectedEvent() {
        this.voicechatDisconnectEvents.forEach(Runnable::run);
    }

    @Override
    public void onVoiceChatConnected(Consumer<ClientVoicechatConnection> onVoiceChatConnected) {
        this.voicechatConnectEvents.add(onVoiceChatConnected);
    }

    @Override
    public void onVoiceChatDisconnected(Runnable onVoiceChatDisconnected) {
        this.voicechatDisconnectEvents.add(onVoiceChatDisconnected);
    }

    @Override
    public void emitDisconnectedEvent() {
        this.disconnectEvents.forEach(Runnable::run);
    }

    @Override
    public void onDisconnect(Runnable onDisconnect) {
        this.disconnectEvents.add(onDisconnect);
    }

    @Override
    public void onJoinWorld(Runnable onJoinWorld) {
        this.joinWorldEvents.add(onJoinWorld);
    }

    @Override
    public void onPublishServer(Consumer<Integer> onPublishServer) {
        this.publishServerEvents.add(onPublishServer);
    }

    @Override
    public SocketAddress getSocketAddress(Connection connection) {
        return connection.channel().remoteAddress();
    }

    @Override
    public void addResourcePackSource(RepositorySource repositorySource) {
        this.minecraft.getResourcePackRepository().addPackFinder(repositorySource);
    }
}

