/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.EnterPasswordScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupEntry;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.net.ClientServerNetManager;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;

public class JoinGroupList
extends ListScreenListBase<JoinGroupEntry> {
    protected final ListScreenBase parent;

    public JoinGroupList(ListScreenBase parent, int width, int height, int top, int itemSize) {
        super(width, height, top, itemSize);
        this.parent = parent;
        this.updateGroups();
    }

    public boolean mouseClicked(MouseButtonEvent evt, boolean bl) {
        JoinGroupEntry entry = (JoinGroupEntry)this.getEntryAtPosition(evt.x(), evt.y());
        if (entry == null) {
            return false;
        }
        ClientGroup group = entry.getGroup().getGroup();
        this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        if (group.hasPassword()) {
            this.minecraft.setScreen((Screen)new EnterPasswordScreen(group));
        } else {
            ClientServerNetManager.sendToServer(new JoinGroupPacket(group.getId(), null));
        }
        return true;
    }

    private void updateGroups() {
        Map<UUID, JoinGroupEntry.Group> groups = ClientManager.getGroupManager().getGroups().stream().filter(clientGroup -> !clientGroup.isHidden()).collect(Collectors.toMap(ClientGroup::getId, JoinGroupEntry.Group::new));
        List<PlayerState> playerStates = ClientManager.getPlayerStateManager().getPlayerStates(true);
        for (PlayerState state : playerStates) {
            JoinGroupEntry.Group group2;
            if (!state.hasGroup() || (group2 = groups.get(state.getGroup())) == null) continue;
            group2.getMembers().add(state);
        }
        groups.values().forEach(group -> group.getMembers().sort(Comparator.comparing(PlayerState::getName)));
        this.replaceEntries(groups.values().stream().map(group -> new JoinGroupEntry(this.parent, (JoinGroupEntry.Group)group)).sorted(Comparator.comparing(o -> o.getGroup().getGroup().getName())).collect(Collectors.toList()));
    }

    public static void update() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof JoinGroupScreen) {
            JoinGroupScreen joinGroupScreen = (JoinGroupScreen)screen;
            joinGroupScreen.groupList.updateGroups();
        }
    }

    public boolean isEmpty() {
        return this.children().isEmpty();
    }
}

