/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import org.joml.Matrix3x2fStack;

public class AudioDeviceEntry
extends ListScreenEntryBase<AudioDeviceEntry> {
    protected static final Identifier SELECTED = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/icons/device_selected.png");
    protected static final int PADDING = 4;
    protected static final int BG_FILL = ARGB.color((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_HOVERED = ARGB.color((int)255, (int)90, (int)90, (int)90);
    protected static final int BG_FILL_SELECTED = ARGB.color((int)255, (int)40, (int)40, (int)40);
    protected static final int DEVICE_NAME_COLOR = ARGB.color((int)255, (int)255, (int)255, (int)255);
    protected final Minecraft minecraft;
    protected final String device;
    protected final Component name;
    @Nullable
    protected final Identifier icon;
    protected final Supplier<Boolean> isSelected;

    public AudioDeviceEntry(String device, Component name, @Nullable Identifier icon, Supplier<Boolean> isSelected) {
        this.device = device;
        this.icon = icon;
        this.isSelected = isSelected;
        this.name = name;
        this.minecraft = Minecraft.getInstance();
    }

    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float delta) {
        int left = this.getContentX();
        int top = this.getContentY();
        int width = this.getContentWidth();
        int height = this.getContentHeight();
        boolean selected = this.isSelected.get();
        if (selected) {
            guiGraphics.fill(left, top, left + width, top + height, BG_FILL_SELECTED);
        } else if (hovered) {
            guiGraphics.fill(left, top, left + width, top + height, BG_FILL_HOVERED);
        } else {
            guiGraphics.fill(left, top, left + width, top + height, BG_FILL);
        }
        if (this.icon != null) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.icon, left + 4, top + height / 2 - 8, 16.0f, 16.0f, 16, 16, 16, 16);
        }
        if (selected) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, SELECTED, left + 4, top + height / 2 - 8, 16.0f, 16.0f, 16, 16, 16, 16);
        }
        float deviceWidth = this.minecraft.font.width((FormattedText)this.name);
        float space = width - 4 - 16 - 4 - 4;
        float scale = Math.min(space / deviceWidth, 1.0f);
        guiGraphics.pose().pushMatrix();
        Matrix3x2fStack matrix3x2fStack = guiGraphics.pose();
        float f = left + 4 + 16 + 4;
        float f2 = top + height / 2;
        Objects.requireNonNull(this.minecraft.font);
        matrix3x2fStack.translate(f, f2 - 9.0f * scale / 2.0f);
        guiGraphics.pose().scale(scale, scale);
        guiGraphics.drawString(this.minecraft.font, this.name, 0, 0, DEVICE_NAME_COLOR, false);
        guiGraphics.pose().popMatrix();
    }

    public String getDevice() {
        return this.device;
    }
}

