/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.deathquotes.utils;

import com.cazsius.deathquotes.config.Settings;
import com.cazsius.deathquotes.impl.LimitedSet;
import com.cazsius.deathquotes.utils.Constants;
import com.cazsius.deathquotes.utils.Logger;
import com.cazsius.deathquotes.utils.State;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;

public final class Funcs {
    private static String[] quotes = null;
    private static LimitedSet<Integer> quotesSet;
    private static final XoroshiroRandomSource randomGenerator;
    private static State state;

    public static State getState() {
        return state;
    }

    public static boolean copyQuotesToConfig() {
        Optional<InputStream> optionalInputStream = Funcs.getQuotesFileInputStreamFromJar();
        if (optionalInputStream.isEmpty()) {
            return false;
        }
        Path targetDirectory = Paths.get("./config/deathquotes.txt", new String[0]);
        try {
            Files.copy(optionalInputStream.get(), targetDirectory, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            Logger.error("Couldn't copy the file \"{}\" from jar to \"config\" folder!", "deathquotes.txt");
            return false;
        }
        try {
            optionalInputStream.get().close();
        }
        catch (IOException ex) {
            Logger.error(ex.getMessage(), new Object[0]);
        }
        return true;
    }

    public static boolean quotesFileExistsInConfig() {
        return Funcs.fileExists("./config/deathquotes.txt");
    }

    public static boolean configDirExists() {
        return Funcs.folderExists("./config/");
    }

    public static boolean fileExists(String filePathAndName) {
        File fh = new File(filePathAndName);
        return fh.exists() && !fh.isDirectory();
    }

    public static boolean folderExists(String folderPath) {
        File fh = new File(folderPath);
        return fh.exists() && fh.isDirectory();
    }

    public static boolean createConfigDir() {
        try {
            Files.createDirectories(Paths.get("./config/", new String[0]), new FileAttribute[0]);
            return true;
        }
        catch (Exception ex) {
            Logger.error("Couldn't create \"config\" folder in root directory!", new Object[0]);
            return false;
        }
    }

    private static Optional<InputStream> getQuotesFileInputStreamFromJar() {
        try {
            InputStream is = Funcs.class.getClassLoader().getResourceAsStream("assets/deathquotes.txt");
            if (is == null) {
                throw new IOException("Couldn't find asset \"deathquotes.txt\"");
            }
            return Optional.of(is);
        }
        catch (Exception ex) {
            Logger.error("Couldn't find the file \"{}\" in jar!", "deathquotes.txt");
            return Optional.empty();
        }
    }

    public static boolean loadQuotes() {
        State previousState = state;
        state = State.LOADING_QUOTES;
        Path sourceDirectory = Paths.get("./config/deathquotes.txt", new String[0]);
        boolean encodingException = true;
        ArrayList<Charset> charsets = new ArrayList<Charset>();
        charsets.add(StandardCharsets.UTF_8);
        if (!Charset.defaultCharset().equals(StandardCharsets.UTF_8)) {
            charsets.add(Charset.defaultCharset());
        }
        try {
            String oldSystemEncoding = System.getProperty("sun.jnu.encoding");
            Charset oldSystemCharset = Charset.forName(oldSystemEncoding);
            if (!oldSystemCharset.equals(StandardCharsets.UTF_8)) {
                charsets.add(oldSystemCharset);
            }
        }
        catch (IllegalArgumentException | SecurityException ex) {
            Logger.warn("Couldn't get encoding value from jvm property \"sun.jnu.encoding\"!", ex);
        }
        charsets.add(StandardCharsets.UTF_16);
        for (Charset charset : charsets) {
            try (Stream<String> lines = Files.lines(sourceDirectory, charset);){
                quotes = (String[])lines.filter(s -> !s.isBlank()).map(String::trim).toArray(String[]::new);
                int percent = Settings.getNonRepeatablePercent();
                int quotesNumber = switch (percent) {
                    case 0 -> 0;
                    case 100 -> quotes.length;
                    default -> (int)Math.ceil((double)quotes.length / 100.0 * (double)percent);
                };
                if (quotesNumber >= quotes.length) {
                    quotesNumber = quotes.length - 1;
                }
                quotesSet = new LimitedSet(quotesNumber, Settings.getClearListOfNonRepeatableQuotes());
            }
            catch (UncheckedIOException ex) {
                continue;
            }
            catch (IOException ex) {
                encodingException = false;
                break;
            }
            state = previousState;
            Logger.info("Loaded death quotes!", new Object[0]);
            Logger.info("Death quotes count - {}", Funcs.getQuotesLength());
            return true;
        }
        state = previousState;
        Logger.error("Couldn't read quotes the file \"{}\" from \"config\" folder{}!", "deathquotes.txt", encodingException ? String.format(" because encoding wasn't in the list of supported encodings: %s", charsets.stream().map(Charset::displayName).collect(Collectors.joining(", "))) : "");
        Logger.error("Death quotes won't work because there is no quotes available!", new Object[0]);
        Logger.error("You can delete the file {} and restart Minecraft for default quotes! Or edit that file and reload it in the game with command \"/deathquotes reloadQuotes\"!", "deathquotes.txt");
        return false;
    }

    public static void handlePlayerDeath(ServerPlayer player) {
        if (Funcs.getQuotesLength() == 0) {
            Logger.error("The file {} contains no quotes. Delete it and restart for default quotes. Or edit that file and reload it in the game with command \"/deathquotes reloadQuotes\"!", "deathquotes.txt");
            player.sendSystemMessage((Component)Component.literal((String)"The file deathquotes.txt contains no quotes. Check Minecraft logs!"));
            return;
        }
        String quote = Funcs.getRandomQuote();
        quote = Funcs.handleQuote(quote, (Player)player);
        MutableComponent tellrawComponent = Funcs.generateTellrawComponentForQuote(quote);
        for (ServerPlayer serverPlayer : player.level().getServer().getPlayerList().getPlayers()) {
            serverPlayer.sendSystemMessage((Component)tellrawComponent);
        }
    }

    public static int getQuotesLength() {
        return quotes == null ? 0 : quotes.length;
    }

    public static String getRandomQuote() {
        if (quotesSet.getSize() > 0) {
            int maxIterations = quotesSet.getSize() * 2;
            for (int i = 0; i < maxIterations; ++i) {
                int randomNumber = randomGenerator.nextInt(Funcs.getQuotesLength());
                if (quotesSet.contains(randomNumber)) continue;
                quotesSet.add(randomNumber);
                return quotes[randomNumber];
            }
            Logger.warn("Searched for the fresh unrepeated quote for too long (more than {} tries)! Getting a random one...", maxIterations);
        }
        return quotes[randomGenerator.nextInt(Funcs.getQuotesLength())];
    }

    public static String handleQuote(String quote, Player player) {
        String replaceString = Settings.getPlayerNameReplaceString();
        if (!replaceString.isBlank() && quote.contains(replaceString)) {
            quote = quote.replace(replaceString, player.getGameProfile().name());
        }
        if (!(replaceString = Settings.getNextLineReplaceString()).isBlank() && quote.contains(replaceString)) {
            quote = quote.replace(replaceString, "\n");
            if (Settings.getEnableTrimmingBeforeAndAfterNextLine()) {
                quote = quote.replaceAll("\\s*\\n\\s*", "\n");
            }
        }
        if (Settings.getEnableQuotationMarks()) {
            quote = String.format("\"%s\"", quote);
        }
        return quote;
    }

    public static MutableComponent generateTellrawComponentForQuote(String quote) {
        MutableComponent tellrawComponent = Component.empty();
        boolean enableItalics = Settings.getEnableItalics();
        if (Settings.getEnableHttpLinkProcessing() && Constants.httpLinkPattern.matcher(quote).find()) {
            List<MutableComponent> textInBetween = Arrays.stream(quote.split(Constants.httpLinkPattern.pattern())).map(string -> {
                MutableComponent textComponent = Component.literal((String)string);
                if (enableItalics) {
                    textComponent.withStyle(ChatFormatting.ITALIC);
                }
                return textComponent;
            }).toList();
            Matcher matcher = Constants.httpLinkPattern.matcher(quote);
            for (MutableComponent component : textInBetween) {
                tellrawComponent.append((Component)component);
                if (!matcher.find()) continue;
                MutableComponent mutableComponent = Funcs.getUrlLinkComponent(matcher.group("link"));
                if (enableItalics) {
                    mutableComponent.withStyle(ChatFormatting.ITALIC);
                }
                tellrawComponent.append((Component)mutableComponent);
            }
        } else {
            MutableComponent textComponent = Component.literal((String)quote);
            if (enableItalics) {
                textComponent.withStyle(ChatFormatting.ITALIC);
            }
            tellrawComponent.append((Component)textComponent);
        }
        return tellrawComponent;
    }

    public static MutableComponent getUrlLinkComponent(String link) {
        return Component.literal((String)link).setStyle(Style.EMPTY.applyFormat(ChatFormatting.BLUE).applyFormat(ChatFormatting.UNDERLINE).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(link))));
    }

    static {
        randomGenerator = new XoroshiroRandomSource(RandomSupport.upgradeSeedTo128bit((long)(0x2FD89DDCD351E3DCL ^ System.nanoTime())));
        state = State.IDLE;
    }
}

