/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.deathquotes.impl;

import java.util.LinkedHashSet;

public class LimitedSet<T> {
    private final LinkedHashSet<T> set = new LinkedHashSet();
    private final int size;
    private final boolean clearOnLimit;

    public LimitedSet(int size, boolean clearOnLimit) {
        this.size = size;
        this.clearOnLimit = clearOnLimit;
    }

    public int getSize() {
        return this.size;
    }

    private T first() {
        return this.set.getFirst();
    }

    public synchronized boolean add(T item) {
        if (this.set.size() >= this.size) {
            if (this.clearOnLimit) {
                this.set.clear();
            } else {
                this.set.remove(this.first());
            }
        }
        return this.set.add(item);
    }

    public synchronized boolean contains(T item) {
        return this.set.contains(item);
    }
}

