/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.deathquotes.config;

import com.cazsius.deathquotes.config.Settings;
import net.minecraftforge.common.ForgeConfigSpec;

public final class CommonConfig {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec spec;
    private static ForgeConfigSpec.BooleanValue showDeathQuotesRegardlessOfGameRule;
    private static ForgeConfigSpec.IntValue nonRepeatablePercent;
    private static ForgeConfigSpec.BooleanValue clearListOfNonRepeatableQuotes;
    private static ForgeConfigSpec.BooleanValue enableQuotationMarks;
    private static ForgeConfigSpec.BooleanValue enableItalics;
    private static ForgeConfigSpec.BooleanValue enableHttpLinkProcessing;
    private static ForgeConfigSpec.ConfigValue<String> playerNameReplaceString;
    private static ForgeConfigSpec.ConfigValue<String> nextLineReplaceString;
    private static ForgeConfigSpec.BooleanValue enableTrimmingBeforeAndAfterNextLine;

    public static void build() {
        builder.push("deathQuotes");
        CommonConfig.setMainOptions();
        CommonConfig.setFormattingOptions();
        builder.pop();
        spec = builder.build();
    }

    private static void setMainOptions() {
        builder.push("mainOptions");
        showDeathQuotesRegardlessOfGameRule = builder.comment("Specifies whether death quotes should be displayed based on the value of gamerule \"showDeathMessages\" or not, default is TRUE\nIf FALSE - death quotes will be displayed only if the value of gamerule \"showDeathMessages\" set to \"true\"\nIf TRUE - death quotes will be displayed regardless of the value of gamerule \"showDeathMessages\"").define("showDeathQuotesRegardlessOfGameRule", true);
        nonRepeatablePercent = builder.comment("Specifies the percentage of non-repeatable quotes\n100 - each quote is guaranteed to appear, but quotes will be repeated in a circle if option \"clearListOfNonRepeatableQuotes\" is set to FALSE\n0 - each quote might repeat frequently (i.e. old deathquotes mod behaviour)\n\nIf you change it in runtime - reload quotes from file \"deathquotes.txt\"!").defineInRange("nonRepeatablePercent", 5, 0, 100);
        clearListOfNonRepeatableQuotes = builder.comment("Specifies should the mod clear the list of non-repeatable quotes if percent stated above has been reached, default is FALSE\nIf FALSE - mod will keep the list and replace the oldest quote in that list with a new one\nIf TRUE - mod will clear the list, so the first few quotes will be completely random\n\nIf you set high percent, you might need to set this option to TRUE!\nIf you change it in runtime - reload quotes from file \"deathquotes.txt\"!").define("clearListOfNonRepeatableQuotes", false);
        playerNameReplaceString = builder.comment("String to replace with the player's name in the death message.\nEmpty string or string only with whitespaces will disable this feature!\n\nExample: '${{player_name}} didn't make it.'").define("playerNameReplaceString", (Object)"${{player_name}}");
        nextLineReplaceString = builder.comment("String to replace with the next line symbol in the death message.\nEmpty string or string only with whitespaces will disable this feature!\n\nIt can be used in dialogs for example:\nIn deathquotes.txt:\n- Did you do it?${{next_line}}- Yes...${{next_line}}- What did it cost?${{next_line}}- Everything...\nIn game:\n- Did you do it?\n- Yes...\n- What did it cost?\n- Everything...").define("nextLineReplaceString", (Object)"${{next_line}}");
        enableTrimmingBeforeAndAfterNextLine = builder.comment("Remove spaces and tabulation symbols before and after symbol specified in option \"nextLineReplaceString\" above.").define("enableTrimmingBeforeAndAfterNextLine", false);
        builder.pop();
    }

    private static void setFormattingOptions() {
        builder.push("formattingOptions");
        enableQuotationMarks = builder.comment("Specifies whether death messages should be in quotation marks, default is TRUE").define("enableQuotationMarks", true);
        enableItalics = builder.comment("Specifies whether death messages should be italicized, default is FALSE").define("enableItalics", false);
        enableHttpLinkProcessing = builder.comment("Specifies whether http(s) links in death messages should be clickable, default is FALSE\n\nNote: It's better to separate links with spaces for better recognition!\nExample: 'Quote with the links: \"https://www.google.com/\", https://www.youtube.com/watch?v=dQw4w9WgXcQ !'").define("enableHttpLinkProcessing", false);
        builder.pop();
    }

    public static ForgeConfigSpec getSpec() {
        return spec;
    }

    public static void pushChanges() {
        Settings.setShowDeathQuotesRegardlessOfGameRule((Boolean)showDeathQuotesRegardlessOfGameRule.get());
        Settings.setNonRepeatablePercent((Integer)nonRepeatablePercent.get());
        Settings.setClearListOfNonRepeatableQuotes((Boolean)clearListOfNonRepeatableQuotes.get());
        Settings.setEnableQuotationMarks((Boolean)enableQuotationMarks.get());
        Settings.setEnableItalics((Boolean)enableItalics.get());
        Settings.setEnableHttpLinkProcessing((Boolean)enableHttpLinkProcessing.get());
        Settings.setPlayerNameReplaceString((String)playerNameReplaceString.get());
        Settings.setNextLineReplaceString((String)nextLineReplaceString.get());
        Settings.setEnableTrimmingBeforeAndAfterNextLine((Boolean)enableTrimmingBeforeAndAfterNextLine.get());
    }
}

