/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.platform;

import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.PacketDistributor;
import tschipp.carryon.CarryOnCommonClient;
import tschipp.carryon.CarryOnForge;
import tschipp.carryon.Constants;
import tschipp.carryon.carry.CarryOnDataCapability;
import tschipp.carryon.carry.CarryOnDataCapabilityProvider;
import tschipp.carryon.carry.ICarryOnDataCapability;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.config.BuiltConfig;
import tschipp.carryon.config.forge.ConfigLoaderImpl;
import tschipp.carryon.networking.ClientboundSyncCarryDataPacket;
import tschipp.carryon.networking.PacketBase;
import tschipp.carryon.platform.services.IPlatformHelper;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public void registerConfig(BuiltConfig cfg) {
        ConfigLoaderImpl.registerConfig(cfg);
    }

    @Override
    public <T extends PacketBase, B extends FriendlyByteBuf> void registerServerboundPacket(CustomPacketPayload.Type<T> type, Class<T> clazz, StreamCodec<B, T> codec, BiConsumer<T, Player> handler, Object ... args) {
        BiConsumer<PacketBase, CustomPayloadEvent.Context> serverHandler = (packet, ctx) -> {
            if (ctx.isServerSide()) {
                ctx.setPacketHandled(true);
                ctx.enqueueWork(() -> handler.accept((Object)packet, (Player)ctx.getSender()));
            }
        };
        CarryOnForge.network.messageBuilder(clazz).codec(codec).consumerMainThread(serverHandler).add();
    }

    @Override
    public <T extends PacketBase, B extends FriendlyByteBuf> void registerClientboundPacket(CustomPacketPayload.Type<T> type, Class<T> clazz, StreamCodec<B, T> codec, BiConsumer<T, Player> handler, Object ... args) {
        BiConsumer<PacketBase, CustomPayloadEvent.Context> clientHandler = (packet, ctx) -> {
            if (ctx.isClientSide()) {
                ctx.setPacketHandled(true);
                ctx.enqueueWork(() -> handler.accept(packet, CarryOnCommonClient.getPlayer()));
            }
        };
        CarryOnForge.network.messageBuilder(clazz).codec(codec).consumerMainThread(clientHandler).add();
    }

    @Override
    public void sendPacketToServer(Identifier id, PacketBase packet) {
        CarryOnForge.network.send((Object)packet, PacketDistributor.SERVER.noArg());
    }

    @Override
    public void sendPacketToPlayer(Identifier id, PacketBase packet, ServerPlayer player) {
        CarryOnForge.network.send((Object)packet, PacketDistributor.PLAYER.with((Object)player));
    }

    @Override
    public CarryOnData getCarryData(Player player) {
        ICarryOnDataCapability cap = (ICarryOnDataCapability)player.getCapability(CarryOnDataCapabilityProvider.CARRY_ON_DATA_CAPABILITY).orElse((Object)new CarryOnDataCapability());
        return cap.getCarryData();
    }

    @Override
    public void setCarryData(Player player, CarryOnData data) {
        ICarryOnDataCapability cap = (ICarryOnDataCapability)player.getCapability(CarryOnDataCapabilityProvider.CARRY_ON_DATA_CAPABILITY).orElse((Object)new CarryOnDataCapability());
        cap.setCarryData(data);
        if (!player.level().isClientSide()) {
            this.sendPacketToAllPlayers(Constants.PACKET_ID_SYNC_SCRIPTS, new ClientboundSyncCarryDataPacket(player.getId(), data), (ServerLevel)player.level());
        }
    }
}

