/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;

public class WaypointPacket {
    public static final Identifier CHANNEL = Identifier.fromNamespaceAndPath((String)"journeymap", (String)"waypoint");
    public static final StreamCodec<RegistryFriendlyByteBuf, WaypointPacket> STREAM_CODEC = StreamCodec.ofMember(WaypointPacket::encode, WaypointPacket::new);
    private String action;
    private String waypoint;
    private boolean announce;

    public WaypointPacket() {
    }

    public WaypointPacket(String waypoint, boolean announce, String action) {
        this.action = action;
        this.waypoint = waypoint;
        this.announce = announce;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public WaypointPacket(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.waypoint = buf.readUtf();
                this.action = buf.readUtf();
                this.announce = buf.readBoolean();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for waypoint: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            buf.writeUtf(this.waypoint);
            buf.writeUtf(this.action);
            buf.writeBoolean(this.announce);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message for waypoint: " + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<WaypointPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            JourneymapClient.getInstance().getPacketHandler().onWaypointCreatePacket(((WaypointPacket)ctx.message()).waypoint, ((WaypointPacket)ctx.message()).action, ((WaypointPacket)ctx.message()).announce);
        }
    }
}

