/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.network.model.PlayerLoc;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;

public class ServerPlayerLocationPacket {
    public static final Identifier CHANNEL = Identifier.fromNamespaceAndPath((String)"journeymap", (String)"player_loc");
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerPlayerLocationPacket> STREAM_CODEC = StreamCodec.ofMember(ServerPlayerLocationPacket::encode, ServerPlayerLocationPacket::new);
    private List<PlayerLoc> remotePlayers;

    public ServerPlayerLocationPacket() {
    }

    public ServerPlayerLocationPacket(List<PlayerLoc> remotePlayers) {
        this.remotePlayers = remotePlayers;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public ServerPlayerLocationPacket(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.remotePlayers = buf.readList(PlayerLoc::decode);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for player location request:" + String.valueOf(t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeCollection(this.remotePlayers, (byteBuff, player) -> player.encode((FriendlyByteBuf)byteBuff));
    }

    public static void handle(PacketContext<ServerPlayerLocationPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            for (PlayerLoc player : ((ServerPlayerLocationPacket)ctx.message()).remotePlayers) {
                JourneymapClient.getInstance().getPacketHandler().onPlayerLocationPacket(player);
            }
        }
    }
}

