/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.network.model.ClientState;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;

public class ClientPermissionsPacket
implements ClientState {
    public static final Identifier CHANNEL = Identifier.fromNamespaceAndPath((String)"journeymap", (String)"perm_req");
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientPermissionsPacket> STREAM_CODEC = StreamCodec.ofMember(ClientPermissionsPacket::encode, ClientPermissionsPacket::new);
    private String payload;
    private boolean serverAdmin;
    private boolean hasServerMod = false;

    public ClientPermissionsPacket() {
        this.payload = "";
    }

    public ClientPermissionsPacket(String payload, boolean serverAdmin, boolean hasServerMod) {
        this.payload = payload;
        this.serverAdmin = serverAdmin;
        this.hasServerMod = hasServerMod;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public boolean isServerAdmin() {
        return this.serverAdmin;
    }

    @Override
    public boolean hasServerMod() {
        return this.hasServerMod;
    }

    public ClientPermissionsPacket(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                this.serverAdmin = buf.readBoolean();
                this.payload = buf.readUtf(Short.MAX_VALUE);
                try {
                    this.hasServerMod = buf.readBoolean();
                }
                catch (Exception e) {
                    Journeymap.getLogger().debug("Permission set from external source.");
                    this.hasServerMod = false;
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for client permissions: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.payload != null) {
                buf.writeByte(42);
                buf.writeBoolean(this.serverAdmin);
                buf.writeUtf(this.payload);
                buf.writeBoolean(this.hasServerMod);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for client permissions:" + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<ClientPermissionsPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            Journeymap.getInstance().getPacketHandler().onClientPermsRequest(ctx.sender());
        } else {
            JourneymapClient.getInstance().getPacketHandler().onClientStateUpdate((ClientState)ctx.message());
        }
    }
}

