/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.mixin.client;

import java.util.Comparator;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.contextualbar.LocatorBarRenderer;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocatorBarRenderer.class})
public class LocatorBarRendererMixin {
    @Shadow
    @Final
    private static Identifier LOCATOR_BAR_ARROW_UP;
    @Shadow
    @Final
    private static Identifier LOCATOR_BAR_ARROW_DOWN;

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="RETURN")})
    public void renderWaypointMixin(GuiGraphics graphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        int top = minecraft.getWindow().getGuiScaledHeight() - 24 - 5;
        WaypointStore.getInstance().getAll().stream().sorted(Comparator.comparingDouble(waypoint -> ((ClientWaypointImpl)waypoint).distanceSquared((Entity)minecraft.player)).reversed()).forEach(clientWaypoint -> clientWaypoint.renderToLocatorBar(graphics, top, LOCATOR_BAR_ARROW_DOWN, LOCATOR_BAR_ARROW_UP, minecraft.getCameraEntity().level()));
    }
}

