/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ScrollListLayoutPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.waypointmanager.waypoint.DimensionSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.input.MouseButtonEvent;

public class DimensionPanel<T extends DimensionSlot>
extends ScrollListLayoutPane<T> {
    public DimensionPanel(Minecraft mc, int width, int height, int slotHeight) {
        super(mc, 0, 0, width, height, slotHeight);
        this.hpad = 1;
    }

    @Override
    public void visitSlots(Consumer<AbstractWidget> consumer) {
        this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(consumer));
    }

    @Override
    public void initSlots() {
        this.getRootSlots().forEach(DimensionSlot::init);
    }

    @Override
    public void repositionSlots() {
        this.getRootSlots().forEach(DimensionSlot::repositionElements);
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.isMouseOver(event.x(), event.y())) {
            this.getRootSlots().forEach(slot -> slot.getLayout().visitWidgets(widget -> widget.mouseClicked(event, doubleClick)));
            return super.mouseClicked(event, doubleClick);
        }
        return false;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        DrawUtil.drawRectangle(graphics, this.getX(), this.getY(), 1.0, this.height, 0x404040, this.alpha);
    }

    @Override
    public void renderSelection(GuiGraphics guiGraphics, Slot<T> entry, int innerColor) {
    }

    @Override
    protected void renderBackground(GuiGraphics graphics, PoseStack poseStack, int i, int j, float f) {
    }

    public void setX(int x) {
        super.setX(x);
        this.scrollbarX = this.width + x - 7;
    }
}

