/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.io.ThemeLoader;
import journeymap.client.log.ChatLog;
import journeymap.client.log.JMLogger;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.model.block.BlockMD;
import journeymap.client.model.map.MapType;
import journeymap.client.properties.ClientCategory;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.task.main.SoftResetTask;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.task.multi.RenderSpec;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.buttons.CopyConfigButton;
import journeymap.client.ui.component.buttons.IntSliderButton;
import journeymap.client.ui.component.buttons.ResetButton;
import journeymap.client.ui.component.buttons.TextFieldButton;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.option.ButtonListSlot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.OptionScreen;
import journeymap.client.ui.option.OptionSlotFactory;
import journeymap.client.ui.option.OptionsScrollListPane;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.waypoint.WaypointHandler;
import journeymap.common.Journeymap;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class ClientOptionsManager
extends OptionScreen {
    protected static Set<Category> openCategories = new HashSet<Category>();
    protected final int inGameMinimapId;
    protected Category[] initialCategories;
    protected CheckBox minimapPreviewButton;
    protected CheckBox minimap1PreviewButton;
    protected CheckBox minimap2PreviewButton;
    protected Button renderStatsButton;
    protected Button editGridMinimap1Button;
    protected Button editGridMinimap2Button;
    protected Button editMinimap1LocationsButton;
    protected Button editMinimap2LocationsButton;
    protected Button editGridFullscreenButton;
    protected SlotMetadata renderStatsSlotMetadata;
    protected CategorySlot cartographyCategorySlot;
    protected OptionsScrollListPane<CategorySlot> optionsListPane;
    protected Map<Category, List<SlotMetadata>> toolbars;
    protected Set<Category> changedCategories = new HashSet<Category>();
    protected boolean forceMinimapUpdate;
    protected ButtonList editGridButtons = new ButtonList();
    private MiniMapProperties currentMiniMapProp;
    private MiniMap currentMiniMap;

    public ClientOptionsManager() {
        this(null, false);
    }

    public ClientOptionsManager(Screen returnDisplay, boolean clientOnly) {
        this(returnDisplay, clientOnly, openCategories.toArray(new Category[0]));
    }

    public ClientOptionsManager(Screen returnDisplay, boolean clientOnly, Category ... initialCategories) {
        super(String.format("JourneyMap %s %s", Journeymap.JM_VERSION, Constants.getString("jm.common.options")), returnDisplay, clientOnly);
        this.initialCategories = initialCategories;
        this.inGameMinimapId = JourneymapClient.getInstance().getActiveMinimapId();
    }

    public ClientOptionsManager(String title, Screen returnDisplay, boolean clientOnly) {
        super(title, returnDisplay, clientOnly);
        this.inGameMinimapId = JourneymapClient.getInstance().getActiveMinimapId();
    }

    protected Map<Category, PropertiesBase> getSlots() {
        HashMap slotMap = Maps.newHashMap();
        slotMap.put(ClientCategory.MiniMap1, JourneymapClient.getInstance().getMiniMapProperties1());
        slotMap.put(ClientCategory.MiniMap2, JourneymapClient.getInstance().getMiniMapProperties2());
        slotMap.put(ClientCategory.FullMap, JourneymapClient.getInstance().getFullMapProperties());
        slotMap.put(ClientCategory.WebMap, JourneymapClient.getInstance().getWebMapProperties());
        slotMap.put(ClientCategory.Waypoint, JourneymapClient.getInstance().getWaypointProperties());
        slotMap.put(ClientCategory.Advanced, JourneymapClient.getInstance().getCoreProperties());
        slotMap.put(ClientCategory.AdvancedMapRendering, JourneymapClient.getInstance().getRenderingProperties());
        return slotMap;
    }

    @Override
    public void init() {
        try {
            String tooltip;
            String name;
            super.init();
            this.clientOptions.setEnabled(false);
            if (this.editGridMinimap1Button == null) {
                name = Constants.getString("jm.common.grid_edit");
                tooltip = Constants.getString("jm.common.grid_edit.tooltip");
                this.editGridMinimap1Button = new Button(name);
                this.editGridMinimap1Button.setTooltip(tooltip);
                this.editGridMinimap1Button.setDrawBackground(false);
                this.editGridMinimap2Button = new Button(name);
                this.editGridMinimap2Button.setTooltip(tooltip);
                this.editGridMinimap2Button.setDrawBackground(false);
                this.editGridFullscreenButton = new Button(name);
                this.editGridFullscreenButton.setTooltip(tooltip);
                this.editGridFullscreenButton.setDrawBackground(false);
                this.editGridButtons = new ButtonList(this.editGridMinimap1Button, this.editGridMinimap2Button, this.editGridFullscreenButton);
            }
            if (this.editMinimap1LocationsButton == null) {
                name = Constants.getString("jm.common.minimap_position.button");
                tooltip = Constants.getString("jm.common.minimap_position.button.tooltip");
                this.editMinimap1LocationsButton = new Button(name);
                this.editMinimap1LocationsButton.setTooltip(tooltip);
                this.editMinimap1LocationsButton.setDrawBackground(false);
                this.editMinimap2LocationsButton = new Button(name);
                this.editMinimap2LocationsButton.setTooltip(tooltip);
                this.editMinimap2LocationsButton.setDrawBackground(false);
            }
            if (this.minimapPreviewButton == null) {
                name = Constants.getString("jm.minimap.preview");
                tooltip = Constants.getString("jm.minimap.preview.tooltip", JourneymapClient.getInstance().getKeyEvents().getHandler().kbMinimapPreset.getTranslatedName());
                this.minimapPreviewButton = new CheckBox(name, false);
                this.minimapPreviewButton.setTooltip(tooltip);
                if (Minecraft.getInstance().level == null) {
                    this.minimapPreviewButton.setEnabled(false);
                }
            }
            if (this.minimap1PreviewButton == null) {
                name = String.format("%s %s", Constants.getString("jm.minimap.preview"), "1");
                tooltip = Constants.getString("jm.minimap.preview.tooltip", JourneymapClient.getInstance().getKeyEvents().getHandler().kbMinimapPreset.getTranslatedName());
                this.minimap1PreviewButton = new CheckBox(name, false);
                this.minimap1PreviewButton.setTooltip(tooltip);
                if (Minecraft.getInstance().level == null) {
                    this.minimap1PreviewButton.setEnabled(false);
                }
            }
            if (this.minimap2PreviewButton == null) {
                name = String.format("%s %s", Constants.getString("jm.minimap.preview"), "2");
                tooltip = Constants.getString("jm.minimap.preview.tooltip", JourneymapClient.getInstance().getKeyEvents().getHandler().kbMinimapPreset.getTranslatedName());
                this.minimap2PreviewButton = new CheckBox(name, false);
                this.minimap2PreviewButton.setTooltip(tooltip);
                if (Minecraft.getInstance().level == null) {
                    this.minimap2PreviewButton.setEnabled(false);
                }
            }
            if (this.renderStatsButton == null) {
                this.renderStatsButton = new LabelButton(150, "jm.common.renderstats", 0, 0, 0);
                this.renderStatsButton.setEnabled(false);
            }
            if (this.optionsListPane == null) {
                ArrayList<CategorySlot> categorySlots = new ArrayList<CategorySlot>();
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                this.optionsListPane = new OptionsScrollListPane(this.minecraft, 0, 70, this.width, this.height - 70 - 30, 20);
                this.optionsListPane.setAlignTop(true);
                this.optionsListPane.setSlots(OptionSlotFactory.getOptionSlots(this.getToolbars(), this.getSlots()));
                if (this.initialCategories != null) {
                    for (Category initialCategory : this.initialCategories) {
                        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
                            if (categorySlot.getCategory() != initialCategory) continue;
                            categorySlot.setSelected(true);
                            categorySlots.add(categorySlot);
                        }
                    }
                }
                for (Slot rootSlot : this.optionsListPane.getRootSlots()) {
                    if (!(rootSlot instanceof CategorySlot)) continue;
                    CategorySlot categorySlot = (CategorySlot)rootSlot;
                    Category category = categorySlot.getCategory();
                    if (category == ClientCategory.AdvancedMapRendering && Minecraft.getInstance().level != null) {
                        categorySlot.getAllChildMetadata().add(new SlotMetadata((Button)this.minimapPreviewButton, 6));
                    }
                    if (category == ClientCategory.MiniMap1) {
                        if (Minecraft.getInstance().level != null) {
                            categorySlot.getAllChildMetadata().add(new SlotMetadata((Button)this.minimap1PreviewButton, 6));
                        }
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap1Button, 5));
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editMinimap1LocationsButton, 4));
                        continue;
                    }
                    if (category == ClientCategory.MiniMap2) {
                        if (Minecraft.getInstance().level != null) {
                            categorySlot.getAllChildMetadata().add(new SlotMetadata((Button)this.minimap2PreviewButton, 6));
                        }
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap2Button, 5));
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editMinimap2LocationsButton, 4));
                        continue;
                    }
                    if (category == ClientCategory.FullMap) {
                        categorySlot.getAllChildMetadata().add(new SlotMetadata(this.editGridMinimap2Button, 4));
                        continue;
                    }
                    if (category != ClientCategory.Cartography) continue;
                    this.cartographyCategorySlot = categorySlot;
                    this.renderStatsSlotMetadata = new SlotMetadata(this.renderStatsButton, Constants.getString("jm.common.renderstats.title"), Constants.getString("jm.common.renderstats.tooltip"), 2);
                }
                this.optionsListPane.updateSlots();
                if (!categorySlots.isEmpty()) {
                    this.optionsListPane.scrollTo((Slot)((Object)categorySlots.get(0)));
                }
            } else {
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                Objects.requireNonNull(this);
                this.optionsListPane.updateSize(this.width, this.height - 70 - 30, 0, 70);
                this.optionsListPane.updateSlots();
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.init(): " + String.valueOf(t), t);
        }
    }

    @Override
    protected void layoutButtons(GuiGraphics graphics, PoseStack poseStack) {
        if (this.getRenderables().isEmpty()) {
            this.init();
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float par3) {
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        graphics.fillGradient(0, 36, this.width, 70, -1072689136, -804253680);
        try {
            if (this.forceMinimapUpdate) {
                if (this.minimap1PreviewButton.isActive()) {
                    UIManager.INSTANCE.switchMiniMapPreset(1);
                } else if (this.minimap2PreviewButton.isActive()) {
                    UIManager.INSTANCE.switchMiniMapPreset(2);
                }
            }
            if (this.minecraft.level != null) {
                this.updateRenderStats();
            }
            List lastTooltip = this.optionsListPane.lastTooltip;
            long lastTooltipTime = this.optionsListPane.lastTooltipTime;
            this.optionsListPane.lastTooltip = null;
            this.optionsListPane.render(graphics, mouseX, mouseY, par3);
            super.render(graphics, mouseX, mouseY, par3);
            if (this.previewMiniMap() && !this.clientOnly) {
                UIManager.INSTANCE.getMiniMap().setDrawingInPreviewMode(true);
                UIManager.INSTANCE.getMiniMap().drawMap(graphics, this.minimapPreviewButton.getToggled() == false);
                UIManager.INSTANCE.getMiniMap().updateDisplayVars(true, false);
            } else {
                UIManager.INSTANCE.getMiniMap().setDrawingInPreviewMode(false);
            }
            if (!(this.optionsListPane.lastTooltip == null || this.previewMiniMap() && UIManager.INSTANCE.getMiniMap().withinBounds(mouseX, mouseY) || this.optionsListPane.lastTooltip.equals(lastTooltip))) {
                this.optionsListPane.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.optionsListPane.lastTooltipTime > this.optionsListPane.hoverDelay) {
                    Button button = this.optionsListPane.lastTooltipMetadata.getButton();
                    graphics.setTooltipForNextFrame(this.font, this.optionsListPane.lastTooltip, mouseX, button.getBottomY() + 15);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in OptionsManager.render(): " + String.valueOf(t), t);
        }
    }

    private void updateRenderStats() {
        RenderSpec.getSurfaceSpec();
        RenderSpec.getTopoSpec();
        RenderSpec.getUndergroundSpec();
        for (Slot rootSlot : this.optionsListPane.getRootSlots()) {
            CategorySlot categorySlot;
            if (!(rootSlot instanceof CategorySlot) || (categorySlot = (CategorySlot)rootSlot).getCategory() != ClientCategory.Cartography) continue;
            CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                int renderDistance;
                if (!(slotMetadata.getButton() instanceof IConfigFieldHolder)) continue;
                Object property = ((IConfigFieldHolder)((Object)slotMetadata.getButton())).getConfigField();
                boolean limitButtonRange = false;
                if (property == coreProperties.renderDistanceCaveMax) {
                    limitButtonRange = true;
                    slotMetadata.getButton().resetLabelColors();
                } else if (property == coreProperties.renderDistanceSurfaceMax) {
                    limitButtonRange = true;
                    slotMetadata.getButton().resetLabelColors();
                }
                if (!limitButtonRange) continue;
                IntSliderButton button = (IntSliderButton)slotMetadata.getButton();
                button.maxValue = renderDistance = JourneymapClient.getInstance().getRenderDistance(button.getConfigField().getKey().equals("jm.common.renderdistance_cave_max"));
                if (button.getValue() <= renderDistance) continue;
                button.setValue(renderDistance);
            }
        }
        String messageString = JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get() != false ? MapPlayerTask.getSimpleStats() : Constants.getString("jm.common.enable_mapping_false_text");
        this.renderStatsButton.setMessage((Component)Constants.getStringTextComponent(messageString));
        if (this.cartographyCategorySlot != null) {
            this.renderStatsButton.setWidth(this.cartographyCategorySlot.getCurrentColumnWidth());
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int i, int j, float f) {
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.previewMiniMap() && UIManager.INSTANCE.getMiniMap().withinBounds(event.x(), event.y())) {
            return false;
        }
        try {
            boolean pressed = this.optionsListPane.mouseClicked(event, doubleClick);
            if (pressed) {
                this.checkPressedButton();
            }
            return super.mouseClicked(event, doubleClick);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(t.getMessage(), t);
            return false;
        }
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        this.optionsListPane.mouseReleased(event);
        return super.mouseReleased(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseDX, double mouseDY) {
        if (this.optionsListPane.mouseDragged(event, mouseDX, mouseDY)) {
            this.checkPressedButton();
        }
        return super.mouseDragged(event, mouseDX, mouseDY);
    }

    public boolean mouseScrolled(double x, double y, double f, double scroll) {
        this.optionsListPane.mouseScrolled(x, y, f, scroll);
        return super.mouseScrolled(x, y, f, scroll);
    }

    protected void checkPressedButton() {
        CategorySlot categorySlot;
        SlotMetadata slotMetadata = this.optionsListPane.getLastPressed();
        if (slotMetadata != null) {
            if (slotMetadata.getButton() instanceof ResetButton) {
                this.resetOptions(((ResetButton)slotMetadata.getButton()).category);
            }
            if (slotMetadata.getName().equals(Constants.getString("jm.common.ui_theme"))) {
                ThemeLoader.getCurrentTheme(true);
                if (this.previewMiniMap()) {
                    UIManager.INSTANCE.getMiniMap().updateDisplayVars(true, true);
                }
            }
            if (this.editGridButtons.contains((Object)slotMetadata.getButton())) {
                UIManager.INSTANCE.openGridEditor();
                return;
            }
            if (slotMetadata.getButton() == this.editMinimap1LocationsButton) {
                UIManager.INSTANCE.openMinimapPosition(this, JourneymapClient.getInstance().getMiniMapProperties(1));
                return;
            }
            if (slotMetadata.getButton() == this.editMinimap2LocationsButton) {
                UIManager.INSTANCE.openMinimapPosition(this, JourneymapClient.getInstance().getMiniMapProperties(2));
                return;
            }
            if (slotMetadata.getButton() == this.minimapPreviewButton) {
                this.minimap2PreviewButton.setToggled(false);
                this.minimap1PreviewButton.setToggled(false);
                UIManager.INSTANCE.getMiniMap().resetInitTime();
                this.currentMiniMap = UIManager.INSTANCE.getMiniMap();
                this.currentMiniMapProp = this.currentMiniMap.getCurrentMinimapProperties();
            }
            if (slotMetadata.getButton() == this.minimap1PreviewButton) {
                this.minimap2PreviewButton.setToggled(false);
                this.minimapPreviewButton.setToggled(false);
                UIManager.INSTANCE.switchMiniMapPreset(1);
                UIManager.INSTANCE.getMiniMap().resetInitTime();
                this.currentMiniMap = UIManager.INSTANCE.getMiniMap();
                this.currentMiniMapProp = this.currentMiniMap.getCurrentMinimapProperties();
            }
            if (slotMetadata.getButton() == this.minimap2PreviewButton) {
                this.minimap1PreviewButton.setToggled(false);
                this.minimapPreviewButton.setToggled(false);
                UIManager.INSTANCE.switchMiniMapPreset(2);
                UIManager.INSTANCE.getMiniMap().resetInitTime();
                this.currentMiniMap = UIManager.INSTANCE.getMiniMap();
                this.currentMiniMapProp = this.currentMiniMap.getCurrentMinimapProperties();
            }
        }
        if ((categorySlot = (CategorySlot)this.optionsListPane.getLastPressedParentSlot()) != null) {
            Category category = categorySlot.getCategory();
            this.changedCategories.add(category);
            if (category == ClientCategory.MiniMap1 || category == ClientCategory.MiniMap2) {
                this.refreshMinimapOptions();
                DataCache.INSTANCE.resetRadarCaches();
                UIManager.INSTANCE.getMiniMap().updateDisplayVars(true, true);
            }
            if (category == ClientCategory.Cartography) {
                JourneymapClient.getInstance().getCoreProperties().save();
                RenderSpec.resetRenderSpecs();
            }
        }
    }

    public boolean charTyped(CharacterEvent event) {
        switch (event.codepoint()) {
            case 256: {
                if (this.previewMiniMap()) {
                    this.minimap1PreviewButton.setToggled(false);
                    this.minimap2PreviewButton.setToggled(false);
                    this.minimapPreviewButton.setToggled(false);
                    break;
                }
                this.closeAndReturn();
            }
        }
        boolean optionUpdated = this.optionsListPane.charTyped(event);
        if (optionUpdated && this.previewMiniMap()) {
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true, true);
        }
        return true;
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        switch (event.key()) {
            case 256: {
                if (this.previewMiniMap()) {
                    this.minimap1PreviewButton.setToggled(false);
                    this.minimap2PreviewButton.setToggled(false);
                    this.minimapPreviewButton.setToggled(false);
                    break;
                }
                this.closeAndReturn();
            }
        }
        boolean optionUpdated = this.optionsListPane.keyPressed(event);
        if (optionUpdated && this.previewMiniMap()) {
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true, true);
        }
        return optionUpdated;
    }

    protected void resetOptions(Category category) {
        HashSet<PropertiesBase> updatedProperties = new HashSet<PropertiesBase>();
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                PropertiesBase properties;
                slotMetadata.resetToDefaultValue();
                if ((ClientCategory.MiniMap1.equals(category) || ClientCategory.MiniMap2.equals(category)) && !this.clientOnly) {
                    UIManager.INSTANCE.getMiniMap().resetState();
                }
                if (ClientCategory.FullMap.equals(category) && !this.clientOnly) {
                    Fullscreen.state().setMapType(MapType.Name.day);
                }
                if (!slotMetadata.hasConfigField() || (properties = slotMetadata.getProperties()) == null) continue;
                updatedProperties.add(properties);
            }
        }
        for (PropertiesBase properties : updatedProperties) {
            properties.save();
        }
        if (!this.clientOnly) {
            RenderSpec.resetRenderSpecs();
        }
    }

    protected void updateOnCopy(Category category) {
        HashSet<PropertiesBase> updatedProperties = new HashSet<PropertiesBase>();
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!category.equals(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                if (!slotMetadata.hasConfigField()) continue;
                PropertiesBase properties = slotMetadata.getProperties();
                if (properties != null) {
                    updatedProperties.add(properties);
                }
                slotMetadata.getButton().refresh();
            }
        }
        for (PropertiesBase properties : updatedProperties) {
            properties.save();
        }
        this.optionsListPane.updateSlots();
    }

    public boolean previewMiniMap() {
        return this.minimap1PreviewButton.getToggled() != false || this.minimap2PreviewButton.getToggled() != false || this.minimapPreviewButton.getToggled() != false;
    }

    public void refreshMinimapOptions() {
        HashSet<Category> cats = new HashSet<Category>();
        cats.add(ClientCategory.MiniMap1);
        cats.add(ClientCategory.MiniMap2);
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!cats.contains(categorySlot.getCategory())) continue;
            for (SlotMetadata slotMetadata : categorySlot.getAllChildMetadata()) {
                slotMetadata.getButton().refresh();
            }
        }
    }

    @Override
    public void closeWithKeyBind() {
        TextFieldButton button;
        ButtonListSlot buttonListSlot;
        Object object = this.optionsListPane.getSelected();
        if (object instanceof ButtonListSlot && (object = (buttonListSlot = (ButtonListSlot)object).getLastPressed().getButton()) instanceof TextFieldButton && (button = (TextFieldButton)object).isFocused()) {
            return;
        }
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        JourneymapClient.getInstance().getCoreProperties().optionsManagerViewed.set(Journeymap.JM_VERSION.toString()).save();
        JourneymapClient.getInstance().saveConfigProperties();
        if (this.minecraft.level != null) {
            UIManager.INSTANCE.getMiniMap().setMiniMapProperties(JourneymapClient.getInstance().getMiniMapProperties(this.inGameMinimapId));
            for (Category category : this.changedCategories) {
                if (category == ClientCategory.MiniMap1) {
                    DataCache.INSTANCE.resetRadarCaches();
                    UIManager.INSTANCE.getMiniMap().reset();
                    continue;
                }
                if (category == ClientCategory.MiniMap2) {
                    DataCache.INSTANCE.resetRadarCaches();
                    continue;
                }
                if (category == ClientCategory.FullMap) {
                    DataCache.INSTANCE.resetRadarCaches();
                    ThemeLoader.getCurrentTheme(true);
                    continue;
                }
                if (category == ClientCategory.WebMap) {
                    if (JourneymapClient.getInstance().getWebMap() == null) continue;
                    DataCache.INSTANCE.resetRadarCaches();
                    if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue()) {
                        JourneymapClient.getInstance().startWebMap();
                    } else {
                        JourneymapClient.getInstance().stopWebMap();
                    }
                    ChatLog.announceMod(true);
                    continue;
                }
                if (category == ClientCategory.Waypoint) {
                    WaypointHandler.getInstance().reset();
                    continue;
                }
                if (category == ClientCategory.WaypointBeacon) continue;
                if (category == ClientCategory.Cartography) {
                    ModBlockDelegate.INSTANCE.reset();
                    BlockMD.reset();
                    RenderSpec.resetRenderSpecs();
                    MiniMap.state().requireRefresh();
                    Fullscreen.state().requireRefresh();
                    MapPlayerTask.forceNearbyRemap();
                    continue;
                }
                if (category != ClientCategory.Advanced) continue;
                SoftResetTask.queue();
                try {
                    if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue()) {
                        JourneymapClient.getInstance().startWebMap();
                    } else {
                        JourneymapClient.getInstance().stopWebMap();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ChatLog.announceMod(false);
            }
            UIManager.INSTANCE.getMiniMap().reset();
            UIManager.INSTANCE.getMiniMap().updateDisplayVars(true, true);
        }
        if (returnDisplayStack != null && !returnDisplayStack.isEmpty() && returnDisplayStack.peek() instanceof Fullscreen) {
            ((Fullscreen)((Object)returnDisplayStack.peek())).reset();
        }
        openCategories.clear();
        for (CategorySlot categorySlot : this.optionsListPane.getRootSlots()) {
            if (!categorySlot.isSelected()) continue;
            openCategories.add(categorySlot.getCategory());
        }
        super.closeAndReturn();
    }

    protected Map<Category, List<SlotMetadata>> getToolbars() {
        if (this.toolbars == null) {
            this.toolbars = new HashMap<Category, List<SlotMetadata>>();
            for (Category category : ClientCategory.values) {
                ArrayList<SlotMetadata> toolbarButtons = new ArrayList<SlotMetadata>();
                if (ClientCategory.MiniMap1.equals(category)) {
                    this.addToolbarCopyButton(toolbarButtons, ClientCategory.MiniMap1, ClientCategory.MiniMap2, ClientCategory.FullMap);
                }
                if (ClientCategory.MiniMap2.equals(category)) {
                    this.addToolbarCopyButton(toolbarButtons, ClientCategory.MiniMap2, ClientCategory.MiniMap1, ClientCategory.FullMap);
                }
                if (ClientCategory.FullMap.equals(category)) {
                    this.addToolbarCopyButton(toolbarButtons, ClientCategory.FullMap, ClientCategory.MiniMap1, ClientCategory.MiniMap2);
                }
                toolbarButtons.add(new SlotMetadata((Button)new ResetButton(category), Constants.getString("jm.config.reset"), Constants.getString("jm.config.reset.tooltip"), 0));
                this.toolbars.put(category, toolbarButtons);
            }
        }
        return this.toolbars;
    }

    private void addToolbarCopyButton(List<SlotMetadata> buttons, Category from, Category ... to) {
        CopyConfigButton button = new CopyConfigButton(Constants.getString("jm.common.options.copy_to"), from, to, this::updateOnCopy);
        button.setTooltip("Copy");
        button.setDrawBackground(false);
        buttons.add(new SlotMetadata((Button)button, Constants.getString("jm.common.options.copy_to"), Constants.getString("jm.common.options.copy_to.tooltip"), 1));
    }

    @Override
    public boolean isPauseScreen() {
        return this.minimapPreviewButton.getToggled() == false;
    }

    public static class LabelButton
    extends Button {
        DrawUtil.HAlign hAlign = DrawUtil.HAlign.Left;

        public LabelButton(int width, String key, Object ... labelArgs) {
            super(Constants.getString(key, labelArgs));
            this.setTooltip(Constants.getString(key + ".tooltip"));
            this.setDrawBackground(false);
            this.setDrawFrame(false);
            this.setEnabled(false);
            this.setLabelColors(0xC0C0C0, 0xC0C0C0, 0xC0C0C0);
            this.setWidth(width);
        }

        @Override
        public int getFitWidth(Font fr) {
            return this.width;
        }

        @Override
        public void fitWidth(Font fr) {
        }

        public void setHAlign(DrawUtil.HAlign hAlign) {
            this.hAlign = hAlign;
        }

        @Override
        public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float ticks) {
            DrawUtil.drawLabel(graphics, this.getMessage(), switch (this.hAlign) {
                case DrawUtil.HAlign.Left -> this.getRightX();
                case DrawUtil.HAlign.Right -> this.getX();
                default -> this.getCenterX();
            }, this.getMiddleY(), this.hAlign, DrawUtil.VAlign.Middle, null, 0.0f, this.labelColor, 1.0f, 1.0, this.drawLabelShadow);
        }
    }
}

