/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.Renderer;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.BlockInfoLayer;
import journeymap.client.ui.fullscreen.layer.KeybindingInfoLayer;
import journeymap.client.ui.fullscreen.layer.Layer;
import journeymap.client.ui.fullscreen.layer.ModOverlayLayer;
import journeymap.client.ui.fullscreen.layer.WaypointLayer;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Util;
import net.minecraft.world.level.ChunkPos;

public class LayerDelegate {
    long lastClick = 0L;
    BlockPos lastBlockPos = null;
    private final List<DrawStep> drawSteps = new ArrayList<DrawStep>();
    private final List<Layer> layers = new ArrayList<Layer>();
    long lastHover = 0L;
    private final long hoverDelay = 10L;

    public LayerDelegate(Fullscreen fullscreen) {
        this.layers.add(new WaypointLayer(fullscreen));
        this.layers.add(new ModOverlayLayer(fullscreen));
        this.layers.add(new BlockInfoLayer(fullscreen));
        this.layers.add(new KeybindingInfoLayer(fullscreen));
    }

    public void onMouseMove(Minecraft mc, Renderer renderer, Point2D.Double mousePosition, float fontScale, boolean isScrolling) {
        long now = Util.getMillis();
        if (this.lastBlockPos == null || !isScrolling && now - this.lastHover > 10L) {
            this.lastBlockPos = this.getBlockPos(mc, renderer, mousePosition);
            this.lastHover = now;
        }
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            try {
                this.drawSteps.addAll(layer.onMouseMove(mc, renderer, mousePosition, this.lastBlockPos, fontScale, isScrolling));
            }
            catch (Exception e) {
                Journeymap.getLogger().error(LogFormatter.toString(e));
            }
        }
    }

    public void onMouseClicked(Minecraft mc, Renderer renderer, Point2D.Double mousePosition, int button, float fontScale) {
        this.lastBlockPos = renderer.getFullscreen().getBlockAtMouse();
        long sysTime = Util.getMillis();
        boolean doubleClick = sysTime - this.lastClick < 200L;
        this.lastClick = sysTime;
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            try {
                this.drawSteps.addAll(layer.onMouseClick(mc, renderer, mousePosition, this.lastBlockPos, button, doubleClick, fontScale));
                if (layer.propagateClick()) continue;
                break;
            }
            catch (Exception e) {
                Journeymap.getLogger().error(LogFormatter.toString(e));
            }
        }
    }

    public BlockPos getBlockPos(Minecraft mc, Renderer renderer, Point2D.Double mousePosition) {
        ChunkRenderController crc;
        BlockPos seaLevel = renderer.getBlockAtPixel(mousePosition);
        ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(seaLevel);
        int y = seaLevel.getY();
        RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(seaLevel, renderer.getMapType());
        if (regionData != null && JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get().booleanValue()) {
            y = regionData.getTopY(seaLevel);
            return new BlockPos(seaLevel.getX(), y, seaLevel.getZ());
        }
        if (chunkMD != null && (crc = JourneymapClient.getInstance().getChunkRenderController()) != null) {
            ChunkPos chunkCoord = chunkMD.getCoord();
            RegionCoord rCoord = RegionCoord.fromChunkPos(FileHandler.getJMWorldDir(mc), renderer.getMapType(), chunkCoord.x, chunkCoord.z);
            BaseRenderer chunkRenderer = crc.getRenderer(rCoord, renderer.getMapType(), chunkMD);
            int blockY = chunkRenderer.getBlockHeight(chunkMD, seaLevel);
            return new BlockPos(seaLevel.getX(), blockY, seaLevel.getZ());
        }
        return new BlockPos(seaLevel.getX(), y + 1, seaLevel.getZ());
    }

    public List<DrawStep> getDrawSteps() {
        return this.drawSteps;
    }

    public void update() {
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            this.drawSteps.addAll(layer.update());
        }
    }
}

