/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.import_export;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.log.ChatLog;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.screens.AbstractPopupScreen;
import journeymap.client.ui.component.widgets.ColoredStringWidget;
import journeymap.common.Journeymap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.network.chat.Component;

public abstract class ImportPopup
extends AbstractPopupScreen {
    protected final File jmWorldDir;
    protected final List<CheckBox> checkBoxes = new ArrayList<CheckBox>();
    protected final Map<String, Boolean> importFolderSelections = new HashMap<String, Boolean>();
    protected final File sourceFile;

    protected ImportPopup(File sourceFile) {
        super((Component)Component.translatable((String)"jm.common.importexport_import_dialog"));
        this.jmWorldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
        this.sourceFile = sourceFile;
    }

    public void init() {
        block8: {
            this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)this.getTitle().copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), LayoutSettings::alignHorizontallyCenter);
            this.layout.spacing(6);
            this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)Component.translatable((String)"jm.common.importexport_dialog_import_summary"), this.font), LayoutSettings::alignHorizontallyCenter);
            if (this.sourceFile != null && this.sourceFile.exists()) {
                try {
                    Set<String> folders = this.scanForFolders();
                    this.checkBoxes.clear();
                    if (!folders.isEmpty()) {
                        this.layout.defaultCellSetting().alignHorizontallyCenter();
                        LinearLayout horizontalLayout = LinearLayout.horizontal();
                        horizontalLayout.spacing(10);
                        LinearLayout currentColumn = LinearLayout.vertical();
                        currentColumn.spacing(2);
                        horizontalLayout.addChild((LayoutElement)currentColumn);
                        int checkboxesInCurrentColumn = 0;
                        for (String folder : folders) {
                            if (!folder.equals("waypoints")) continue;
                            CheckBox waypointCheckBox = new CheckBox(folder, true, button -> {
                                boolean toggled = ((CheckBox)button).getToggled();
                                this.importFolderSelections.put(folder, toggled);
                            });
                            this.layout.addChild((LayoutElement)waypointCheckBox);
                            this.layout.addChild((LayoutElement)new SpacerElement(0, 0));
                            this.checkBoxes.add(waypointCheckBox);
                            this.importFolderSelections.put(folder, true);
                            break;
                        }
                        this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)Component.translatable((String)"jm.waypoint.dimensions").copy().withStyle(ChatFormatting.UNDERLINE), this.font), LayoutSettings::alignHorizontallyCenter);
                        for (String folder : folders) {
                            if (folder.equals("waypoints")) continue;
                            if (checkboxesInCurrentColumn >= 7) {
                                checkboxesInCurrentColumn = 0;
                                currentColumn = LinearLayout.vertical();
                                currentColumn.spacing(2);
                                horizontalLayout.addChild((LayoutElement)currentColumn);
                            }
                            CheckBox checkBox = new CheckBox(folder, true, button -> {
                                boolean toggled = ((CheckBox)button).getToggled();
                                this.importFolderSelections.put(folder, toggled);
                            });
                            currentColumn.addChild((LayoutElement)checkBox);
                            this.checkBoxes.add(checkBox);
                            this.importFolderSelections.put(folder, true);
                            ++checkboxesInCurrentColumn;
                        }
                        this.layout.addChild((LayoutElement)horizontalLayout);
                        break block8;
                    }
                    this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)Component.translatable((String)"jm.common.importexport_dialog_no_folders").copy().withStyle(ChatFormatting.RED), this.font));
                }
                catch (Exception e) {
                    this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)Component.literal((String)("Error scanning source: " + e.getMessage())).copy().withStyle(ChatFormatting.RED), this.font));
                    Journeymap.getLogger().error("Error scanning source: " + e.getMessage(), (Throwable)e);
                }
            } else {
                this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)Component.translatable((String)"jm.common.importexport_dialog_no_zip").copy().withStyle(ChatFormatting.RED), this.font));
            }
        }
        LinearLayout buttonLayout = LinearLayout.horizontal();
        buttonLayout.spacing(10);
        buttonLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.importexport_dialog_import_selected"), button -> this.importSelectedFolders()).build());
        buttonLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.cancel"), button -> super.onClose()).build());
        this.layout.addChild((LayoutElement)buttonLayout);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        super.repositionElements();
    }

    protected void importSelectedFolders() {
        if (this.sourceFile == null || !this.sourceFile.exists()) {
            ChatLog.announceError(Component.translatable((String)"jm.common.importexport_dialog_no_zip").getString());
            return;
        }
        TreeSet<String> selectedFolders = new TreeSet<String>();
        for (Map.Entry<String, Boolean> entry : this.importFolderSelections.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            selectedFolders.add(entry.getKey());
        }
        if (selectedFolders.isEmpty()) {
            ChatLog.announceError(Component.translatable((String)"jm.common.importexport_dialog_no_folders").getString());
            return;
        }
        try {
            boolean wasMapping = JourneymapClient.getInstance().isMapping();
            if (wasMapping) {
                JourneymapClient.getInstance().stopMapping();
            }
            DataCache.INSTANCE.invalidateChunkMDCache();
            this.importFolders(selectedFolders);
            if (wasMapping) {
                JourneymapClient.getInstance().startMapping();
                MapPlayerTask.forceNearbyRemap();
            }
            ChatLog.announceI18N("jm.common.importexport_dialog_import_success", this.sourceFile.getName());
            Journeymap.getLogger().info("JourneyMap data imported from " + this.sourceFile.getAbsolutePath());
        }
        catch (IOException e) {
            Journeymap.getLogger().error("Error importing JourneyMap data: " + e.getMessage(), (Throwable)e);
            ChatLog.announceError("Error importing JourneyMap data: " + e.getMessage());
        }
        this.onClose();
    }

    protected abstract Set<String> scanForFolders() throws IOException;

    protected abstract void importFolders(Set<String> var1) throws IOException;
}

