/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import journeymap.api.services.Services;
import journeymap.client.JourneymapClient;
import journeymap.client.log.ChatLog;
import journeymap.client.properties.ClientCategory;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.screens.AbstractPopupScreen;
import journeymap.client.ui.component.widgets.ColoredStringWidget;
import journeymap.client.ui.fullscreen.Fullscreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class AutoMapPopup
extends AbstractPopupScreen {
    public AutoMapPopup() {
        super((Component)Component.translatable((String)"jm.common.automap_dialog"));
    }

    public void init() {
        this.layout.spacing(6);
        this.layout.defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)this.getTitle().copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), LayoutSettings::alignHorizontallyCenter);
        this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)Component.translatable((String)"jm.common.automap_dialog_summary_1"), this.font));
        this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)Component.translatable((String)"jm.common.automap_dialog_summary_2"), this.font));
        this.layout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager((Screen)this, ClientCategory.Cartography)).build());
        if (Services.COMMON_SERVICE.isModLoaded("c2me")) {
            this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)Component.translatable((String)"jm.common.automap_dialog_warning_1", (Object[])new Object[]{"C2ME"}).copy().withStyle(ChatFormatting.DARK_RED), this.font));
            this.layout.addChild((LayoutElement)new ColoredStringWidget((Component)Component.translatable((String)"jm.common.automap_dialog_warning_2", (Object[])new Object[]{"c2me"}).copy().withStyle(ChatFormatting.DARK_RED), this.font));
        }
        this.layout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.webmap.automap_dialog_start"), button -> this.initAutoMapping(true, Boolean.TRUE)).build());
        this.layout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.common.close"), button -> this.onClose()).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        super.repositionElements();
    }

    protected void initAutoMapping(final boolean enable, final Object arg) {
        Boolean value;
        MapRegionTask.MAP_TYPE = Fullscreen.state().getMapType();
        if (arg instanceof Boolean && !(value = (Boolean)arg).booleanValue()) {
            ChatLog.announceI18N("jm.common.automap_missing_start", new Object[0]);
        }
        JourneymapClient.getInstance().queueMainThreadTask(new IMainThreadTask(){

            @Override
            public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
                JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, enable, arg);
                return null;
            }

            @Override
            public String getName() {
                return "Automap";
            }
        });
        this.onClose();
    }
}

