/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.debug;

import java.util.Collections;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.task.multi.MapPlayerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugEntryCategory;
import net.minecraft.client.gui.components.debug.DebugScreenDisplayer;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public class DebugEntry
implements DebugScreenEntry {
    public static final DebugEntryCategory CATEGORY = new DebugEntryCategory((Component)Component.translatable((String)"JourneyMap"), 20.0f);
    private static final String DEBUG_PREFIX = String.valueOf(ChatFormatting.AQUA) + "[JM] " + String.valueOf(ChatFormatting.RESET);
    private static final String DEBUG_SUFFIX = "";
    private final Minecraft mc = Minecraft.getInstance();
    private long statTimerCheck;
    private List<String> statTimerReport = Collections.EMPTY_LIST;

    public void display(DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk levelChunk, @Nullable LevelChunk levelChunk1) {
        if (JourneymapClient.getInstance().enabled()) {
            try {
                if (this.mc.getDebugOverlay().showDebugScreen() && !"off".equalsIgnoreCase(JourneymapClient.getInstance().getCoreProperties().logLevel.get())) {
                    displayer.addLine(" ");
                    if (JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                        for (String line : MapPlayerTask.getDebugStats()) {
                            displayer.addToGroup(Identifier.fromNamespaceAndPath((String)"journeymap", (String)"debug_stats"), DEBUG_PREFIX + line);
                        }
                    } else {
                        displayer.addToGroup(Identifier.fromNamespaceAndPath((String)"journeymap", (String)"debug_stats"), Constants.getString("jm.common.enable_mapping_false_text"));
                    }
                    if (this.mc.getDebugOverlay().showProfilerChart()) {
                        if (System.currentTimeMillis() - this.statTimerCheck > 3000L) {
                            this.statTimerReport = StatTimer.getReportByTotalTime(DEBUG_PREFIX, DEBUG_SUFFIX);
                            this.statTimerCheck = System.currentTimeMillis();
                        }
                        displayer.addLine(" ");
                        displayer.addToGroup(Identifier.fromNamespaceAndPath((String)"journeymap", (String)"stat_timer"), this.statTimerReport);
                        this.statTimerReport.forEach(arg_0 -> ((DebugScreenDisplayer)displayer).addLine(arg_0));
                    }
                }
            }
            catch (Throwable t) {
                JMLogger.throwLogOnce("Unexpected error during onRenderOverlayEarly: " + String.valueOf(t), t);
            }
        }
    }

    public boolean isAllowed(boolean allowed) {
        return true;
    }

    public DebugEntryCategory category() {
        return CATEGORY;
    }
}

