/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.widgets;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.buttons.RadioButton;
import journeymap.client.ui.component.widgets.ColoredStringWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.Component;

public abstract class RadioButtonListWidget<T>
extends LinearLayout {
    protected static final int VERTICAL_PADDING = 3;
    protected static final int HORIZONTAL_PADDING = 6;
    protected final Collection<T> values;
    protected final int MAX_ROWS = 4;
    protected int columnCt = 1;
    protected T enabledValue;
    protected final Map<RadioButton, T> buttonValueMap;
    protected final GridLayout buttonGrid;
    protected final OnChange<T> onChange;

    public RadioButtonListWidget(String titleKey, Collection<T> values, T enabledValue, OnChange<T> onChange) {
        super(0, 0, LinearLayout.Orientation.VERTICAL);
        this.onChange = onChange;
        this.addChild((LayoutElement)new Title(titleKey, Minecraft.getInstance().font, this), LayoutSettings::alignHorizontallyCenter);
        this.spacing(6);
        this.values = values;
        this.enabledValue = enabledValue;
        this.buttonValueMap = new LinkedHashMap<RadioButton, T>();
        this.buttonGrid = new GridLayout();
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
        this.buildButtonGrid();
        super.visitWidgets(consumer);
    }

    protected void buildButtonGrid() {
        this.buttonGrid.rowSpacing(4);
        this.buttonGrid.columnSpacing(3);
        int row = 0;
        int column = 0;
        for (T value : this.values) {
            if (row >= 4) {
                ++column;
                ++this.columnCt;
                row = 0;
            }
            RadioButton button = this.createRadioButton(value);
            this.buttonValueMap.put(button, value);
            this.buttonGrid.addChild((LayoutElement)button, row++, column);
        }
        this.addChild((LayoutElement)this.buttonGrid, LayoutSettings::alignHorizontallyCenter);
    }

    abstract RadioButton createRadioButton(T var1);

    protected void onPress(Button button) {
        RadioButton radio = (RadioButton)button;
        this.buttonValueMap.forEach((b, t) -> b.setState(false));
        radio.setState(true);
        this.onChange.onChange(this.buttonValueMap.get((Object)radio));
    }

    protected void render(GuiGraphics graphics, int mouseX, int mouseY) {
        int startX = this.buttonGrid.getX() - 6;
        int startY = this.buttonGrid.getY() - 3;
        int width = startX + this.buttonGrid.getWidth() + 12;
        int height = startY + this.buttonGrid.getHeight() + 6;
        int color = RGB.DARK_GRAY_RGBA;
        graphics.hLine(startX, width, startY, color);
        graphics.hLine(startX, width, height, color);
        graphics.vLine(startX, startY, height, color);
        graphics.vLine(width, startY, height, color);
    }

    public static interface OnChange<T> {
        public void onChange(T var1);
    }

    private static class Title
    extends ColoredStringWidget {
        private final RadioButtonListWidget parent;

        public Title(String key, Font font, RadioButtonListWidget parent) {
            super((Component)Component.translatable((String)key).withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), font);
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)(key + ".tooltip"))));
            this.parent = parent;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.parent.render(guiGraphics, mouseX, mouseY);
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

