/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.imageselect;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import journeymap.client.ui.component.LayoutSlot;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageSlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;

public class ImageListSlot
extends LayoutSlot<ImageSlot> {
    private final LinearLayout layout = LinearLayout.horizontal();
    private final List<ImageSlot> images = Lists.newArrayList();

    public void addImage(ImageSlot image) {
        this.images.add(image);
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void updateColor(int color) {
        this.images.forEach(slot -> slot.setColor(color));
    }

    @Override
    public void init() {
        this.layout.spacing(8);
        this.images.forEach(arg_0 -> ((LinearLayout)this.layout).addChild(arg_0));
        this.repositionElements();
    }

    @Override
    public void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    @Override
    public Collection<SlotMetadata<ImageSlot>> getMetadata() {
        return null;
    }

    @Override
    public List<? extends Slot<ImageSlot>> getChildSlots(int listWidth, int columnWidth) {
        return List.of();
    }

    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        for (ImageSlot image : this.images) {
            if (!image.isMouseOver(mouseX, mouseY)) continue;
            return Optional.of(image);
        }
        return super.getChildAt(mouseX, mouseY);
    }

    @Override
    public SlotMetadata<ImageSlot> getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean contains(SlotMetadata<ImageSlot> slotMetadata) {
        return false;
    }

    public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        this.layout.setX(this.getContentX());
        this.layout.setY(this.getContentY());
        this.layout.visitWidgets(widget -> widget.render(graphics, mouseX, mouseY, partialTicks));
    }
}

