/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.dropdown;

import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;

public class ImageDropDownItem
extends DropDownItem {
    private final int textureWidth;
    private final int textureHeight;
    private Identifier texture;
    private int color = -1;

    public ImageDropDownItem(SelectableParent parent, Identifier texture, int textureWidth, int textureHeight, Button.OnPress onPress, String ... toolTip) {
        super(parent, (Object)texture, true, "", onPress);
        this.setTooltip(toolTip);
        this.textureHeight = textureHeight;
        this.textureWidth = textureWidth;
        this.texture = texture;
        this.setWidth(textureWidth);
        this.setHeight(textureHeight);
    }

    @Override
    public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderImage(graphics, this.getX() + (this.width >> 1) - (this.textureWidth >> 1), this.getY());
    }

    public void renderImage(GuiGraphics graphics, int x, int y) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, x, y, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight, RGB.toArgb(this.color, 1.0f));
    }

    public void setColor(int color) {
        this.color = color;
    }
}

