/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import java.util.function.Consumer;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.buttons.Button;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class TextBoxButton
extends Button {
    protected TextBox textBox;
    protected Object text;
    private boolean isNumeric;
    private boolean negative;

    public TextBoxButton(String text) {
        super(text);
    }

    public TextBoxButton(Object text, Font fontRenderer, int width, int height) {
        this(text, fontRenderer, width, height, false, false);
    }

    public TextBoxButton(Object text, Font fontRenderer, int width, int height, boolean isNumeric, boolean negative) {
        super(width, height, text.toString());
        this.text = text;
        this.fontRenderer = fontRenderer;
        this.width = width;
        this.height = height;
        this.isNumeric = isNumeric;
        this.negative = negative;
    }

    protected TextBox getTextBox() {
        if (this.textBox == null) {
            this.textBox = new TextBox(this.text == null ? this.label : this.text, this.fontRenderer, this.width, this.height - 4, this.isNumeric, this.negative);
            this.textBox.setMinLength(1);
        }
        return this.textBox;
    }

    public String getText() {
        return this.getTextBox().getValue();
    }

    public String getSelectedText() {
        return this.getTextBox().getHighlighted();
    }

    public void setResponder(Consumer<String> responder) {
        this.getTextBox().setResponder(responder);
    }

    public void setMinLength(int minLength) {
        this.getTextBox().setMinLength(minLength);
    }

    @Override
    public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.getTextBox().setX(this.getX());
        this.getTextBox().setY(this.getY());
        this.getTextBox().render(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        this.getTextBox().mouseReleased(event);
        return super.mouseReleased(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseDX, double mouseDY) {
        this.getTextBox().mouseDragged(event, mouseDX, mouseDY);
        return super.mouseDragged(event, mouseDX, mouseDY);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        return this.getTextBox().mouseClicked(event, doubleClick);
    }

    public boolean charTyped(CharacterEvent event) {
        return this.getTextBox().charTyped(event);
    }

    public boolean keyPressed(KeyEvent event) {
        return this.getTextBox().keyPressed(event);
    }

    public boolean isFocused() {
        return this.getTextBox().isFocused();
    }

    @Override
    public boolean isActive() {
        return this.getTextBox().isActive();
    }

    public void setFocused(boolean focused) {
        this.getTextBox().setFocused(focused);
    }

    public boolean isHoveredOrFocused() {
        if (this.textBox != null) {
            return this.getTextBox().isHovered() || this.getTextBox().isFocused();
        }
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        this.getTextBox().setVisible(visible);
        super.setVisible(visible);
    }

    @Override
    public int getCenterX() {
        return this.getTextBox().getCenterX();
    }

    @Override
    public int getRightX() {
        return this.getTextBox().getRightX();
    }

    @Override
    public int getBottomY() {
        return this.getTextBox().getBottomY();
    }

    @Override
    public int getMiddleY() {
        return this.getTextBox().getMiddleY();
    }

    public int getWidth() {
        if (this.textBox != null) {
            return this.getTextBox().getWidth();
        }
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        if (this.textBox != null) {
            this.getTextBox().setWidth(width);
        }
        this.width = width;
    }

    public int getHeight() {
        if (this.textBox != null) {
            return this.getTextBox().getHeight();
        }
        return this.height;
    }

    public void setText(String text) {
        this.getTextBox().setValue(text);
    }
}

