/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import java.util.Objects;
import journeymap.client.cartography.color.RGB;
import journeymap.client.ui.component.buttons.BooleanPropertyButton;
import journeymap.client.ui.component.buttons.Button;
import journeymap.common.properties.config.BooleanField;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.renderer.RenderPipelines;

public class CheckBox
extends BooleanPropertyButton {
    public int boxWidth = 11;
    String glyph = "\u2714";
    boolean drawText = true;

    public CheckBox(String label, boolean checked, Button.OnPress pressable) {
        this(label, null, pressable);
        this.toggled = checked;
    }

    public CheckBox(String label, BooleanField field, Button.OnPress pressable) {
        super(label, label, field, pressable);
        Objects.requireNonNull(this.fontRenderer);
        this.setHeight(9 + 2);
        this.setWidth(this.getFitWidth(this.fontRenderer));
    }

    public CheckBox(String label, boolean checked) {
        this(label, checked, CheckBox.emptyPressable());
    }

    public CheckBox(String label, BooleanField field) {
        this(label, field, CheckBox.emptyPressable());
    }

    @Override
    public int getFitWidth(Font fr) {
        return super.getFitWidth(fr) + this.boxWidth + (this.drawText ? 2 : 0);
    }

    @Override
    public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float ticks) {
        if (this.booleanField != null && this.booleanField.hasEnabledAttribute()) {
            this.setEnabled(this.booleanField.isEnabled());
        }
        if (this.visible) {
            this.setHovered(this.isEnabled() && mouseX >= super.getX() && mouseY >= super.getY() && mouseX < super.getX() + this.width && mouseY < super.getY() + this.height);
            int yoffset = (this.height - this.boxWidth) / 2;
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, Button.SPRITES.disabled(), super.getX(), super.getY() + yoffset, this.boxWidth, this.boxWidth);
            this.mouseDragged(new MouseButtonEvent((double)mouseX, (double)mouseY, new MouseButtonInfo(0, 0)), super.getX(), super.getY());
            int color = this.isHoveredOrFocused() ? this.hoverLabelColor : (!this.isEnabled() ? RGB.DARK_GRAY_RGBA : (this.getActiveColor() != 0 ? this.getActiveColor() : this.labelColor.intValue()));
            int labelPad = 4;
            if (this.toggled.booleanValue()) {
                graphics.drawCenteredString(this.fontRenderer, this.glyph, super.getX() + this.boxWidth / 2 + 1, super.getY() + 1 + yoffset, color);
            }
            if (this.drawText) {
                graphics.drawString(this.fontRenderer, this.getMessage(), super.getX() + this.boxWidth + labelPad, super.getY() + 2 + yoffset, color);
            }
        }
    }

    public boolean isDrawText() {
        return this.drawText;
    }

    public void setDrawText(boolean drawText) {
        this.drawText = drawText;
        if (!drawText) {
            this.width = this.boxWidth;
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        double mouseX = event.x();
        double mouseY = event.y();
        if (this.isEnabled() && this.visible && mouseX >= (double)super.getX() && mouseY >= (double)super.getY() && mouseX < (double)(super.getX() + this.width) && mouseY < (double)(super.getY() + this.height)) {
            this.toggle();
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.isEnabled() && this.visible && event.isSelection()) {
            this.toggle();
            return true;
        }
        return false;
    }
}

