/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import journeymap.client.Constants;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColorPalette;
import journeymap.client.ui.colorpalette.ColorPaletteScreen;
import journeymap.client.ui.colorpalette.CopyPalettePopup;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.simple.ConfirmationPopup;
import journeymap.client.ui.component.screens.JmUI;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;

public class ColorPaletteManagerScreen
extends JmUI {
    private static final Identifier BACKGROUND_SPRITE = Identifier.parse((String)"popup/background");
    private final Component labelBlocks = Component.translatable((String)"jm.colorpalette.total_blocks");
    private final Component labelStates = Component.translatable((String)"jm.colorpalette.total_states");
    private final Component labelBiomes = Component.translatable((String)"jm.colorpalette.total_biomes");
    private final Component labelClose = Component.translatable((String)"jm.common.close");
    ColorPaletteScreen colorPaletteScreen;
    Palette globalPalette;
    Palette worldPalette;

    public ColorPaletteManagerScreen(ColorPaletteScreen returnDisplay) {
        super(Constants.getString("jm.colorpalette.manage_palettes_title"), true, returnDisplay);
        this.colorPaletteScreen = returnDisplay;
    }

    @Override
    public void init() {
        super.init();
        LinearLayout linearLayout = LinearLayout.vertical();
        linearLayout.spacing(6).defaultCellSetting().alignHorizontallyCenter();
        ColorPalette defaultPalette = ColorManager.INSTANCE.getDefaultPalette();
        linearLayout.addChild((LayoutElement)new StringWidget((Component)this.labelBlocks.copy().append(String.valueOf(defaultPalette.blockCount())), this.font));
        linearLayout.addChild((LayoutElement)new StringWidget((Component)this.labelStates.copy().append(String.valueOf(defaultPalette.stateCount())), this.font));
        linearLayout.addChild((LayoutElement)new StringWidget((Component)this.labelBiomes.copy().append(String.valueOf(defaultPalette.biomeCount())), this.font));
        linearLayout.addChild((LayoutElement)new SpacerElement(0, 10));
        LinearLayout paletteLayout = LinearLayout.horizontal();
        paletteLayout.spacing(46).defaultCellSetting().alignVerticallyTop();
        this.globalPalette = (Palette)paletteLayout.addChild((LayoutElement)new Palette(ColorManager.INSTANCE.getGlobalPalette(), this.font, this));
        this.worldPalette = (Palette)paletteLayout.addChild((LayoutElement)new Palette(ColorManager.INSTANCE.getWorldPalette(), this.font, this));
        linearLayout.addChild((LayoutElement)paletteLayout);
        linearLayout.addChild((LayoutElement)new SpacerElement(0, 8));
        this.contentLayout.addChild((LayoutElement)linearLayout);
        this.footerLayout.addChild((LayoutElement)Button.builder((Component)this.labelClose, b -> this.closeAndReturn()).width(this.font.width((FormattedText)this.labelClose) + 10).build());
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(graphics);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, this.globalPalette.getX() - 16, this.globalPalette.getY() - 16, this.globalPalette.getWidth() + 32, this.globalPalette.getHeight() + 32);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, this.worldPalette.getX() - 16, this.worldPalette.getY() - 16, this.worldPalette.getWidth() + 32, this.worldPalette.getHeight() + 32);
    }

    private void deleteAll(ColorPalette.Type type) {
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        palette.clear();
        this.colorPaletteScreen.setRemapNeeded();
        this.rebuildWidgets();
    }

    private void fillWithDefault(ColorPalette.Type type) {
        ColorPalette palette = type == ColorPalette.Type.Global ? ColorManager.INSTANCE.getGlobalPalette() : ColorManager.INSTANCE.getWorldPalette();
        palette.copyNonExistingFromPalette(ColorManager.INSTANCE.getDefaultPalette());
        this.rebuildWidgets();
    }

    private void copyPalette(CopyPalettePopup.Mode mode, boolean globalToWorld) {
        ColorPalette global = ColorManager.INSTANCE.getGlobalPalette();
        ColorPalette world = ColorManager.INSTANCE.getWorldPalette();
        if (world == null) {
            return;
        }
        switch (mode) {
            case CopyAllAndReplace: {
                if (globalToWorld) {
                    world.copyAllFromPalette(global);
                    break;
                }
                global.copyAllFromPalette(world);
                break;
            }
            case CopyExistingAndReplace: {
                if (globalToWorld) {
                    world.copyExistingFromPalette(global);
                    break;
                }
                global.copyExistingFromPalette(world);
                break;
            }
            default: {
                if (globalToWorld) {
                    world.copyNonExistingFromPalette(global);
                    break;
                }
                global.copyNonExistingFromPalette(world);
            }
        }
        this.colorPaletteScreen.setRemapNeeded();
        this.rebuildWidgets();
    }

    static class Palette
    extends LinearLayout {
        private final Component labelGlobal = Component.translatable((String)"jm.colorpalette.global").withStyle(ChatFormatting.BOLD);
        private final Component labelWorld = Component.translatable((String)"jm.colorpalette.world").withStyle(ChatFormatting.BOLD);
        private final Component labelBlocks = Component.translatable((String)"jm.colorpalette.blocks");
        private final Component labelStates = Component.translatable((String)"jm.colorpalette.states");
        private final Component labelBiomes = Component.translatable((String)"jm.colorpalette.biomes");
        private final String deleteLabel = Constants.getString("jm.colorpalette.delete_all");
        private final String labelCopyToRight = "  " + Constants.getString("jm.colorpalette.copy") + " >";
        private final String labelCopyToLeft = "< " + Constants.getString("jm.colorpalette.copy") + "  ";
        private final String fillDefaultLabel = Constants.getString("jm.colorpalette.fill_default");
        private final ColorPalette colorPalette;
        private final ColorPaletteManagerScreen screen;

        public Palette(ColorPalette colorPalette, Font font, ColorPaletteManagerScreen screen) {
            super(0, 0, LinearLayout.Orientation.VERTICAL);
            this.colorPalette = colorPalette;
            this.screen = screen;
            super.spacing(10).defaultCellSetting().alignHorizontallyCenter();
            super.addChild((LayoutElement)new StringWidget(colorPalette.getType() == ColorPalette.Type.Global ? this.labelGlobal : this.labelWorld, font));
            LinearLayout columns = LinearLayout.horizontal();
            columns.spacing(10).defaultCellSetting().alignVerticallyMiddle();
            super.addChild((LayoutElement)columns);
            LinearLayout dataColumn = LinearLayout.vertical();
            dataColumn.spacing(4).defaultCellSetting().alignHorizontallyLeft();
            LinearLayout buttonColumn = LinearLayout.vertical().spacing(4);
            if (colorPalette.getType().equals((Object)ColorPalette.Type.Global)) {
                columns.addChild((LayoutElement)dataColumn);
                columns.addChild((LayoutElement)buttonColumn);
            } else {
                columns.addChild((LayoutElement)buttonColumn);
                columns.addChild((LayoutElement)dataColumn);
            }
            dataColumn.addChild((LayoutElement)new StringWidget((Component)this.labelBlocks.copy().append(String.valueOf(colorPalette.blockCount())), font));
            dataColumn.addChild((LayoutElement)new StringWidget((Component)this.labelStates.copy().append(String.valueOf(colorPalette.stateCount())), font));
            dataColumn.addChild((LayoutElement)new StringWidget((Component)this.labelBiomes.copy().append(String.valueOf(colorPalette.biomeCount())), font));
            String labelCopy = colorPalette.getType() == ColorPalette.Type.Global ? this.labelCopyToRight : this.labelCopyToLeft;
            int buttonWidth = Math.max(font.width(labelCopy), font.width(this.deleteLabel)) + 10;
            PopupButton copyButton = (PopupButton)buttonColumn.addChild(new PopupButton<CopyPalettePopup.Mode>(buttonWidth, 0, (Component)Component.literal((String)labelCopy), CopyPalettePopup::new, this::copyPalette));
            PopupButton deleteButton = (PopupButton)buttonColumn.addChild(new PopupButton<Boolean>(buttonWidth, 0, (Component)Component.literal((String)this.deleteLabel), () -> new ConfirmationPopup("jm.colorpalette.delete_all_dialog", "jm.colorpalette.delete_all", "jm.colorpalette.cancel"), this::deletePalette));
            if (!colorPalette.hasBlockStateColors() && !colorPalette.hasBiomeColors()) {
                copyButton.active = false;
                deleteButton.active = false;
            }
            super.addChild(new PopupButton<Boolean>(font.width(this.fillDefaultLabel) + 10, 0, (Component)Component.literal((String)this.fillDefaultLabel), () -> new ConfirmationPopup("jm.colorpalette.fill_default_dialog", "jm.colorpalette.fill_default", "jm.colorpalette.cancel"), this::fillFromDefaultPalette));
        }

        public void copyPalette(CopyPalettePopup.Mode mode) {
            if (mode != null) {
                this.screen.copyPalette(mode, this.colorPalette.getType() == ColorPalette.Type.Global);
            }
        }

        public void deletePalette(boolean delete) {
            if (delete) {
                this.screen.deleteAll(this.colorPalette.getType());
            }
        }

        public void fillFromDefaultPalette(boolean fill) {
            if (fill) {
                this.screen.fillWithDefault(this.colorPalette.getType());
            }
        }
    }
}

