/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.pip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import journeymap.api.v2.client.display.Context;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.pip.AbstractMapPipRenderState;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeMinimapFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.resources.Identifier;
import org.joml.Quaternionfc;

public abstract class AbstractMapPipRenderer<T extends AbstractMapPipRenderState>
extends PictureInPictureRenderer<T> {
    protected AbstractMapPipRenderer(MultiBufferSource.BufferSource buffers) {
        super(buffers);
    }

    public final void renderToTexture(T state, PoseStack poseStack) {
        DisplayVars dv;
        this.preTranslate(state, poseStack);
        poseStack.scale(1.0f / (float)JmUI.calculateScaleFactor(), 1.0f / (float)JmUI.calculateScaleFactor(), 1.0f);
        if (Context.UI.Minimap == ((AbstractMapPipRenderState)state).getContext()) {
            dv = UIManager.INSTANCE.getMiniMap().getDisplayVars();
            this.beginMask(dv, poseStack, this.bufferSource);
            this.startMapRotation(poseStack, dv, ((AbstractMapPipRenderState)state).getRotation());
            poseStack.translate(dv.getTranslateX(), dv.getTranslateY(), 0.0f);
        }
        this.render(state, poseStack);
        if (Context.UI.Minimap == ((AbstractMapPipRenderState)state).getContext()) {
            dv = UIManager.INSTANCE.getMiniMap().getDisplayVars();
            this.endMask(state, dv);
            poseStack.translate(dv.getTranslateX(), -dv.getTranslateY(), 0.0f);
            this.stopMapRotation(poseStack);
        }
    }

    protected void preTranslate(T state, PoseStack poseStack) {
        poseStack.translate(-((float)(((AbstractMapPipRenderState)state).x1() - ((AbstractMapPipRenderState)state).x0()) / 2.0f), 0.0f, 0.0f);
    }

    protected abstract void render(T var1, PoseStack var2);

    private void startMapRotation(PoseStack poseStack, DisplayVars dv, double rotation) {
        poseStack.pushPose();
        if (rotation % 360.0 != 0.0) {
            float width = (float)(dv.getDisplayWidth() >> 1) + dv.getTranslateX();
            float height = (float)(dv.getDisplayHeight() >> 1) + dv.getTranslateY();
            poseStack.translate(width, height, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)rotation));
            poseStack.translate(-width, -height, 0.0f);
        }
    }

    private void stopMapRotation(PoseStack poseStack) {
        poseStack.popPose();
    }

    private void beginMask(DisplayVars dv, PoseStack poseStack, MultiBufferSource.BufferSource buffers) {
        VertexConsumer regionTileBuffer;
        ThemeMinimapFrame frame = dv.getMinimapFrame();
        if (dv.getMinimapSpec() instanceof Theme.Minimap.MinimapCircle) {
            Identifier identifier = dv.getMinimapFrame().getTextureCircleMask();
            RenderType renderType = JMRenderTypes.getCircleMask(identifier);
            regionTileBuffer = buffers.getBuffer(renderType);
        } else {
            regionTileBuffer = buffers.getBuffer(JMRenderTypes.MINIMAP_RECTANGLE_MASK_RENDER_TYPE);
        }
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(RenderSystem.outputDepthTextureOverride.texture(), 0.0);
        DrawUtil.drawQuad(poseStack, regionTileBuffer, 0xFFFFFF, 1.0f, frame.getX(), frame.getY(), (double)dv.getMinimapWidth(), (double)dv.getMinimapHeight(), 0.0, false);
    }

    private void endMask(T state, DisplayVars dv) {
        this.bufferSource.endBatch();
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(Minecraft.getInstance().getMainRenderTarget().getDepthTexture(), 1.0);
    }
}

