/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.ingame.WaypointRenderer;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class WaypointBeaconRenderer
extends WaypointRenderer {
    @Override
    public void render(GuiGraphics graphics, PoseStack poseStack) {
        this.waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
        String playerDim = this.minecraft.player.level().dimension().identifier().toString();
        MultiBufferSource.BufferSource buffers = this.minecraft.renderBuffers().bufferSource();
        try {
            ArrayList<ClientWaypointImpl> waypoints = new ArrayList<ClientWaypointImpl>(WaypointStore.getInstance().getAll());
            this.deleteQueue = new ArrayList();
            for (ClientWaypointImpl waypoint : waypoints) {
                if (!this.canDrawWaypoint(waypoint, playerDim) || this.waypointProperties.shaderBeacon.get().booleanValue() && !this.waypointProperties.showRotatingBeam.get().booleanValue() && !this.waypointProperties.showStaticBeam.get().booleanValue()) continue;
                try {
                    this.renderWaypoint(graphics, waypoint, poseStack, DrawStep.Pass.PreObject, (MultiBufferSource)buffers);
                }
                catch (Exception t) {
                    Journeymap.getLogger().error("Waypoint beacon failed to render for " + waypoint.getName() + ": ", (Throwable)t);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error rendering all waypoints. Thread:" + Thread.currentThread().getName(), t);
        }
        this.deleteQueue.forEach(wp -> WaypointStore.getInstance().remove((ClientWaypointImpl)wp, true));
        this.deleteQueue.clear();
        buffers.endBatch();
    }

    @Override
    protected void render(GuiGraphics graphics, PoseStack poseStack, DrawStep.Pass pass, MultiBufferSource buffers, ClientWaypointImpl waypoint, float partialTicks, long gameTime, float[] rgba, float fadeAlpha, double shiftX, double shiftY, double shiftZ, Vec3 playerVec, Vec3 waypointVec, double viewDistance, double actualDistance, double scale) {
        boolean showStaticInnerBeam = this.waypointProperties.showStaticBeam.get();
        boolean showRotatingOuterBeam = this.waypointProperties.showRotatingBeam.get();
        if (!showStaticInnerBeam && !showRotatingOuterBeam) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(shiftX, -180.0, shiftZ);
        this.renderBeamSegment(poseStack, buffers, partialTicks, gameTime, 1, 360, rgba, 0.2f, 0.25f, showStaticInnerBeam, showRotatingOuterBeam);
        poseStack.popPose();
    }

    public void renderBeamSegment(PoseStack poseStack, MultiBufferSource buffer, float partialTicks, long gameTime, int yOffset, int height, float[] colors, float beamRadius, float glowRadius, boolean showStaticInnerBeam, boolean showRotatingOuterBeam) {
        float texScale = 1.0f;
        int heightOffset = yOffset + height;
        float rotation = (float)Math.floorMod(gameTime, 40L) + partialTicks;
        float texOffset = -((float)(-gameTime) * 0.2f - (float)Mth.floor((float)((float)(-gameTime) * 0.1f))) * 0.6f;
        float red = colors[0];
        float blue = colors[1];
        float green = colors[2];
        float alpha = colors[3];
        VertexConsumer beamBuffer = buffer.getBuffer(RenderTypes.beaconBeam((Identifier)JMRenderTypes.WAYPOINT_DEFAULT_BEAM, (boolean)true));
        poseStack.pushPose();
        if (!showStaticInnerBeam) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation * 2.25f - 45.0f));
        }
        float V2 = -1.0f + texOffset;
        float innerV1 = (float)height * texScale * (0.5f / beamRadius) + V2;
        WaypointBeaconRenderer.renderPart(poseStack, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, 0.0f, 1.0f, innerV1, V2);
        poseStack.popPose();
        float outerV1 = (float)height * texScale + V2;
        poseStack.pushPose();
        if (showRotatingOuterBeam) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation * 2.25f - 45.0f));
        }
        WaypointBeaconRenderer.renderPart(poseStack, beamBuffer, red, blue, green, alpha, yOffset, heightOffset, -glowRadius, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, outerV1, V2);
        poseStack.popPose();
    }

    private static void renderPart(PoseStack poseStack, VertexConsumer buffer, float red, float green, float blue, float alpha, int yMin, int yMax, float p1, float p2, float p3, float p4, float p5, float p6, float p7, float p8, float u1, float u2, float v1, float v2) {
        WaypointBeaconRenderer.addQuad(poseStack, buffer, red, green, blue, alpha, yMin, yMax, p1, p2, p3, p4, u1, u2, v1, v2);
        WaypointBeaconRenderer.addQuad(poseStack, buffer, red, green, blue, alpha, yMin, yMax, p7, p8, p5, p6, u1, u2, v1, v2);
        WaypointBeaconRenderer.addQuad(poseStack, buffer, red, green, blue, alpha, yMin, yMax, p3, p4, p7, p8, u1, u2, v1, v2);
        WaypointBeaconRenderer.addQuad(poseStack, buffer, red, green, blue, alpha, yMin, yMax, p5, p6, p1, p2, u1, u2, v1, v2);
    }

    private static void addQuad(PoseStack poseStack, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int yMin, int yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        DrawUtil.addVertexUV(poseStack, bufferIn, red, green, blue, alpha, yMax, x1, z1, u2, v1);
        DrawUtil.addVertexUV(poseStack, bufferIn, red, green, blue, alpha, yMin, x1, z1, u2, v2);
        DrawUtil.addVertexUV(poseStack, bufferIn, red, green, blue, alpha, yMin, x2, z2, u1, v2);
        DrawUtil.addVertexUV(poseStack, bufferIn, red, green, blue, alpha, yMax, x2, z2, u1, v1);
    }
}

