/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Objects;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.Pipelines;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.theme.Theme;
import journeymap.common.Journeymap;
import journeymap.common.mixin.client.GuiGraphicsAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class DrawUtil {
    public static double zLevel = 0.0;

    public static void drawCenteredLabel(GuiGraphics graphics, Component text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(graphics, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawLabel(GuiGraphics graphics, Component text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawLabels(GuiGraphics graphics, String[] lines, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        if (lines.length == 0) {
            return;
        }
        if (lines.length == 1) {
            if (bgColor != null && bgAlpha > 0.0f) {
                DrawUtil.drawLabel(graphics, (Component)Component.literal((String)lines[0]), x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            }
            DrawUtil.drawLabel(graphics, (Component)Component.literal((String)lines[0]), x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, rotation);
            return;
        }
        Font fontRenderer = Minecraft.getInstance().font;
        double vpad = fontRenderer.isBidirectional() ? 0.0 : (fontShadow ? 6.0 : 4.0);
        double hpad = 4.0;
        Objects.requireNonNull(fontRenderer);
        double lineHeight = 9.0 * fontScale;
        double bgHeight = lineHeight * (double)lines.length + vpad;
        double bgWidth = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            for (String line : lines) {
                bgWidth = Math.max(bgWidth, (double)fontRenderer.width(line) * fontScale);
            }
            if (bgWidth % 2.0 == 0.0) {
                bgWidth += 1.0;
            }
        }
        bgWidth += 4.0;
        double rectX = x;
        double rectY = y;
        switch (hAlign.ordinal()) {
            case 0: {
                rectX = x - bgWidth + 2.0;
                break;
            }
            case 1: {
                rectX = (float)(x - (Math.max(1.0, bgWidth) / 2.0 + fontScale) + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case 2: {
                rectX = x - 2.0 - 0.5;
            }
        }
        switch (vAlign.ordinal()) {
            case 0: {
                rectY = (y -= lineHeight * (double)lines.length) - bgHeight / 2.0 - vpad / 2.0;
                break;
            }
            case 1: {
                rectY = (y -= bgHeight / 2.0) - vpad / 2.0 - 5.0 * fontScale;
                break;
            }
            case 2: {
                rectY = y;
            }
        }
        if (bgColor != null && bgAlpha > 0.0f) {
            DrawUtil.drawRectangle(graphics, rectX, rectY, bgWidth + 4.0, bgHeight + vpad, bgColor, bgAlpha);
        }
        for (String line : lines) {
            DrawUtil.drawLabel(graphics, (Component)Component.literal((String)line), x, y, hAlign, vAlign, null, 0.0f, color, alpha, fontScale, fontShadow, rotation);
            y += lineHeight;
        }
    }

    public static void drawLabel(GuiGraphics graphics, Component text, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, RGB.toArgb(labelSpec.background.getColor(), labelSpec.background.alpha), labelSpec.background.alpha, RGB.toArgb(labelSpec.foreground.getColor(), labelSpec.foreground.alpha), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawLabel(GuiGraphics graphics, Component text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            Font fontRenderer = Minecraft.getInstance().font;
            bgWidth = fontRenderer.width((FormattedText)text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLabel(GuiGraphics graphics, Component text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        int height;
        if (text == null || text.getString().isEmpty()) {
            return;
        }
        Font fontRenderer = Minecraft.getInstance().font;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.width((FormattedText)text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.isBidirectional()) {
            --height;
        }
        graphics.pose().pushMatrix();
        try {
            double d;
            if (fontScale != 1.0) {
                x /= fontScale;
                y /= fontScale;
                graphics.pose().scale((float)fontScale, (float)fontScale);
            }
            float textX = (float)x;
            float textY = (float)y;
            double rectX = x;
            double rectY = y;
            switch (hAlign.ordinal()) {
                case 0: {
                    textX = (float)(x - width);
                    rectX = textX;
                    break;
                }
                case 1: {
                    textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    break;
                }
                case 2: {
                    textX = (float)x;
                    rectX = (float)x;
                }
            }
            if (drawRect) {
                Objects.requireNonNull(fontRenderer);
                d = (double)(height - 9) / 2.0;
            } else {
                d = 0.0;
            }
            double vpad = d;
            switch (vAlign.ordinal()) {
                case 0: {
                    rectY = y - (double)height;
                    textY = (float)(rectY + vpad + (double)(!fontRenderer.isBidirectional() ? 1 : 0));
                    break;
                }
                case 1: {
                    rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                    textY = (float)(rectY + vpad);
                    break;
                }
                case 2: {
                    rectY = y;
                    textY = (float)(rectY + vpad);
                }
            }
            if (rotation != 0.0) {
                graphics.pose().rotateAbout((float)Math.toRadians(-rotation), (float)x, (float)y);
            }
            graphics.pose().translate((float)((double)textX - Math.floor(textX)), (float)((double)textY - Math.floor(textY)));
            if (drawRect) {
                int hpad = 2;
                DrawUtil.drawRectangle(graphics, rectX - 2.0, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
            }
            color = RGB.toArgb(RGB.rgbaToRgb(color), alpha);
            graphics.drawString(fontRenderer, text, (int)Math.floor(textX), (int)Math.floor(textY), color.intValue(), fontShadow);
        }
        finally {
            graphics.pose().popMatrix();
        }
    }

    public static void drawBatchLabel(GuiGraphics graphics, PoseStack poseStack, Component text, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawBatchLabel(graphics, poseStack, text, x, y, hAlign, vAlign, labelSpec.background.getColor(), labelSpec.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawBatchLabel(GuiGraphics graphics, PoseStack poseStack, Component text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            Font fontRenderer = Minecraft.getInstance().font;
            bgWidth = fontRenderer.width((FormattedText)text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawBatchLabel(graphics, poseStack, text, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    private static void drawBatchLabel(GuiGraphics graphics, PoseStack poseStack, Component text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double d;
        int height;
        if (text == null || text.getString().length() == 0) {
            return;
        }
        Font fontRenderer = Minecraft.getInstance().font;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.width((FormattedText)text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.isBidirectional()) {
            --height;
        }
        poseStack.pushPose();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            poseStack.scale((float)fontScale, (float)fontScale, 0.0f);
        }
        float textX = (float)x;
        float textY = (float)y;
        double rectX = x;
        double rectY = y;
        switch (hAlign.ordinal()) {
            case 0: {
                textX = (float)(x - width);
                rectX = textX;
                break;
            }
            case 1: {
                textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case 2: {
                textX = (float)x;
                rectX = (float)x;
            }
        }
        if (drawRect) {
            Objects.requireNonNull(fontRenderer);
            d = (double)(height - 9) / 2.0;
        } else {
            d = 0.0;
        }
        double vpad = d;
        switch (vAlign.ordinal()) {
            case 0: {
                rectY = y - (double)height;
                textY = (float)(rectY + vpad + (double)(!fontRenderer.isBidirectional() ? 1 : 0));
                break;
            }
            case 1: {
                rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                textY = (float)(rectY + vpad);
                break;
            }
            case 2: {
                rectY = y;
                textY = (float)(rectY + vpad);
            }
        }
        if (rotation != 0.0) {
            poseStack.translate(x, y, 0.0);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(-rotation)));
            poseStack.translate(-x, -y, 0.0);
        }
        if (drawRect) {
            RenderWrapper.disableDepthTest();
            int hpad = 2;
            DrawUtil.drawRectangle(graphics, rectX - 2.0, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
        }
        if (alpha < 0.0f) {
            color = RGB.toArgb(color, alpha);
        }
        graphics.drawString(fontRenderer, text, (int)textX, (int)textY, color, fontShadow);
        poseStack.popPose();
    }

    public static void drawBatchLabel(PoseStack poseStack, Component text, DrawStep.Pass pass, MultiBufferSource buffers, double x, double y, HAlign hAlign, VAlign vAlign, int bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        if (pass != DrawStep.Pass.TextBG && pass != DrawStep.Pass.Text) {
            return;
        }
        if (text == null || text.getString().length() == 0) {
            return;
        }
        if (pass == DrawStep.Pass.TextBG && bgAlpha == 0.0f || pass == DrawStep.Pass.Text && alpha == 0.0f) {
            return;
        }
        Font fontRenderer = Minecraft.getInstance().font;
        int width = fontRenderer.width((FormattedText)text);
        Objects.requireNonNull(fontRenderer);
        int height = 9;
        poseStack.pushPose();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            poseStack.scale((float)fontScale, (float)fontScale, 0.0f);
        }
        double textX = x;
        double textY = y;
        switch (hAlign.ordinal()) {
            case 0: {
                textX = x - (double)width;
                break;
            }
            case 1: {
                textX = x - (double)(width / 2);
                break;
            }
            case 2: {
                textX = x;
            }
        }
        double padding = 2.0 / fontScale * (double)Mth.floor((double)fontScale);
        switch (vAlign.ordinal()) {
            case 0: {
                textY = y - ((double)height + padding * 2.0) + (double)(!fontRenderer.isBidirectional() ? 1 : 0);
                break;
            }
            case 1: {
                textY = y - (double)((int)((double)height + padding * 2.0) / 2);
                break;
            }
            case 2: {
                textY = y;
            }
        }
        textY += padding - 1.0;
        if (rotation != 0.0) {
            poseStack.translate(x, y, 0.0);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(-rotation)));
            poseStack.translate(-x, -y, 0.0);
        }
        if (pass == DrawStep.Pass.TextBG) {
            float rectX = (float)(textX - padding);
            float rectY = (float)(textY - padding);
            float rectW = (float)((double)width + padding * 2.0);
            float rectH = (float)((double)height + padding * 2.0);
            VertexConsumer vertexBuilder = buffers.getBuffer(JMRenderTypes.RECTANGLE_RENDER_TYPE);
            DrawUtil.drawRectangle(poseStack, vertexBuilder, rectX, rectY, rectW, rectH, bgColor, bgAlpha);
        } else {
            Matrix4f matrixPos = poseStack.last().pose();
            color = RGB.toArgb(color, alpha);
            fontRenderer.drawInBatch(text, (float)textX, (float)textY + 1.0f, color, fontShadow, matrixPos, buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        poseStack.popPose();
    }

    public static int getLabelHeight(Font fr, boolean fontShadow) {
        int vpad = fr.isBidirectional() ? 0 : (fontShadow ? 6 : 4);
        Objects.requireNonNull(fr);
        return 9 + vpad;
    }

    public static void drawRectangle(GuiGraphics graphics, double x, double y, double width, double height, int color, float alpha) {
        int rgba = RGB.toArgb(color, alpha);
        graphics.fill(Pipelines.RECTANGLE_RENDER_PIPELINE, (int)x, (int)y, (int)(x + width), (int)(y + height), rgba);
    }

    public static void drawGradientRect(GuiGraphics graphics, double x, double y, double width, double height, int startColor, float startAlpha, int endColor, float endAlpha) {
        if (startAlpha > 1.0f) {
            startAlpha /= 255.0f;
        }
        if (endAlpha > 1.0f) {
            endAlpha /= 255.0f;
        }
        int rgbaStart = RGB.toArgb(startColor, startAlpha);
        int rgbaEnd = RGB.toArgb(endColor, endAlpha);
        graphics.fillGradient((int)x, (int)y, (int)(x + width), (int)(height + y), rgbaStart, rgbaEnd);
    }

    public static void drawOnMapImageScaleCorrected(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, float scale, double rotation) {
        DrawUtil.drawOnMapImageScaleCorrected(graphics, texture, color, alpha, x, y, width, height, scale, rotation, false);
    }

    public static void drawOnMapImageScaleCorrected(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, float scale, double rotation, boolean blur) {
        double scaledWidth = width * (double)scale;
        double scaledHeight = height * (double)scale;
        double drawX = x - scaledWidth / 2.0;
        double drawY = y - scaledHeight / 2.0;
        DrawUtil.drawOnMapImage(graphics, texture, color, alpha, drawX, drawY, scaledWidth, scaledHeight, rotation, blur);
    }

    public static void drawOnMapImage(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, double rotation, boolean blur) {
        DrawUtil.drawOnMapImage(graphics, texture, color, alpha, x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f, rotation, blur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawOnMapImage(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, float minU, float maxU, float minV, float maxV, double rotation, boolean blur) {
        Matrix3x2fStack pose = graphics.pose();
        try {
            pose.pushMatrix();
            AbstractTexture tex = TextureCache.getTexture(texture);
            if (tex == null) {
                return;
            }
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (rotation != 0.0) {
                float transX = (float)(x + width / 2.0);
                float transY = (float)(y + height / 2.0);
                pose.rotateAbout((float)Math.toRadians(-rotation), transX, transY);
            }
            int argb = RGB.toArgb(color, alpha);
            ((GuiGraphicsAccessor)graphics).jm$GuiRenderStateAccessor().submitGuiElement((GuiElementRenderState)new BlitRenderState(RenderPipelines.GUI_TEXTURED, TextureSetup.singleTexture((GpuTextureView)tex.getTextureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(blur ? FilterMode.LINEAR : FilterMode.NEAREST)), new Matrix3x2f((Matrix3x2fc)graphics.pose()), (int)x, (int)y, (int)(x + width), (int)(y + height), minU, maxU, minV, maxV, argb, ((GuiGraphicsAccessor)graphics).jm$ScissorStackAccessor().peek()));
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            pose.popMatrix();
        }
    }

    public static void drawBlurredTexture(GuiGraphics graphics, Identifier texture, double x, double y, double width, double height, boolean flip, float scale, double rotation) {
        DrawUtil.drawTexture(graphics, texture, x, y, width, height, flip, scale, rotation, true);
    }

    public static void drawTexture(GuiGraphics graphics, Identifier texture, double x, double y, double width, double height, boolean flip, float scale, double rotation, boolean blur) {
        DrawUtil.drawTexture(graphics, texture, 0xFFFFFF, 1.0f, x, y, width, height, flip, scale, rotation, blur, false);
    }

    public static void drawColoredTexture(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, float scale, double rotation) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width, height, false, scale, rotation, true, false);
    }

    public static void drawColoredTexture(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, float scale, double rotation, boolean blur) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width, height, false, scale, rotation, blur, false);
    }

    public static void drawTexture(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, boolean flip, float scale, double rotation, boolean blur, boolean clamp) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width * (double)scale, height * (double)scale, rotation, flip, blur, clamp);
    }

    public static void drawTexture(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, double rotation, boolean flip, boolean blur) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width, height, rotation, flip, blur, false);
    }

    public static void drawClampedTexture(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, float scale, double rotation) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width * (double)scale, height * (double)scale, rotation, false, true, true);
    }

    public static void drawTexture(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawTexture(graphics, texture, color, alpha, x, y, width, height, rotation, flip, true, false);
    }

    public static void drawTexture(GuiGraphics graphics, Identifier texture, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawTexture(graphics, texture, 0xFFFFFF, 1.0f, x, y, width, height, rotation, flip, true, false);
    }

    public static void drawTexture(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, double rotation, boolean flip, boolean blur, boolean clamp) {
        DrawUtil.drawTexture(graphics, RenderPipelines.GUI_TEXTURED, texture, color, alpha, x, y, width, height, rotation, flip, blur, clamp);
    }

    public static void drawTexture(GuiGraphics graphics, RenderPipeline pipeline, Identifier texture, int color, float alpha, double x, double y, double width, double height, double rotation, boolean flip, boolean blur, boolean clamp) {
        DrawUtil.drawTexture(graphics, pipeline, texture, color, alpha, x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f, rotation, flip, blur, clamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawTexture(GuiGraphics graphics, RenderPipeline pipeline, Identifier texture, int color, float alpha, double x, double y, double width, double height, float minU, float maxU, float minV, float maxV, double rotation, boolean flip, boolean blur, boolean clamp) {
        Matrix3x2fStack pose = graphics.pose();
        try {
            pose.pushMatrix();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (rotation != 0.0) {
                float transX = (float)(x + width / 2.0);
                float transY = (float)(y + height / 2.0);
                pose.rotateAbout((float)Math.toRadians(-rotation), transX, transY);
            }
            int argb = RGB.toArgb(color, alpha);
            float direction = flip ? -maxU : maxU;
            ((GuiGraphicsAccessor)graphics).innerBlitInvoker(pipeline, texture, (int)Math.round(x), (int)Math.round(x + width), (int)Math.round(y), (int)Math.round(y + height), minU, direction, minV, maxV, argb);
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            pose.popMatrix();
        }
    }

    public static void blitToCurrentLayer(GuiGraphics graphics, Identifier texture, int color, float alpha, double x, double y, double width, double height, float scale, boolean blur) {
        AbstractTexture tex = TextureCache.getTexture(texture);
        DrawUtil.blitToCurrentLayer(graphics, RenderPipelines.GUI_TEXTURED, tex.getTextureView(), color, alpha, x, y, width * (double)scale, height * (double)scale, blur);
    }

    public static void blitToCurrentLayer(GuiGraphics graphics, RenderPipeline pipeline, GpuTextureView textureView, int color, float alpha, double x, double y, double width, double height, boolean blur) {
        DrawUtil.blitToCurrentLayer(graphics, pipeline, textureView, color, alpha, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f, blur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void blitToCurrentLayer(GuiGraphics graphics, RenderPipeline pipeline, GpuTextureView textureView, int color, float alpha, double x, double y, double width, double height, float minU, float minV, float maxU, float maxV, boolean blur) {
        try {
            graphics.pose().pushMatrix();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            ((GuiGraphicsAccessor)graphics).jm$GuiRenderStateAccessor().submitGuiElement((GuiElementRenderState)new BlitRenderState(pipeline, TextureSetup.singleTexture((GpuTextureView)textureView, (GpuSampler)RenderSystem.getSamplerCache().getRepeat(blur ? FilterMode.LINEAR : FilterMode.NEAREST)), new Matrix3x2f((Matrix3x2fc)graphics.pose()), (int)x, (int)y, (int)(x + width), (int)(y + height), minU, maxU, minV, maxV, RGB.toArgb(color, alpha), ((GuiGraphicsAccessor)graphics).jm$ScissorStackAccessor().peek()));
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            graphics.pose().popMatrix();
        }
    }

    public static void drawQuad(PoseStack poseStack, VertexConsumer vertexBuilder, int color, float alpha, double x, double y, double width, double height, double rotation, boolean flip) {
        DrawUtil.drawQuad(poseStack, vertexBuilder, color, alpha, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip);
    }

    public static void drawQuad(PoseStack poseStack, VertexConsumer vertexConsumer, DynamicTexture texture, int color, float alpha, double x, double y, float scale, double rotation, boolean flip) {
        DrawUtil.drawQuad(poseStack, vertexConsumer, color, alpha, x, y, (float)((TextureAccess)texture).journeymap$getWidth() * scale, (float)((TextureAccess)texture).journeymap$getHeight() * scale, 0.0, 0.0, 1.0, 1.0, rotation, flip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawQuad(PoseStack poseStack, VertexConsumer vertexBuilder, int color, float alpha, double x, double y, double width, double height, double minU, double minV, double maxU, double maxV, double rotation, boolean flip) {
        try {
            poseStack.pushPose();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (rotation != 0.0) {
                double transX = x + width / 2.0;
                double transY = y + height / 2.0;
                poseStack.translate(transX, transY, 0.0);
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(-rotation)));
                poseStack.translate(-transX, -transY, 0.0);
            }
            float[] rgba = RGB.floats(color, alpha);
            double direction = flip ? -maxU : maxU;
            DrawUtil.addVertexUV(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x, height + y, zLevel, minU, maxV);
            DrawUtil.addVertexUV(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x + width, height + y, zLevel, direction, maxV);
            DrawUtil.addVertexUV(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x + width, y, zLevel, direction, minV);
            DrawUtil.addVertexUV(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x, y, zLevel, minU, minV);
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            poseStack.popPose();
        }
    }

    public static void drawColoredEntity(PoseStack poseStack, VertexConsumer vertexBuilder, DynamicTexture texture, int color, float alpha, double x, double y, float scale, double rotation) {
        if (texture == null || texture.getPixels() == null) {
            return;
        }
        double width = (float)((TextureAccess)texture).journeymap$getWidth() * scale;
        double height = (float)((TextureAccess)texture).journeymap$getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        drawX = Math.floor(drawX);
        drawY = Math.floor(drawY);
        DrawUtil.drawQuad(poseStack, vertexBuilder, color, alpha, drawX, drawY, width, height, rotation, false);
    }

    public static void drawWaypointIcon(PoseStack poseStack, VertexConsumer vertexBuilder, DynamicTexture texture, float scale, int color, float alpha, double x, double y, double rotation) {
        if (scale > 1.0f) {
            texture = ((TextureAccess)texture).journeymap$getScaledImage(scale);
            scale = 1.0f;
        }
        double width = (float)((TextureAccess)texture).journeymap$getWidth() * scale;
        double height = (float)((TextureAccess)texture).journeymap$getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawQuad(poseStack, vertexBuilder, color, alpha, drawX, drawY, width, height, rotation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectangle(PoseStack poseStack, VertexConsumer vertexBuilder, double x, double y, double width, double height, int color, float alpha) {
        try {
            poseStack.pushPose();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            float[] rgba = RGB.floats(color, alpha);
            DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (double)((float)x), (double)((float)(height + y)), zLevel);
            DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (double)((float)(x + width)), (double)((float)(height + y)), zLevel);
            DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (double)((float)(x + width)), (double)((float)y), zLevel);
            DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (double)((float)x), (double)((float)y), zLevel);
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            poseStack.popPose();
        }
    }

    public static void drawPolygon(GuiGraphics graphics, PoseStack poseStack, MultiBufferSource.BufferSource buffers, double xOffset, double yOffset, List<Point2D.Double> fillPoints, List<List<Point2D.Double>> strokePoints, List<Point2D.Double> texturePoints, AbstractTexture texture, Identifier identifier, ShapeProperties shapeProperties) {
        int i;
        float[] rgba;
        if (shapeProperties.getFillOpacity() >= 0.01f) {
            rgba = RGB.floats(shapeProperties.getFillColor(), shapeProperties.getFillOpacity());
            int lastIndex = fillPoints.size() - 1;
            if (texture == null || shapeProperties.getTextureScaleX() == 0.0 || shapeProperties.getTextureScaleY() == 0.0) {
                RenderType renderType = JMRenderTypes.POLYGON_WITHOUT_TEXTURE_RENDER_TYPE;
                VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
                for (int i2 = 0; i2 <= lastIndex; ++i2) {
                    Point2D.Double point = fillPoints.get(i2);
                    DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() + xOffset, point.getY() + yOffset, zLevel);
                }
            } else {
                double textureWidth = (double)((TextureAccess)texture).journeymap$getWidth() * shapeProperties.getTextureScaleX();
                double textureHeight = (double)((TextureAccess)texture).journeymap$getHeight() * shapeProperties.getTextureScaleY();
                RenderType renderType = JMRenderTypes.getPolygonWithTexture(texture, identifier);
                VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
                for (i = 0; i <= lastIndex; ++i) {
                    Point2D.Double point = fillPoints.get(i);
                    double xTex = (texturePoints.get(i).getX() - shapeProperties.getTexturePositionX()) / textureWidth;
                    double yTex = (texturePoints.get(i).getY() - shapeProperties.getTexturePositionY()) / textureHeight;
                    DrawUtil.addVertexUV(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() + xOffset, point.getY() + yOffset, zLevel, xTex, yTex);
                }
            }
        }
        if (shapeProperties.getStrokeOpacity() >= 0.01f && shapeProperties.getStrokeWidth() > 0.0f) {
            rgba = RGB.floats(shapeProperties.getStrokeColor(), shapeProperties.getStrokeOpacity());
            float insideStroke = 0.0f;
            float outsideStroke = 0.0f;
            switch (shapeProperties.getStrokePosition()) {
                case INSIDE: {
                    insideStroke = shapeProperties.getStrokeWidth();
                    break;
                }
                case CENTER: {
                    outsideStroke = insideStroke = shapeProperties.getStrokeWidth() / 2.0f;
                    break;
                }
                default: {
                    outsideStroke = shapeProperties.getStrokeWidth();
                }
            }
            RenderType renderType = JMRenderTypes.POLYGON_STROKE_RENDER_TYPE;
            for (List<Point2D.Double> screenPoints : strokePoints) {
                if (screenPoints.size() < 3) continue;
                VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
                int lastIndex = screenPoints.size() - 1;
                for (i = 0; i <= lastIndex + 1; ++i) {
                    int iPoint = i <= lastIndex ? i : 0;
                    int iPrev = iPoint > 0 ? iPoint - 1 : lastIndex;
                    int iNext = iPoint < lastIndex ? iPoint + 1 : 0;
                    Point2D.Double point = screenPoints.get(iPoint);
                    Point2D.Double prev = screenPoints.get(iPrev);
                    Point2D.Double next = screenPoints.get(iNext);
                    Point2D.Double normal = DrawUtil.calculateNormal(prev, point, next);
                    DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() + normal.getX() * (double)insideStroke + xOffset, point.getY() + normal.getY() * (double)insideStroke + yOffset, zLevel);
                    DrawUtil.addVertex(poseStack, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() - normal.getX() * (double)outsideStroke + xOffset, point.getY() - normal.getY() * (double)outsideStroke + yOffset, zLevel);
                }
            }
        }
    }

    private static Point2D.Double calculateNormal(Point2D.Double prev, Point2D.Double point, Point2D.Double next) {
        Vec2 edgeNormal2;
        Vec2 edge1 = new Vec2((float)(point.x - prev.x), (float)(point.y - prev.y));
        Vec2 edge2 = new Vec2((float)(next.x - point.x), (float)(next.y - point.y));
        Vec2 edgeNormal1 = new Vec2(-edge1.y, edge1.x).normalized();
        Vec2 vertexNormal = edgeNormal1.add(edgeNormal2 = new Vec2(-edge2.y, edge2.x).normalized()).normalized();
        double angle = Math.acos(vertexNormal.dot(edgeNormal1));
        double factor = Math.cos(angle);
        if (factor < 0.1) {
            factor = 0.1;
        }
        factor = 1.0 / factor;
        return new Point2D.Double((double)vertexNormal.x * factor, (double)vertexNormal.y * factor);
    }

    public static void addVertexUV(PoseStack poseStack, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV) {
        bufferIn.addVertex((Matrix4fc)poseStack.last().pose(), x, (float)y, z).setColor(red, green, blue, alpha).setUv(texU, texV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
    }

    public static void addVertexUV(PoseStack poseStack, VertexConsumer bufferIn, float red, float green, float blue, float alpha, double x, double y, double z, double texU, double texV) {
        bufferIn.addVertex((Matrix4fc)poseStack.last().pose(), (float)x, (float)y, (float)z).setColor(red, green, blue, alpha).setUv((float)texU, (float)texV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
    }

    public static void addVertex(PoseStack poseStack, VertexConsumer bufferIn, float red, float green, float blue, float alpha, double x, double y, double z) {
        bufferIn.addVertex((Matrix4fc)poseStack.last().pose(), (float)x, (float)y, (float)z).setColor(red, green, blue, alpha).setNormal(poseStack.last(), 0.0f, 1.0f, 0.0f);
    }

    public static void addVertex(Matrix3x2fStack pos, VertexConsumer bufferIn, float red, float green, float blue, float alpha, double x, double y, double z) {
        bufferIn.addVertexWith2DPose((Matrix3x2fc)pos, (float)x, (float)y).setColor(red, green, blue, alpha);
    }

    public static void addVertexUV(Matrix3x2fStack pos, VertexConsumer bufferIn, float red, float green, float blue, float alpha, double x, double y, double z, double texU, double texV) {
        bufferIn.addVertexWith2DPose((Matrix3x2fc)pos, (float)x, (float)y).setColor(red, green, blue, alpha).setUv((float)texU, (float)texV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0);
    }

    public static void addVertexWithUV(PoseStack poseStack, BufferBuilder buff, float x, float y, float z, float u, float v) {
        PoseStack.Pose entry = poseStack.last();
        Matrix4f matrix4f = entry.pose();
        buff.addVertex((Matrix4fc)matrix4f, x, y, z).setUv(u, v);
    }

    public static void addVertexWithUV(PoseStack poseStack, BufferBuilder buff, double x, double y, double z, double u, double v) {
        DrawUtil.addVertexWithUV(poseStack, buff, (float)x, (float)y, (float)z, (float)u, (float)v);
    }

    public static void addVertexUV(GuiGraphics graphics, PoseStack poseStack, BufferBuilder buff, double x, double y, double z, double u, double v, int[] rgba) {
        PoseStack.Pose entry = poseStack.last();
        Matrix4f matrix4f = entry.pose();
        buff.addVertex((Matrix4fc)matrix4f, (float)x, (float)y, (float)z).setColor(rgba[0], rgba[1], rgba[2], rgba[3]).setUv((float)u, (float)v);
    }

    private static void addVertex(Matrix4f mat, BufferBuilder buff, double x, double y, double z, int[] rgba) {
        buff.addVertex((Matrix4fc)mat, (float)x, (float)y, (float)z).setColor(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public static enum HAlign {
        Left,
        Center,
        Right;

    }

    public static enum VAlign {
        Above,
        Middle,
        Below;

    }
}

