/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.Effect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.world.phys.Vec2;

public class HudOverlayHandler {
    private final Minecraft mc = Minecraft.getInstance();
    private static HudOverlayHandler instance;

    private HudOverlayHandler() {
    }

    public static HudOverlayHandler getInstance() {
        if (instance == null) {
            instance = new HudOverlayHandler();
        }
        return instance;
    }

    public boolean preOverlay(GuiGraphics graphics) {
        if (JourneymapClient.getInstance().enabled() && !Minecraft.getInstance().options.hideGui && Effect.getInstance().canPotionShift()) {
            Vec2 location = Effect.getInstance().getPotionEffectsLocation();
            graphics.pose().pushMatrix();
            graphics.pose().translate(location.x, location.y);
            return true;
        }
        return false;
    }

    public void postOverlay(GuiGraphics graphics) {
        if (JourneymapClient.getInstance().enabled()) {
            graphics.pose().popMatrix();
        }
    }

    public void renderWaypointDecos(GuiGraphics graphics, PoseStack poseStack) {
        if (JourneymapClient.getInstance().enabled() && (this.mc.screen == null || this.mc.screen instanceof ChatScreen) && this.mc.level != null) {
            try {
                UIManager.INSTANCE.drawWaypointDecorations(graphics, poseStack);
            }
            catch (Throwable t) {
                JMLogger.throwLogOnce("Unexpected error during renderWaypointDecos: " + String.valueOf(t), t);
            }
        }
    }

    public void onRenderOverlay(GuiGraphics graphics) {
        if (JourneymapClient.getInstance().enabled() && this.mc.level != null && (this.mc.screen == null || this.mc.screen instanceof ChatScreen)) {
            try {
                if (!Minecraft.getInstance().options.hideGui) {
                    UIManager.INSTANCE.drawMiniMap(graphics);
                }
            }
            catch (Throwable t) {
                JMLogger.throwLogOnce("Unexpected error during onRenderOverlayEarly: " + String.valueOf(t), t);
            }
        }
    }
}

