/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.minecraft.forge.ForgeEndertech;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface INBTSource<T> {
    public Optional<T> source();

    public CompoundTag serialize();

    public static INBTSource<Entity> of(final @Nullable Entity entity) {
        return new INBTSource<Entity>(){

            @Override
            public Optional<Entity> source() {
                return Optional.ofNullable(entity);
            }

            @Override
            public CompoundTag serialize() {
                CompoundTag compound = new CompoundTag();
                try {
                    return this.source().map(src -> src.serializeNBT((HolderLookup.Provider)src.registryAccess())).orElse(compound);
                }
                catch (Exception e) {
                    ForgeEndertech.debugMsg(e.toString());
                    return compound;
                }
            }
        };
    }

    public static INBTSource<BlockEntity> of(final @Nullable BlockEntity blockEntity) {
        return new INBTSource<BlockEntity>(){

            @Override
            public Optional<BlockEntity> source() {
                return Optional.ofNullable(blockEntity);
            }

            @Override
            public CompoundTag serialize() {
                CompoundTag compound = new CompoundTag();
                try {
                    Optional<RegistryAccess> registry = this.source().map(BlockEntity::getLevel).map(Level::registryAccess);
                    return registry.flatMap(reg -> this.source().map(src -> src.saveWithoutMetadata((HolderLookup.Provider)reg))).orElse(compound);
                }
                catch (Exception e) {
                    ForgeEndertech.debugMsg(e.toString());
                    return compound;
                }
            }
        };
    }
}

