/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DataProviders {

    public static abstract class BaseLootTable
    extends LootTableProvider {
        protected static final Logger LOGGER = LogManager.getLogger();
        protected final Map<Block, LootTable.Builder> blockLootTables = new ConcurrentHashMap<Block, LootTable.Builder>();
        protected final Map<Identifier, LootTable> customLootTables = new ConcurrentHashMap<Identifier, LootTable>();
        protected final PackOutput.PathProvider pathProvider;
        protected final CompletableFuture<HolderLookup.Provider> registries;

        public BaseLootTable(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, Set.of(), VanillaLootTableProvider.create((PackOutput)packOutput, lookupProvider).getTables(), lookupProvider);
            this.pathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "loot_table");
            this.registries = lookupProvider;
        }

        protected abstract void addTables();

        protected LootPool.Builder blockPool(String name, Block block) {
            return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block));
        }

        protected void addBlock(RegistryObject<? extends Block> block) {
            this.addBlock(block.getId().getPath(), (Block)block.get());
        }

        protected void addBlock(String name, Block block) {
            this.addBlockPool(block, this.blockPool(name, block));
        }

        protected void addBlockPool(Block block, LootPool.Builder pool) {
            this.blockLootTables.put(block, LootTable.lootTable().withPool(pool));
        }

        public CompletableFuture<?> run(CachedOutput cache) {
            this.addTables();
            HashMap tables = new HashMap();
            this.blockLootTables.forEach((block, builder) -> tables.put(((ResourceKey)block.getLootTable().get()).identifier(), builder.setParamSet(LootContextParamSets.BLOCK).build()));
            this.customLootTables.forEach(tables::put);
            return this.registries.thenCompose(provider -> this.writeTables(cache, tables, (HolderLookup.Provider)provider));
        }

        protected CompletableFuture<?> writeTables(CachedOutput cache, Map<Identifier, LootTable> tables, HolderLookup.Provider provider) {
            return CompletableFuture.allOf((CompletableFuture[])tables.entrySet().stream().map(entry -> {
                Path path = this.pathProvider.json((Identifier)entry.getKey());
                LootTable lootTable = (LootTable)entry.getValue();
                return DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)provider, (Codec)LootTable.DIRECT_CODEC, (Object)lootTable, (Path)path);
            }).toArray(CompletableFuture[]::new));
        }
    }

    public static abstract class ItemTags
    extends IntrinsicHolderTagsProvider<Item> {
        private final CompletableFuture<TagsProvider.TagLookup<Block>> blockTags;
        private final Map<TagKey<Block>, TagKey<Item>> tagsToCopy = new HashMap<TagKey<Block>, TagKey<Item>>();

        public ItemTags(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> pBlockTags, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(pOutput, Registries.ITEM, pLookupProvider, item -> item.builtInRegistryHolder().key(), modId, existingFileHelper);
            this.blockTags = pBlockTags;
        }

        protected void copy(TagKey<Block> pBlockTag, TagKey<Item> pItemTag) {
            this.tagsToCopy.put(pBlockTag, pItemTag);
        }

        protected CompletableFuture<HolderLookup.Provider> createContentsProvider() {
            return super.createContentsProvider().thenCombine(this.blockTags, (provider, blockTagLookup) -> {
                this.tagsToCopy.forEach((blockTagKey, itemTagKey) -> {
                    TagBuilder tagbuilder = this.getOrCreateRawBuilder((TagKey)itemTagKey);
                    Optional optional = (Optional)blockTagLookup.apply(blockTagKey);
                    ((TagBuilder)optional.orElseThrow(() -> new IllegalStateException("Missing block tag " + String.valueOf(itemTagKey.location())))).build().forEach(entry -> tagbuilder.addTag(entry.getId()));
                });
                return provider;
            });
        }
    }

    public static abstract class BlockTags
    extends IntrinsicHolderTagsProvider<Block> {
        public BlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, Registries.BLOCK, lookupProvider, block -> block.builtInRegistryHolder().key(), modId, existingFileHelper);
        }
    }
}

