/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.DataProviders;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

public class DataCollector {
    protected final AbstractForgeMod mod;
    protected final GatherDataEvent event;
    public final String modId;
    public final DataGenerator generator;
    public final PackOutput packOutput;
    public final CompletableFuture<HolderLookup.Provider> lookupProvider;
    public final ExistingFileHelper fileHelper;

    public DataCollector(AbstractForgeMod mod, GatherDataEvent event) {
        this.mod = mod;
        this.event = event;
        this.modId = mod.getId();
        this.generator = event.getGenerator();
        this.packOutput = event.getGenerator().getPackOutput();
        this.lookupProvider = event.getLookupProvider();
        this.fileHelper = event.getExistingFileHelper();
    }

    protected <T extends DataProvider> void addProvider(boolean run, T provider) {
        this.event.getGenerator().addProvider(run, provider);
    }

    public DataCollector addBlockAndItemTags(BlockTagsProviderFactory<?> blockTagsFactory, ItemTagsProviderFactory<?> itemTagsFactory) {
        if (this.event.includeServer()) {
            Object blockTagsProvider = blockTagsFactory.create(this.packOutput, this.lookupProvider, this.modId, this.fileHelper);
            this.addProvider(true, (DataProvider)blockTagsProvider);
            this.addProvider(true, (DataProvider)itemTagsFactory.create(this.packOutput, this.lookupProvider, blockTagsProvider.contentsGetter(), this.modId, this.fileHelper));
        }
        return this;
    }

    public DataCollector addLootTables(DataProviderFactory<? extends LootTableProvider> providerFactory) {
        if (this.event.includeServer()) {
            this.addProvider(true, providerFactory.create(this.packOutput, this.lookupProvider));
        }
        return this;
    }

    public DataCollector addRecipes(final RecipeProviderFactory<?> providerFactory) {
        if (this.event.includeServer()) {
            this.addProvider(true, new RecipeProvider.Runner(this.packOutput, this.lookupProvider){

                protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
                    return providerFactory.create(provider, output);
                }

                public String getName() {
                    return DataCollector.this.modId + " Recipes";
                }
            });
        }
        return this;
    }

    public DataCollector addBlockStates(ClientDataProviderFactory<? extends BlockStateProvider> providerFactory) {
        if (this.event.includeClient()) {
            this.addProvider(true, providerFactory.create(this.packOutput, this.modId, this.fileHelper));
        }
        return this;
    }

    public DataCollector addItemModels(ClientDataProviderFactory<? extends ModelProvider> providerFactory) {
        if (this.event.includeClient()) {
            this.addProvider(true, providerFactory.create(this.packOutput, this.modId, this.fileHelper));
        }
        return this;
    }

    public DataCollector addLanguageUS(LanguageProviderFactory<?> providerFactory) {
        if (this.event.includeClient()) {
            this.addProvider(true, (DataProvider)providerFactory.create(this.packOutput, this.modId, "en_us"));
        }
        return this;
    }

    @FunctionalInterface
    public static interface BlockTagsProviderFactory<T extends DataProviders.BlockTags> {
        public T create(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, String var3, @Nullable ExistingFileHelper var4);
    }

    @FunctionalInterface
    public static interface ItemTagsProviderFactory<T extends DataProviders.ItemTags> {
        public T create(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2, CompletableFuture<TagsProvider.TagLookup<Block>> var3, String var4, @Nullable ExistingFileHelper var5);
    }

    @FunctionalInterface
    public static interface DataProviderFactory<T extends DataProvider> {
        public T create(PackOutput var1, CompletableFuture<HolderLookup.Provider> var2);
    }

    @FunctionalInterface
    public static interface RecipeProviderFactory<T extends RecipeProvider> {
        public T create(HolderLookup.Provider var1, RecipeOutput var2);
    }

    @FunctionalInterface
    public static interface ClientDataProviderFactory<T extends DataProvider> {
        public T create(PackOutput var1, String var2, @Nullable ExistingFileHelper var3);
    }

    @FunctionalInterface
    public static interface LanguageProviderFactory<T extends LanguageProvider> {
        public T create(PackOutput var1, String var2, String var3);
    }
}

