/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client.sounds;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityBoundSoundLoop<E extends Entity>
extends AbstractTickableSoundInstance {
    public final E entity;

    public EntityBoundSoundLoop(SoundEvent soundEvent, SoundSource soundSource, E entity) {
        this(soundEvent, soundSource, entity, 1.0f, 1.0f, 0);
    }

    public EntityBoundSoundLoop(SoundEvent soundEvent, SoundSource soundSource, E entity, float volume, float pitch, int delay) {
        super(soundEvent, soundSource, SoundInstance.createUnseededRandom());
        this.volume = volume;
        this.pitch = pitch;
        this.entity = entity;
        this.delay = delay;
        this.looping = true;
        this.updatePosition();
    }

    public abstract boolean shouldStop();

    protected void updatePosition() {
        Vect3d center = ForgeEntity.getCenterPosition(this.entity);
        this.x = center.x;
        this.y = center.y;
        this.z = center.z;
    }

    public void tick() {
        if (this.entity.isRemoved() || this.shouldStop()) {
            this.stop();
        } else {
            this.updatePosition();
        }
    }
}

