/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.service;

import com.nemonotfound.nemos.inventory.sorting.model.FilterResult;
import com.nemonotfound.nemos.inventory.sorting.service.TooltipService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;

public class FilterService {
    private static FilterService INSTANCE;
    private final TooltipService tooltipService;

    public static FilterService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FilterService(TooltipService.getInstance());
        }
        return INSTANCE;
    }

    public FilterService(TooltipService tooltipService) {
        this.tooltipService = tooltipService;
    }

    public Map<FilterResult, List<Slot>> filterSlots(NonNullList<Slot> slots, String filter) {
        return slots.stream().collect(Collectors.groupingBy(slot -> this.filterSlot((Slot)slot, filter)));
    }

    private FilterResult filterSlot(Slot slot, String filter) {
        ItemStack slotItem = slot.getItem();
        if (slotItem.is(Items.AIR)) {
            return FilterResult.EXCLUDED;
        }
        if (this.bundleContentsMatchFilter(slotItem, filter) || this.itemContainerContentsMatchFilter(slotItem, filter)) {
            return FilterResult.HAS_INCLUDED_ITEM;
        }
        return this.matchesFilter(slotItem, filter) ? FilterResult.INCLUDED : FilterResult.EXCLUDED;
    }

    private boolean bundleContentsMatchFilter(ItemStack itemStack, String filter) {
        if (!itemStack.has(DataComponents.BUNDLE_CONTENTS)) {
            return false;
        }
        BundleContents bundleContents = (BundleContents)itemStack.get(DataComponents.BUNDLE_CONTENTS);
        Stream<ItemStack> stream = bundleContents != null ? bundleContents.itemCopyStream() : Stream.builder().build();
        return this.contentsMatchFilter(stream, filter);
    }

    private boolean itemContainerContentsMatchFilter(ItemStack itemStack, String filter) {
        if (!itemStack.has(DataComponents.CONTAINER)) {
            return false;
        }
        ItemContainerContents itemContainerContents = (ItemContainerContents)itemStack.get(DataComponents.CONTAINER);
        Stream<ItemStack> stream = itemContainerContents != null ? itemContainerContents.stream() : Stream.builder().build();
        return this.contentsMatchFilter(stream, filter);
    }

    private boolean contentsMatchFilter(Stream<ItemStack> stream, String filter) {
        return stream.anyMatch(itemStack -> this.matchesFilter((ItemStack)itemStack, filter) || this.bundleContentsMatchFilter((ItemStack)itemStack, filter));
    }

    private boolean matchesFilter(ItemStack itemStack, String filter) {
        boolean itemNameMatchesFilter = this.componentMatchesFilter(itemStack.getItemName(), filter);
        boolean itemDisplayNameMatchesFilter = this.componentMatchesFilter(itemStack.getDisplayName(), filter);
        boolean tooltipMatchesFilter = this.tooltipMatchesFilter(itemStack, filter);
        return itemNameMatchesFilter || itemDisplayNameMatchesFilter || tooltipMatchesFilter;
    }

    private boolean tooltipMatchesFilter(ItemStack itemStack, String filter) {
        List<Component> tooltipComponents = this.tooltipService.retrieveTooltipLines(itemStack);
        boolean itemEnchantsMatchesFilter = this.tooltipService.retrieveEnchantmentNames(tooltipComponents).toLowerCase().contains(filter.toLowerCase());
        boolean jukeboxSongMatchesFilter = this.tooltipService.retrieveJukeboxSongName(tooltipComponents).toLowerCase().contains(filter.toLowerCase());
        boolean potionMatchesFilter = this.tooltipService.retrievePotionName(tooltipComponents).toLowerCase().contains(filter.toLowerCase());
        return itemEnchantsMatchesFilter || jukeboxSongMatchesFilter || potionMatchesFilter;
    }

    private boolean componentMatchesFilter(Component component, String filter) {
        return component.getString().toLowerCase().contains(filter.toLowerCase());
    }
}

