/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.client.InventorySortingKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.config.DefaultConfigValues;
import com.nemonotfound.nemos.inventory.sorting.config.model.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.config.model.FilterConfig;
import com.nemonotfound.nemos.inventory.sorting.config.service.ConfigService;
import com.nemonotfound.nemos.inventory.sorting.gui.components.FilterBox;
import com.nemonotfound.nemos.inventory.sorting.gui.components.buttons.ToggleFilterPersistenceButton;
import com.nemonotfound.nemos.inventory.sorting.model.FilterResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class ContainerFilterMixin
extends Screen {
    @Unique
    private static final Identifier HIGHLIGHTED_SLOT = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/highlighted_slot");
    @Unique
    private static final Identifier HIGHLIGHTED_SLOT_INCLUDED_ITEM = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/highlighted_slot_included_item");
    @Unique
    private static final Identifier DIMMED_SLOT = Identifier.fromNamespaceAndPath((String)"nemos_inventory_sorting", (String)"container/dimmed_slot");
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Unique
    private FilterBox nemosInventorySorting$filterBox;
    @Unique
    private FilterConfig nemosInventorySorting$filterConfig;
    @Unique
    private int nemosInventorySorting$filterBoxWidth = 0;
    @Unique
    private final ConfigService nemosInventorySorting$configService = ConfigService.getInstance();

    protected ContainerFilterMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        List<ComponentConfig> componentConfigs = this.nemosInventorySorting$configService.readOrGetDefaultComponentConfigs();
        if (this.nemosInventorySorting$shouldHaveFilter()) {
            this.nemosInventorySorting$filterConfig = this.nemosInventorySorting$configService.readOrGetDefaultFilterConfig();
            this.nemosInventorySorting$initFilter(componentConfigs);
        }
    }

    @Inject(method={"onClose"}, at={@At(value="TAIL")})
    private void onClose(CallbackInfo ci) {
        if (this.nemosInventorySorting$filterBox == null) {
            return;
        }
        this.nemosInventorySorting$filterBox.updateAndSaveFilter(this.nemosInventorySorting$filterConfig);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (this.nemosInventorySorting$filterBox != null) {
            if (this.nemosInventorySorting$filterBox.isFocused() && keyEvent.key() != 256) {
                cir.setReturnValue((Object)this.nemosInventorySorting$filterBox.keyPressed(keyEvent));
                return;
            }
            if (!this.nemosInventorySorting$filterBox.isFocused() && keyEvent.hasControlDown() && InventorySortingKeyMappings.QUICK_SEARCH.get().matches(keyEvent)) {
                this.nemosInventorySorting$handleQuickSearch(cir);
                return;
            }
        }
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.keyPressed(keyEvent))) {
            cir.setReturnValue((Object)true);
        }
    }

    public boolean keyReleased(@NotNull KeyEvent keyEvent) {
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.keyReleased(keyEvent))) {
            return true;
        }
        return super.keyReleased(keyEvent);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void mouseClicked(MouseButtonEvent mouseButtonEvent, boolean isDoubleClick, CallbackInfoReturnable<Boolean> cir) {
        Optional optional = this.getChildAt(mouseButtonEvent.x(), mouseButtonEvent.y());
        if (optional.isEmpty()) {
            for (GuiEventListener guiEventListener : this.children()) {
                guiEventListener.setFocused(false);
            }
        }
        if (this.nemosInventorySorting$filterBox != null && !this.nemosInventorySorting$filterBox.isFocused() && mouseButtonEvent.hasControlDown() && InventorySortingKeyMappings.QUICK_SEARCH.get().matchesMouse(mouseButtonEvent)) {
            this.nemosInventorySorting$handleQuickSearch(cir);
            return;
        }
        if (this.nemosInventorySorting$triggerActionOnWidget(widget -> widget.mouseClicked(mouseButtonEvent, isDoubleClick))) {
            cir.setReturnValue((Object)true);
        }
        if (this.nemosInventorySorting$filterBox != null && !this.nemosInventorySorting$filterBox.mouseClicked(mouseButtonEvent, isDoubleClick) && this.getFocused() == this.nemosInventorySorting$filterBox) {
            this.setFocused(null);
        }
    }

    @Unique
    private void nemosInventorySorting$handleQuickSearch(CallbackInfoReturnable<Boolean> cir) {
        int filterBoxY;
        int filterBoxX = this.nemosInventorySorting$filterBox.getX();
        Optional optionalGuiEventListener = this.getChildAt(filterBoxX, filterBoxY = this.nemosInventorySorting$filterBox.getY());
        if (optionalGuiEventListener.isEmpty()) {
            return;
        }
        this.setFocused((GuiEventListener)optionalGuiEventListener.get());
        this.nemosInventorySorting$filterBox.setFocused(true);
        this.nemosInventorySorting$filterBox.onClick(new MouseButtonEvent((double)filterBoxX, (double)filterBoxY, new MouseButtonInfo(0, 0)), false);
        cir.setReturnValue((Object)true);
    }

    @Unique
    private boolean nemosInventorySorting$triggerActionOnWidget(Function<GuiEventListener, Boolean> function) {
        for (GuiEventListener widget : this.children()) {
            if (!(widget instanceof ToggleFilterPersistenceButton) || !function.apply(widget).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"renderContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlots(Lnet/minecraft/client/gui/GuiGraphics;II)V")})
    void renderHighlightedSlot(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.getValue();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<Slot>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((NonNullList<Slot>)this.nemosInventorySorting$getThis().getMenu().slots, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.INCLUDED), guiGraphics, HIGHLIGHTED_SLOT);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.HAS_INCLUDED_ITEM), guiGraphics, HIGHLIGHTED_SLOT_INCLUDED_ITEM);
        }
    }

    @Inject(method={"renderContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderSlotHighlightFront(Lnet/minecraft/client/gui/GuiGraphics;)V", shift=At.Shift.AFTER)})
    void renderDimmedSlot(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!this.nemosInventorySorting$shouldHaveFilter() || this.nemosInventorySorting$filterBox == null) {
            return;
        }
        String filter = this.nemosInventorySorting$filterBox.getValue();
        if (!filter.isEmpty()) {
            Map<FilterResult, List<Slot>> filteredSlotMap = this.nemosInventorySorting$filterBox.filterSlots((NonNullList<Slot>)this.nemosInventorySorting$getThis().getMenu().slots, filter);
            this.nemosInventorySorting$markSlots(filteredSlotMap.get((Object)FilterResult.EXCLUDED), guiGraphics, DIMMED_SLOT);
        }
    }

    @Unique
    private void nemosInventorySorting$initFilter(List<ComponentConfig> configs) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, DefaultConfigValues.ITEM_FILTER);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        this.nemosInventorySorting$filterBoxWidth = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : 1;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        this.nemosInventorySorting$createSearchBox(xOffset, yOffset, this.nemosInventorySorting$filterBoxWidth, config.height(), this.nemosInventorySorting$filterConfig.getFilter());
        this.nemosInventorySorting$createButton(configs, DefaultConfigValues.FILTER_PERSISTENCE_TOGGLE);
    }

    @Unique
    private void nemosInventorySorting$createSearchBox(int xOffset, int yOffset, int width, int height, String filter) {
        this.nemosInventorySorting$filterBox = new FilterBox(this.font, this.leftPos, this.topPos, xOffset, yOffset, width, height, (Component)Component.translatable((String)"nemos_inventory_sorting.itemFilter"));
        this.addRenderableWidget((GuiEventListener)this.nemosInventorySorting$filterBox);
        this.nemosInventorySorting$filterBox.setValue(filter);
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configs, String componentName) {
        Optional<ComponentConfig> optionalComponentConfig = this.nemosInventorySorting$configService.getOrDefaultComponentConfig(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int width = config.width();
        int xOffset = config.xOffset() != null ? config.xOffset() : this.nemosInventorySorting$filterBoxWidth + 3;
        int yOffset = config.yOffset() != null ? config.yOffset() : DefaultConfigValues.Y_OFFSET_ITEM_FILTER;
        MutableComponent buttonName = Component.translatable((String)"nemos_inventory_sorting.gui.toggleFilterPersistence");
        ToggleFilterPersistenceButton button = new ToggleFilterPersistenceButton(this.leftPos + xOffset, this.topPos + yOffset, xOffset, width, config.height(), (Component)buttonName, this.nemosInventorySorting$filterConfig);
        this.addRenderableWidget((GuiEventListener)button);
    }

    @Unique
    private void nemosInventorySorting$markSlots(List<Slot> slots, GuiGraphics guiGraphics, Identifier texture) {
        if (slots == null) {
            return;
        }
        for (Slot slot : slots) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, texture, slot.x, slot.y, 16, 16);
        }
    }

    @Unique
    private boolean nemosInventorySorting$shouldHaveFilter() {
        return !(this.nemosInventorySorting$getThis().getMenu() instanceof CreativeModeInventoryScreen.ItemPickerMenu);
    }

    @Unique
    private AbstractContainerScreen<?> nemosInventorySorting$getThis() {
        return (AbstractContainerScreen)this;
    }
}

